/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal.remote;

import edu.emory.mathcs.util.concurrent.LinkedBlockingQueue;
import java.io.IOException;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import org.testng.remote.ConnectionInfo;

public class SlavePool {
    private static LinkedBlockingQueue m_hosts = new LinkedBlockingQueue();
    private static Map<Socket, ConnectionInfo> m_connectionInfos = new HashMap<Socket, ConnectionInfo>();

    public void addSlaves(Socket[] slaves) throws IOException {
        for (Socket s : slaves) {
            this.addSlave(s);
        }
    }

    public void addSlave(Socket s) {
        ConnectionInfo ci = new ConnectionInfo();
        ci.setSocket(s);
        this.addSlave(s, ci);
    }

    private void addSlave(Socket s, ConnectionInfo ci) {
        m_hosts.add(s);
        m_connectionInfos.put(s, ci);
    }

    public ConnectionInfo getSlave() {
        ConnectionInfo result = null;
        Socket host = null;
        try {
            host = (Socket)m_hosts.take();
            result = m_connectionInfos.get(host);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return result;
    }

    public void returnSlave(ConnectionInfo slave) throws IOException {
        m_hosts.add(slave.getSocket());
    }
}

