/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.testng.IClass;
import org.testng.ITestClass;
import org.testng.ITestMethodFinder;
import org.testng.ITestNGMethod;
import org.testng.TestRunner;
import org.testng.internal.ConfigurationMethod;
import org.testng.internal.RunInfo;
import org.testng.internal.TestNGMethod;
import org.testng.internal.annotations.IAnnotationFinder;

public class TestClass
implements ITestClass {
    private static final long serialVersionUID = -8077917128278361294L;
    private IClass m_iClass = null;
    private Class m_testClass = null;
    private transient IAnnotationFinder m_annotationFinder = null;
    private String m_testName = null;
    private transient ITestMethodFinder m_testMethodFinder = null;
    private ITestNGMethod[] m_beforeClassMethods = null;
    private ITestNGMethod[] m_beforeTestMethods = null;
    private ITestNGMethod[] m_testMethods = null;
    private ITestNGMethod[] m_afterTestMethods = null;
    private ITestNGMethod[] m_afterClassMethods = null;
    private ITestNGMethod[] m_beforeSuiteMethods = null;
    private ITestNGMethod[] m_afterSuiteMethods = null;
    private ITestNGMethod[] m_beforeTestConfMethods = null;
    private ITestNGMethod[] m_afterTestConfMethods = null;
    private ITestNGMethod[] m_beforeGroupsConfMethods = null;
    private ITestNGMethod[] m_afterGroupsConfMethods = null;
    private transient Map<Class, Class> m_testClasses = new HashMap<Class, Class>();
    private transient Map<Class, Object[]> m_instanceMap = new HashMap<Class, Object[]>();
    private RunInfo m_runInfo = null;
    private TestRunner m_testRunner = null;

    public TestClass(IClass cls, String testName, ITestMethodFinder testMethodFinder, IAnnotationFinder annotationFinder, RunInfo runInfo, TestRunner testRunner) {
        this.init(cls, testName, testMethodFinder, annotationFinder, runInfo, testRunner);
    }

    public TestClass(IClass cls, TestClass tc) {
        this.init(cls, tc.getTestName(), tc.getTestMethodFinder(), tc.getAnnotationFinder(), tc.getRunInfo(), tc.getTestRunner());
    }

    public String getTestName() {
        return this.m_testName;
    }

    public IAnnotationFinder getAnnotationFinder() {
        return this.m_annotationFinder;
    }

    private void init(IClass cls, String testName, ITestMethodFinder testMethodFinder, IAnnotationFinder annotationFinder, RunInfo runInfo, TestRunner testRunner) {
        this.log(3, "Creating TestClass for " + cls);
        this.m_iClass = cls;
        this.m_testClass = cls.getRealClass();
        this.m_testName = testName;
        this.m_runInfo = runInfo;
        this.m_testRunner = testRunner;
        this.m_testMethodFinder = testMethodFinder;
        this.m_annotationFinder = annotationFinder;
        this.initMethods();
        this.initTestClassesAndInstances();
    }

    private void initTestClassesAndInstances() {
        Object[] instances;
        for (Object instance : instances = this.getInstances(false)) {
            Class<?> cls = instance.getClass();
            if (null != this.m_testClasses.get(cls)) continue;
            this.m_testClasses.put(cls, cls);
            this.m_instanceMap.put(cls, instances);
        }
    }

    public Object[] getInstances(boolean create) {
        return this.m_iClass.getInstances(create);
    }

    public long[] getInstanceHashCodes() {
        return this.m_iClass.getInstanceHashCodes();
    }

    public int getInstanceCount() {
        return this.m_iClass.getInstanceCount();
    }

    public void addInstance(Object instance) {
        this.m_iClass.addInstance(instance);
    }

    private void initMethods() {
        ITestNGMethod[] methods = this.m_testMethodFinder.getTestMethods(this.m_testClass);
        this.m_testMethods = this.createTestMethods(methods);
        this.m_beforeSuiteMethods = ConfigurationMethod.createSuiteConfigurationMethods(this.m_testMethodFinder.getBeforeSuiteMethods(this.m_testClass), this.m_annotationFinder, true);
        this.m_afterSuiteMethods = ConfigurationMethod.createSuiteConfigurationMethods(this.m_testMethodFinder.getAfterSuiteMethods(this.m_testClass), this.m_annotationFinder, false);
        this.m_beforeTestConfMethods = ConfigurationMethod.createTestConfigurationMethods(this.m_testMethodFinder.getBeforeTestConfigurationMethods(this.m_testClass), this.m_annotationFinder, true);
        this.m_afterTestConfMethods = ConfigurationMethod.createTestConfigurationMethods(this.m_testMethodFinder.getAfterTestConfigurationMethods(this.m_testClass), this.m_annotationFinder, false);
        this.m_beforeClassMethods = ConfigurationMethod.createClassConfigurationMethods(this.m_testMethodFinder.getBeforeClassMethods(this.m_testClass), this.m_annotationFinder, true);
        this.m_afterClassMethods = ConfigurationMethod.createClassConfigurationMethods(this.m_testMethodFinder.getAfterClassMethods(this.m_testClass), this.m_annotationFinder, false);
        this.m_beforeGroupsConfMethods = ConfigurationMethod.createBeforeConfigurationMethods(this.m_testMethodFinder.getBeforeGroupsConfigurationMethods(this.m_testClass), this.m_annotationFinder, true);
        this.m_afterGroupsConfMethods = ConfigurationMethod.createAfterConfigurationMethods(this.m_testMethodFinder.getAfterGroupsConfigurationMethods(this.m_testClass), this.m_annotationFinder, false);
        this.m_beforeTestMethods = ConfigurationMethod.createTestMethodConfigurationMethods(this.m_testMethodFinder.getBeforeTestMethods(this.m_testClass), this.m_annotationFinder, true);
        this.m_afterTestMethods = ConfigurationMethod.createTestMethodConfigurationMethods(this.m_testMethodFinder.getAfterTestMethods(this.m_testClass), this.m_annotationFinder, false);
    }

    private ITestNGMethod[] createTestMethods(ITestNGMethod[] methods) {
        ArrayList<TestNGMethod> vResult = new ArrayList<TestNGMethod>();
        for (ITestNGMethod tm : methods) {
            Method m = tm.getMethod();
            if (m.getDeclaringClass().isAssignableFrom(this.m_testClass)) {
                this.log(3, "Adding method " + tm + " on TestClass " + this.m_testClass);
                vResult.add(new TestNGMethod(m, this.m_annotationFinder));
                continue;
            }
            this.log(3, "Rejecting method " + tm + " for TestClass " + this.m_testClass);
        }
        ITestNGMethod[] result = vResult.toArray(new ITestNGMethod[vResult.size()]);
        return result;
    }

    private TestRunner getTestRunner() {
        return this.m_testRunner;
    }

    private RunInfo getRunInfo() {
        return this.m_runInfo;
    }

    public ITestMethodFinder getTestMethodFinder() {
        return this.m_testMethodFinder;
    }

    private void log(int level, String s) {
        if (TestRunner.getVerbose() >= level) {
            TestClass.ppp(s);
        }
    }

    private static void ppp(String s) {
        System.out.println("[TestClass] " + s);
    }

    public String getName() {
        return this.m_testClass.getName();
    }

    public Class getRealClass() {
        return this.m_testClass;
    }

    public Class[] getTestClasses() {
        return this.m_testClasses.keySet().toArray(new Class[this.m_testClasses.size()]);
    }

    public void dump() {
        TestClass.ppp("\n======\nTESTCLASS: " + this.m_testClass.getName());
        for (ITestNGMethod m : this.m_beforeClassMethods) {
            TestClass.ppp("BeforeClass : " + m);
        }
        for (ITestNGMethod m : this.m_beforeTestMethods) {
            TestClass.ppp("BeforeMethod:\t" + m);
        }
        for (ITestNGMethod m : this.m_testMethods) {
            TestClass.ppp("Test        :\t\t" + m);
        }
        for (ITestNGMethod m : this.m_afterTestMethods) {
            TestClass.ppp("AfterMethod :\t" + m);
        }
        for (ITestNGMethod m : this.m_afterClassMethods) {
            TestClass.ppp("AfterClass  : " + m);
        }
        TestClass.ppp("\n======\n");
    }

    public ITestNGMethod[] getAfterClassMethods() {
        return this.m_afterClassMethods;
    }

    public ITestNGMethod[] getAfterTestMethods() {
        return this.m_afterTestMethods;
    }

    public ITestNGMethod[] getBeforeClassMethods() {
        return this.m_beforeClassMethods;
    }

    public ITestNGMethod[] getBeforeTestMethods() {
        return this.m_beforeTestMethods;
    }

    public ITestNGMethod[] getTestMethods() {
        return this.m_testMethods;
    }

    public ITestNGMethod[] getBeforeSuiteMethods() {
        return this.m_beforeSuiteMethods;
    }

    public ITestNGMethod[] getAfterSuiteMethods() {
        return this.m_afterSuiteMethods;
    }

    public ITestNGMethod[] getBeforeTestConfigurationMethods() {
        return this.m_beforeTestConfMethods;
    }

    public ITestNGMethod[] getAfterTestConfigurationMethods() {
        return this.m_afterTestConfMethods;
    }

    public ITestNGMethod[] getBeforeGroupsMethods() {
        return this.m_beforeGroupsConfMethods;
    }

    public ITestNGMethod[] getAfterGroupsMethods() {
        return this.m_afterGroupsConfMethods;
    }

    public String toString() {
        return "[TestClass " + this.m_testClass + "]";
    }
}

