/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.testng.ITestNGMethod;

public class ClassMethodMap {
    private Map<Class, List<ITestNGMethod>> m_classMap = new HashMap<Class, List<ITestNGMethod>>();

    public ClassMethodMap(ITestNGMethod[] methods) {
        for (ITestNGMethod m : methods) {
            Class c = this.getMethodClass(m);
            List<ITestNGMethod> l = this.m_classMap.get(c);
            if (l == null) {
                l = new ArrayList<ITestNGMethod>();
                this.m_classMap.put(c, l);
            }
            l.add(m);
        }
    }

    public boolean removeAndCheckIfLast(ITestNGMethod m) {
        Class c = this.getMethodClass(m);
        List<ITestNGMethod> l = this.m_classMap.get(c);
        l.remove(m);
        return l.size() == 0;
    }

    private Class getMethodClass(ITestNGMethod m) {
        return m.getTestClass().getRealClass();
    }
}

