/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.concurrent.locks;

import edu.emory.mathcs.util.concurrent.TimeUnit;
import edu.emory.mathcs.util.concurrent.helpers.Utils;
import edu.emory.mathcs.util.concurrent.locks.CondVar;
import edu.emory.mathcs.util.concurrent.locks.Condition;
import edu.emory.mathcs.util.concurrent.locks.Lock;
import edu.emory.mathcs.util.concurrent.locks.ReadWriteLock;
import java.io.Serializable;
import java.util.HashMap;

public class ReentrantReadWriteLock
implements ReadWriteLock,
Serializable {
    private static final long serialVersionUID = -6992448646407690164L;
    int activeReaders_ = 0;
    Thread activeWriter_ = null;
    int waitingReaders_ = 0;
    int waitingWriters_ = 0;
    final ReaderLock readerLock_ = new ReaderLock();
    final WriterLock writerLock_ = new WriterLock();
    int writeHolds_ = 0;
    HashMap readers_ = new HashMap();
    static final Integer IONE;

    public Lock writeLock() {
        return this.writerLock_;
    }

    public Lock readLock() {
        return this.readerLock_;
    }

    synchronized boolean startReadFromNewReader() {
        boolean pass = this.startRead();
        if (!pass) {
            ++this.waitingReaders_;
        }
        return pass;
    }

    synchronized boolean startWriteFromNewWriter() {
        boolean pass = this.startWrite();
        if (!pass) {
            ++this.waitingWriters_;
        }
        return pass;
    }

    synchronized boolean startReadFromWaitingReader() {
        boolean pass = this.startRead();
        if (pass) {
            --this.waitingReaders_;
        }
        return pass;
    }

    synchronized boolean startWriteFromWaitingWriter() {
        boolean pass = this.startWrite();
        if (pass) {
            --this.waitingWriters_;
        }
        return pass;
    }

    synchronized void cancelledWaitingReader() {
        --this.waitingReaders_;
    }

    synchronized void cancelledWaitingWriter() {
        --this.waitingWriters_;
    }

    boolean allowReader() {
        return this.activeWriter_ == null && this.waitingWriters_ == 0 || this.activeWriter_ == Thread.currentThread();
    }

    synchronized boolean startRead() {
        Thread t = Thread.currentThread();
        Object c = this.readers_.get(t);
        if (c != null) {
            this.readers_.put(t, new Integer((Integer)c + 1));
            ++this.activeReaders_;
            return true;
        }
        if (this.allowReader()) {
            this.readers_.put(t, IONE);
            ++this.activeReaders_;
            return true;
        }
        return false;
    }

    synchronized boolean startWrite() {
        if (this.activeWriter_ == Thread.currentThread()) {
            ++this.writeHolds_;
            return true;
        }
        if (this.writeHolds_ == 0) {
            if (this.activeReaders_ == 0 || this.readers_.size() == 1 && this.readers_.get(Thread.currentThread()) != null) {
                this.activeWriter_ = Thread.currentThread();
                this.writeHolds_ = 1;
                return true;
            }
            return false;
        }
        return false;
    }

    synchronized Signaller endRead() {
        Thread t = Thread.currentThread();
        Object c = this.readers_.get(t);
        if (c == null) {
            throw new IllegalThreadStateException();
        }
        --this.activeReaders_;
        if (c != IONE) {
            int h = (Integer)c - 1;
            Integer ih = h == 1 ? IONE : new Integer(h);
            this.readers_.put(t, ih);
            return null;
        }
        this.readers_.remove(t);
        if (this.writeHolds_ > 0) {
            return null;
        }
        if (this.activeReaders_ == 0 && this.waitingWriters_ > 0) {
            return this.writerLock_;
        }
        return null;
    }

    synchronized Signaller endWrite() {
        if (this.activeWriter_ != Thread.currentThread()) {
            throw new IllegalMonitorStateException();
        }
        --this.writeHolds_;
        if (this.writeHolds_ > 0) {
            return null;
        }
        this.activeWriter_ = null;
        if (this.waitingReaders_ > 0 && this.allowReader()) {
            return this.readerLock_;
        }
        if (this.waitingWriters_ > 0) {
            return this.writerLock_;
        }
        return null;
    }

    public final boolean isFair() {
        return false;
    }

    protected synchronized Thread getOwner() {
        return this.activeWriter_;
    }

    public synchronized int getReadLockCount() {
        return this.activeReaders_;
    }

    public synchronized boolean isWriteLocked() {
        return this.activeWriter_ != null;
    }

    public synchronized boolean isWriteLockedByCurrentThread() {
        return this.activeWriter_ == Thread.currentThread();
    }

    public synchronized int getWriteHoldCount() {
        return this.writeHolds_;
    }

    public final synchronized int getQueueLength() {
        return this.waitingWriters_ + this.waitingReaders_;
    }

    public synchronized String toString() {
        return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(super.toString()))).append("[Write locks = ").append(this.getWriteHoldCount()).append(", Read locks = ").append(this.getReadLockCount()).append("]")));
    }

    static {
        serialVersionUID = -6992448646407690164L;
        IONE = new Integer(1);
    }

    class WriterLock
    implements Signaller,
    Lock,
    Serializable,
    CondVar.LockInfo {
        WriterLock() {
        }

        public void lock() {
            boolean wasInterrupted = false;
            while (true) {
                try {
                    this.lockInterruptibly();
                    if (wasInterrupted) {
                        Thread.currentThread().interrupt();
                    }
                    return;
                }
                catch (InterruptedException e) {
                    wasInterrupted = true;
                    continue;
                }
                break;
            }
        }

        public void lockInterruptibly() throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            InterruptedException ie = null;
            WriterLock writerLock = this;
            synchronized (writerLock) {
                if (!ReentrantReadWriteLock.this.startWriteFromNewWriter()) {
                    try {
                        do {
                            this.wait();
                        } while (!ReentrantReadWriteLock.this.startWriteFromWaitingWriter());
                        return;
                    }
                    catch (InterruptedException ex) {
                        ReentrantReadWriteLock.this.cancelledWaitingWriter();
                        this.notify();
                        ie = ex;
                    }
                }
            }
            if (ie != null) {
                ReentrantReadWriteLock.this.readerLock_.signalWaiters();
                throw ie;
            }
        }

        public void unlock() {
            Signaller s = ReentrantReadWriteLock.this.endWrite();
            if (s != null) {
                s.signalWaiters();
            }
        }

        public synchronized void signalWaiters() {
            this.notify();
        }

        public boolean tryLock() {
            return ReentrantReadWriteLock.this.startWrite();
        }

        public boolean tryLock(long timeout, TimeUnit unit) throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            InterruptedException ie = null;
            long nanos = unit.toNanos(timeout);
            WriterLock writerLock = this;
            synchronized (writerLock) {
                block10: {
                    if (nanos <= (long)0) {
                        boolean bl = ReentrantReadWriteLock.this.startWrite();
                        return bl;
                    }
                    if (ReentrantReadWriteLock.this.startWriteFromNewWriter()) {
                        boolean bl = true;
                        return bl;
                    }
                    long deadline = Utils.nanoTime() + nanos;
                    do {
                        try {
                            TimeUnit.NANOSECONDS.timedWait(this, nanos);
                        }
                        catch (InterruptedException ex) {
                            ReentrantReadWriteLock.this.cancelledWaitingWriter();
                            this.notify();
                            ie = ex;
                            break block10;
                        }
                        if (!ReentrantReadWriteLock.this.startWriteFromWaitingWriter()) continue;
                        boolean bl = true;
                        return bl;
                    } while ((nanos = deadline - Utils.nanoTime()) > (long)0);
                    ReentrantReadWriteLock.this.cancelledWaitingWriter();
                    this.notify();
                }
            }
            ReentrantReadWriteLock.this.readerLock_.signalWaiters();
            if (ie != null) {
                throw ie;
            }
            return false;
        }

        public Condition newCondition() {
            return new CondVar(this);
        }

        public String toString() {
            Thread owner = ReentrantReadWriteLock.this.getOwner();
            return String.valueOf(String.valueOf(super.toString())).concat(String.valueOf(String.valueOf(owner == null ? "[Unlocked]" : String.valueOf(String.valueOf(new StringBuffer("[Locked by thread ").append(owner.getName()).append("]"))))));
        }

        public boolean isHeldByCurrentThread() {
            return ReentrantReadWriteLock.this.isWriteLockedByCurrentThread();
        }
    }

    class ReaderLock
    implements Signaller,
    Lock,
    Serializable {
        ReaderLock() {
        }

        public void lock() {
            boolean wasInterrupted = false;
            while (true) {
                try {
                    this.lockInterruptibly();
                    if (wasInterrupted) {
                        Thread.currentThread().interrupt();
                    }
                    return;
                }
                catch (InterruptedException e) {
                    wasInterrupted = true;
                    continue;
                }
                break;
            }
        }

        public void lockInterruptibly() throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            InterruptedException ie = null;
            ReaderLock readerLock = this;
            synchronized (readerLock) {
                if (!ReentrantReadWriteLock.this.startReadFromNewReader()) {
                    try {
                        do {
                            this.wait();
                        } while (!ReentrantReadWriteLock.this.startReadFromWaitingReader());
                        return;
                    }
                    catch (InterruptedException ex) {
                        ReentrantReadWriteLock.this.cancelledWaitingReader();
                        ie = ex;
                    }
                }
            }
            if (ie != null) {
                ReentrantReadWriteLock.this.writerLock_.signalWaiters();
                throw ie;
            }
        }

        public void unlock() {
            Signaller s = ReentrantReadWriteLock.this.endRead();
            if (s != null) {
                s.signalWaiters();
            }
        }

        public synchronized void signalWaiters() {
            this.notifyAll();
        }

        public boolean tryLock() {
            return ReentrantReadWriteLock.this.startRead();
        }

        public boolean tryLock(long timeout, TimeUnit unit) throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            InterruptedException ie = null;
            long nanos = unit.toNanos(timeout);
            ReaderLock readerLock = this;
            synchronized (readerLock) {
                block10: {
                    if (nanos <= (long)0) {
                        boolean bl = ReentrantReadWriteLock.this.startRead();
                        return bl;
                    }
                    if (ReentrantReadWriteLock.this.startReadFromNewReader()) {
                        boolean bl = true;
                        return bl;
                    }
                    long deadline = Utils.nanoTime() + nanos;
                    do {
                        try {
                            TimeUnit.NANOSECONDS.timedWait(this, nanos);
                        }
                        catch (InterruptedException ex) {
                            ReentrantReadWriteLock.this.cancelledWaitingReader();
                            ie = ex;
                            break block10;
                        }
                        if (!ReentrantReadWriteLock.this.startReadFromWaitingReader()) continue;
                        boolean bl = true;
                        return bl;
                    } while ((nanos = deadline - Utils.nanoTime()) > (long)0);
                    ReentrantReadWriteLock.this.cancelledWaitingReader();
                }
            }
            ReentrantReadWriteLock.this.writerLock_.signalWaiters();
            if (ie != null) {
                throw ie;
            }
            return false;
        }

        public Condition newCondition() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            int r = ReentrantReadWriteLock.this.getReadLockCount();
            return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(super.toString()))).append("[Read locks = ").append(r).append("]")));
        }
    }

    static interface Signaller {
        public void signalWaiters();
    }
}

