/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.concurrent.locks;

import edu.emory.mathcs.util.concurrent.TimeUnit;
import edu.emory.mathcs.util.concurrent.helpers.FIFOWaitQueue;
import edu.emory.mathcs.util.concurrent.helpers.Utils;
import edu.emory.mathcs.util.concurrent.helpers.WaitQueue;
import edu.emory.mathcs.util.concurrent.locks.CondVar;
import edu.emory.mathcs.util.concurrent.locks.Condition;
import edu.emory.mathcs.util.concurrent.locks.Lock;
import java.io.Serializable;
import java.util.Collection;

public class ReentrantLock
implements Lock,
Serializable,
CondVar.LockInfo {
    private static final long serialVersionUID = 7373984872572414699L;
    private final Impl impl;
    private static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$edu$emory$mathcs$util$concurrent$locks$ReentrantLock;

    public ReentrantLock() {
        this.impl = new NonfairImpl();
    }

    public ReentrantLock(boolean fair) {
        this.impl = fair ? new FairImpl() : new NonfairImpl();
    }

    public void lock() {
        boolean wasInterrupted = false;
        while (true) {
            try {
                this.impl.lockInterruptibly();
                if (wasInterrupted) {
                    Thread.currentThread().interrupt();
                }
                return;
            }
            catch (InterruptedException e) {
                wasInterrupted = true;
                continue;
            }
            break;
        }
    }

    public void lockInterruptibly() throws InterruptedException {
        this.impl.lockInterruptibly();
    }

    public boolean tryLock() {
        return this.impl.tryLock();
    }

    public boolean tryLock(long timeout, TimeUnit unit) throws InterruptedException {
        return this.impl.tryLock(unit.toNanos(timeout));
    }

    public void unlock() {
        this.impl.unlock();
    }

    public Condition newCondition() {
        return new CondVar(this);
    }

    public int getHoldCount() {
        return this.impl.getHoldCount();
    }

    public boolean isHeldByCurrentThread() {
        return this.impl.isHeldByCurrentThread();
    }

    public boolean isLocked() {
        return this.impl.isLocked();
    }

    public final boolean isFair() {
        return this.impl.isFair();
    }

    protected Thread getOwner() {
        return this.impl.getOwner();
    }

    public final boolean hasQueuedThreads() {
        return this.impl.hasQueuedThreads();
    }

    public final boolean hasQueuedThread(Thread thread) {
        return this.impl.isQueued(thread);
    }

    public final int getQueueLength() {
        return this.impl.getQueueLength();
    }

    protected Collection getQueuedThreads() {
        return this.impl.getQueuedThreads();
    }

    public String toString() {
        Thread owner = this.getOwner();
        return String.valueOf(String.valueOf(super.toString())).concat(String.valueOf(String.valueOf(owner == null ? "[Unlocked]" : String.valueOf(String.valueOf(new StringBuffer("[Locked by thread ").append(owner.getName()).append("]"))))));
    }

    static Class class$(String x$0) {
        try {
            return Class.forName(x$0);
        }
        catch (ClassNotFoundException x$02) {
            throw new NoClassDefFoundError(x$02.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$edu$emory$mathcs$util$concurrent$locks$ReentrantLock == null ? (class$edu$emory$mathcs$util$concurrent$locks$ReentrantLock = ReentrantLock.class$("edu.emory.mathcs.util.concurrent.locks.ReentrantLock")) : class$edu$emory$mathcs$util$concurrent$locks$ReentrantLock).desiredAssertionStatus();
        serialVersionUID = 7373984872572414699L;
    }

    static class FairImpl
    extends Impl
    implements WaitQueue.QueuedSync,
    Serializable {
        private final WaitQueue wq_ = new FIFOWaitQueue();
        private static final /* synthetic */ boolean $assertionsDisabled;

        FairImpl() {
        }

        public synchronized boolean recheck(WaitQueue.WaitNode node) {
            Thread caller = Thread.currentThread();
            if (caller == this.owner_) {
                ++this.holds_;
                return true;
            }
            if (this.owner_ == null) {
                this.owner_ = caller;
                this.holds_ = 1;
                return true;
            }
            this.wq_.insert(node);
            return false;
        }

        public void lockInterruptibly() throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            Thread caller = Thread.currentThread();
            FairImpl fairImpl = this;
            synchronized (fairImpl) {
                if (caller == this.owner_) {
                    ++this.holds_;
                    return;
                }
                if (this.owner_ == null) {
                    this.owner_ = caller;
                    this.holds_ = 1;
                    return;
                }
            }
            WaitQueue.WaitNode n = new WaitQueue.WaitNode();
            n.doWait(this);
            FairImpl fairImpl2 = this;
            synchronized (fairImpl2) {
                if (!$assertionsDisabled && this.owner_ != null) {
                    throw new AssertionError();
                }
                this.owner_ = caller;
                this.holds_ = 1;
            }
        }

        public boolean tryLock(long nanos) throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            Thread caller = Thread.currentThread();
            FairImpl fairImpl = this;
            synchronized (fairImpl) {
                if (caller == this.owner_) {
                    ++this.holds_;
                    boolean bl = true;
                    return bl;
                }
                if (this.owner_ == null) {
                    this.owner_ = caller;
                    this.holds_ = 1;
                    boolean bl = true;
                    return bl;
                }
            }
            WaitQueue.WaitNode n = new WaitQueue.WaitNode();
            if (n.doTimedWait(this, nanos)) {
                FairImpl fairImpl2 = this;
                synchronized (fairImpl2) {
                    if (!$assertionsDisabled && this.owner_ != null) {
                        throw new AssertionError();
                    }
                    this.owner_ = caller;
                    this.holds_ = 1;
                }
                return true;
            }
            return false;
        }

        public void unlock() {
            boolean signal = false;
            FairImpl fairImpl = this;
            synchronized (fairImpl) {
                if (Thread.currentThread() != this.owner_) {
                    throw new IllegalMonitorStateException("Not owner");
                }
                if (--this.holds_ == 0) {
                    this.owner_ = null;
                    signal = true;
                }
            }
            if (signal) {
                WaitQueue.WaitNode n;
                do {
                    if ((n = this.wq_.extract()) != null) continue;
                    return;
                } while (!n.signal());
                return;
            }
        }

        public final boolean isFair() {
            return true;
        }

        public synchronized boolean hasQueuedThreads() {
            return this.wq_.hasNodes();
        }

        public synchronized int getQueueLength() {
            return this.wq_.getLength();
        }

        public synchronized Collection getQueuedThreads() {
            return this.wq_.getWaitingThreads();
        }

        public synchronized boolean isQueued(Thread thread) {
            return this.wq_.isWaiting(thread);
        }

        static {
            $assertionsDisabled = !(class$edu$emory$mathcs$util$concurrent$locks$ReentrantLock == null ? (class$edu$emory$mathcs$util$concurrent$locks$ReentrantLock = ReentrantLock.class$("edu.emory.mathcs.util.concurrent.locks.ReentrantLock")) : class$edu$emory$mathcs$util$concurrent$locks$ReentrantLock).desiredAssertionStatus();
        }
    }

    static class NonfairImpl
    extends Impl
    implements Serializable {
        NonfairImpl() {
        }

        public void lockInterruptibly() throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            Thread caller = Thread.currentThread();
            NonfairImpl nonfairImpl = this;
            synchronized (nonfairImpl) {
                if (caller == this.owner_) {
                    ++this.holds_;
                } else {
                    try {
                        while (this.owner_ != null) {
                            this.wait();
                        }
                        this.owner_ = caller;
                        this.holds_ = 1;
                    }
                    catch (InterruptedException ex) {
                        this.notify();
                        throw ex;
                    }
                }
            }
        }

        public boolean tryLock(long nanos) throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            Thread caller = Thread.currentThread();
            NonfairImpl nonfairImpl = this;
            synchronized (nonfairImpl) {
                if (caller == this.owner_) {
                    ++this.holds_;
                    boolean bl = true;
                    return bl;
                }
                if (this.owner_ == null) {
                    this.owner_ = caller;
                    this.holds_ = 1;
                    boolean bl = true;
                    return bl;
                }
                if (nanos <= (long)0) {
                    boolean bl = false;
                    return bl;
                }
                long deadline = Utils.nanoTime() + nanos;
                try {
                    do {
                        TimeUnit.NANOSECONDS.timedWait(this, nanos);
                        if (caller == this.owner_) {
                            ++this.holds_;
                            boolean bl = true;
                            return bl;
                        }
                        if (this.owner_ != null) continue;
                        this.owner_ = caller;
                        this.holds_ = 1;
                        boolean bl = true;
                        return bl;
                    } while ((nanos = deadline - Utils.nanoTime()) > (long)0);
                    boolean bl = false;
                    return bl;
                }
                catch (InterruptedException ex) {
                    this.notify();
                    throw ex;
                }
            }
        }

        public synchronized void unlock() {
            if (Thread.currentThread() != this.owner_) {
                throw new IllegalMonitorStateException("Not owner");
            }
            if (--this.holds_ == 0) {
                this.owner_ = null;
                this.notify();
            }
        }

        public final boolean isFair() {
            return false;
        }
    }

    static abstract class Impl {
        protected Thread owner_ = null;
        protected int holds_ = 0;

        protected Impl() {
        }

        public abstract void lockInterruptibly() throws InterruptedException;

        public boolean tryLock() {
            Thread caller = Thread.currentThread();
            Impl impl = this;
            synchronized (impl) {
                if (caller == this.owner_) {
                    ++this.holds_;
                    boolean bl = true;
                    return bl;
                }
                if (this.owner_ == null) {
                    this.owner_ = caller;
                    this.holds_ = 1;
                    boolean bl = true;
                    return bl;
                }
            }
            return false;
        }

        public abstract boolean tryLock(long var1) throws InterruptedException;

        public abstract void unlock();

        public synchronized int getHoldCount() {
            return this.isHeldByCurrentThread() ? this.holds_ : 0;
        }

        public synchronized boolean isHeldByCurrentThread() {
            return Thread.currentThread() == this.owner_;
        }

        public synchronized boolean isLocked() {
            return this.owner_ != null;
        }

        public abstract boolean isFair();

        protected synchronized Thread getOwner() {
            return this.owner_;
        }

        public boolean hasQueuedThreads() {
            throw new UnsupportedOperationException("Use FAIR version");
        }

        public int getQueueLength() {
            throw new UnsupportedOperationException("Use FAIR version");
        }

        public Collection getQueuedThreads() {
            throw new UnsupportedOperationException("Use FAIR version");
        }

        public boolean isQueued(Thread thread) {
            throw new UnsupportedOperationException("Use FAIR version");
        }
    }
}

