/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.concurrent.locks;

import edu.emory.mathcs.util.concurrent.TimeUnit;
import edu.emory.mathcs.util.concurrent.helpers.Utils;
import edu.emory.mathcs.util.concurrent.locks.Condition;
import edu.emory.mathcs.util.concurrent.locks.Lock;
import java.io.Serializable;
import java.util.Date;

class CondVar
implements Condition,
Serializable {
    protected final LockInfo lock;

    CondVar(LockInfo lock) {
        this.lock = lock;
    }

    public void awaitUninterruptibly() {
        boolean wasInterrupted = false;
        while (true) {
            try {
                this.await();
                if (wasInterrupted) {
                    Thread.currentThread().interrupt();
                }
                return;
            }
            catch (InterruptedException e) {
                wasInterrupted = true;
                continue;
            }
            break;
        }
    }

    public void await() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        try {
            CondVar condVar = this;
            synchronized (condVar) {
                this.lock.unlock();
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {
                    this.notify();
                    throw ex;
                }
            }
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.lock.lock();
            throw throwable;
        }
        this.lock.lock();
    }

    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        long nanos = unit.toNanos(timeout);
        boolean success = false;
        try {
            CondVar condVar = this;
            synchronized (condVar) {
                this.lock.unlock();
                try {
                    if (nanos > (long)0) {
                        long start = Utils.nanoTime();
                        TimeUnit.NANOSECONDS.timedWait(this, nanos);
                        success = Utils.nanoTime() - start < nanos;
                    }
                }
                catch (InterruptedException ex) {
                    this.notify();
                    throw ex;
                }
            }
            Object var11_8 = null;
        }
        catch (Throwable throwable) {
            Object var11_9 = null;
            this.lock.lock();
            throw throwable;
        }
        this.lock.lock();
        return success;
    }

    public boolean awaitUntil(Date deadline) throws InterruptedException {
        if (deadline == null) {
            throw new NullPointerException();
        }
        long abstime = deadline.getTime();
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        boolean success = false;
        try {
            CondVar condVar = this;
            synchronized (condVar) {
                this.lock.unlock();
                try {
                    long start = System.currentTimeMillis();
                    long msecs = abstime - start;
                    if (msecs > (long)0) {
                        this.wait(msecs);
                        success = System.currentTimeMillis() - start < msecs;
                    }
                }
                catch (InterruptedException ex) {
                    this.notify();
                    throw ex;
                }
            }
            Object var11_8 = null;
        }
        catch (Throwable throwable) {
            Object var11_9 = null;
            this.lock.lock();
            throw throwable;
        }
        this.lock.lock();
        return success;
    }

    public synchronized void signal() {
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        this.notify();
    }

    public synchronized void signalAll() {
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        this.notifyAll();
    }

    static interface LockInfo
    extends Lock {
        public boolean isHeldByCurrentThread();
    }
}

