/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.concurrent.atomic;

import java.io.Serializable;

public class AtomicLong
extends Number
implements Serializable {
    private static final long serialVersionUID = 1927816293512124184L;
    private long value;

    public AtomicLong(long initialValue) {
        this.value = initialValue;
    }

    public AtomicLong() {
    }

    public final synchronized long get() {
        return this.value;
    }

    public final synchronized void set(long newValue) {
        this.value = newValue;
    }

    public final synchronized long getAndSet(long newValue) {
        long old = this.value;
        this.value = newValue;
        return old;
    }

    public final synchronized boolean compareAndSet(long expect, long update) {
        boolean success;
        boolean bl = success = expect == this.value;
        if (success) {
            this.value = update;
        }
        return success;
    }

    public final synchronized boolean weakCompareAndSet(long expect, long update) {
        boolean success;
        boolean bl = success = expect == this.value;
        if (success) {
            this.value = update;
        }
        return success;
    }

    public final synchronized long getAndIncrement() {
        return this.value++;
    }

    public final synchronized long getAndDecrement() {
        return this.value--;
    }

    public final synchronized long getAndAdd(long delta) {
        long old = this.value;
        this.value += delta;
        return old;
    }

    public final synchronized long incrementAndGet() {
        return ++this.value;
    }

    public final synchronized long decrementAndGet() {
        return --this.value;
    }

    public final synchronized long addAndGet(long delta) {
        return this.value += delta;
    }

    public String toString() {
        return Long.toString(this.get());
    }

    public int intValue() {
        return (int)this.get();
    }

    public long longValue() {
        return this.get();
    }

    public float floatValue() {
        return this.get();
    }

    public double doubleValue() {
        return this.get();
    }

    static {
        serialVersionUID = 1927816293512124184L;
    }
}

