/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.concurrent.atomic;

import java.io.Serializable;

public class AtomicBoolean
implements Serializable {
    private static final long serialVersionUID = 4654671469794556979L;
    private int value;

    public AtomicBoolean(boolean initialValue) {
        this.value = initialValue ? 1 : 0;
    }

    public AtomicBoolean() {
    }

    public final synchronized boolean get() {
        return this.value != 0;
    }

    public final synchronized boolean compareAndSet(boolean expect, boolean update) {
        boolean success;
        boolean bl = success = expect == (this.value != 0);
        if (success) {
            this.value = update ? 1 : 0;
        }
        return success;
    }

    public synchronized boolean weakCompareAndSet(boolean expect, boolean update) {
        boolean success;
        boolean bl = success = expect == (this.value != 0);
        if (success) {
            this.value = update ? 1 : 0;
        }
        return success;
    }

    public final synchronized void set(boolean newValue) {
        this.value = newValue ? 1 : 0;
    }

    public final synchronized boolean getAndSet(boolean newValue) {
        int old = this.value;
        this.value = newValue ? 1 : 0;
        return old != 0;
    }

    public String toString() {
        return Boolean.toString(this.get());
    }

    static {
        serialVersionUID = 4654671469794556979L;
    }
}

