/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.concurrent;

import edu.emory.mathcs.util.concurrent.AbstractExecutorService;
import edu.emory.mathcs.util.concurrent.BlockingQueue;
import edu.emory.mathcs.util.concurrent.Executors;
import edu.emory.mathcs.util.concurrent.Future;
import edu.emory.mathcs.util.concurrent.RejectedExecutionException;
import edu.emory.mathcs.util.concurrent.RejectedExecutionHandler;
import edu.emory.mathcs.util.concurrent.ThreadFactory;
import edu.emory.mathcs.util.concurrent.TimeUnit;
import edu.emory.mathcs.util.concurrent.helpers.Utils;
import edu.emory.mathcs.util.concurrent.locks.Condition;
import edu.emory.mathcs.util.concurrent.locks.ReentrantLock;
import java.security.AccessController;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class ThreadPoolExecutor
extends AbstractExecutorService {
    private static final Runnable[] EMPTY_RUNNABLE_ARRAY;
    private static final RuntimePermission shutdownPerm;
    private final BlockingQueue workQueue;
    private final ReentrantLock mainLock = new ReentrantLock();
    private final Condition termination = this.mainLock.newCondition();
    private final HashSet workers = new HashSet();
    private volatile long keepAliveTime;
    private volatile int corePoolSize;
    private volatile int maximumPoolSize;
    private volatile int poolSize;
    volatile int runState;
    static final int RUNNING = 0;
    static final int SHUTDOWN = 1;
    static final int STOP = 2;
    static final int TERMINATED = 3;
    private volatile RejectedExecutionHandler handler;
    private volatile ThreadFactory threadFactory;
    private int largestPoolSize;
    private long completedTaskCount;
    private static final RejectedExecutionHandler defaultHandler;
    private static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$edu$emory$mathcs$util$concurrent$ThreadPoolExecutor;

    void reject(Runnable command) {
        this.handler.rejectedExecution(command, this);
    }

    private Thread addThread(Runnable firstTask) {
        Worker w = new Worker(firstTask);
        Thread t = this.threadFactory.newThread(w);
        if (t != null) {
            w.thread = t;
            this.workers.add(w);
            int nt = ++this.poolSize;
            if (nt > this.largestPoolSize) {
                this.largestPoolSize = nt;
            }
        }
        return t;
    }

    private boolean addIfUnderCorePoolSize(Runnable firstTask) {
        Thread t = null;
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            if (this.poolSize < this.corePoolSize) {
                t = this.addThread(firstTask);
            }
            Object var5_4 = null;
            mainLock.unlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            mainLock.unlock();
            throw throwable;
        }
        if (t == null) {
            return false;
        }
        t.start();
        return true;
    }

    private Runnable addIfUnderMaximumPoolSize(Runnable firstTask) {
        Thread t = null;
        Runnable next = null;
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            if (this.poolSize < this.maximumPoolSize) {
                next = (Runnable)this.workQueue.poll();
                if (next == null) {
                    next = firstTask;
                }
                t = this.addThread(next);
            }
            Object var6_5 = null;
            mainLock.unlock();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            mainLock.unlock();
            throw throwable;
        }
        if (t == null) {
            return null;
        }
        t.start();
        return next;
    }

    Runnable getTask() throws InterruptedException {
        block7: while (true) {
            switch (this.runState) {
                case 0: {
                    if (this.poolSize <= this.corePoolSize) {
                        return (Runnable)this.workQueue.take();
                    }
                    long timeout = this.keepAliveTime;
                    if (timeout <= (long)0) {
                        return null;
                    }
                    Runnable r = (Runnable)this.workQueue.poll(timeout, TimeUnit.NANOSECONDS);
                    if (r != null) {
                        return r;
                    }
                    if (this.poolSize <= this.corePoolSize) continue block7;
                    return null;
                }
                case 1: {
                    Runnable r = (Runnable)this.workQueue.poll();
                    if (r != null) {
                        return r;
                    }
                    if (this.workQueue.isEmpty()) {
                        this.interruptIdleWorkers();
                        return null;
                    }
                    try {
                        Runnable runnable = (Runnable)this.workQueue.take();
                        return runnable;
                    }
                    catch (InterruptedException interruptedException) {
                        continue block7;
                    }
                }
                case 2: {
                    return null;
                }
            }
            if (!$assertionsDisabled) break;
        }
        throw new AssertionError();
    }

    void interruptIdleWorkers() {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            Iterator w = this.workers.iterator();
            while (w.hasNext()) {
                ((Worker)w.next()).interruptIfIdle();
            }
            Object var4_3 = null;
            mainLock.unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            mainLock.unlock();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void workerDone(Worker w) {
        ReentrantLock mainLock;
        block11: {
            block10: {
                block9: {
                    mainLock = this.mainLock;
                    mainLock.lock();
                    try {
                        this.completedTaskCount += w.completedTasks;
                        this.workers.remove(w);
                        if (--this.poolSize > 0) {
                            Object var6_3 = null;
                            mainLock.unlock();
                            return;
                        }
                        int state = this.runState;
                        if (!$assertionsDisabled && state == 3) {
                            throw new AssertionError();
                        }
                        if (state != 2) {
                            if (!this.workQueue.isEmpty()) {
                                Thread t = this.addThread(null);
                                if (t != null) {
                                    t.start();
                                }
                                break block9;
                            }
                            if (state == 0) {
                                break block10;
                            }
                        }
                        this.termination.signalAll();
                        this.runState = 3;
                        break block11;
                    }
                    catch (Throwable throwable) {
                        Object var6_7 = null;
                        mainLock.unlock();
                        throw throwable;
                    }
                }
                Object var6_4 = null;
                mainLock.unlock();
                return;
            }
            Object var6_5 = null;
            mainLock.unlock();
            return;
        }
        Object var6_6 = null;
        mainLock.unlock();
        if (!$assertionsDisabled && this.runState != 3) {
            throw new AssertionError();
        }
        this.terminated();
    }

    public ThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue workQueue) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, Executors.defaultThreadFactory(), defaultHandler);
    }

    public ThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue workQueue, ThreadFactory threadFactory) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, defaultHandler);
    }

    public ThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue workQueue, RejectedExecutionHandler handler) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, Executors.defaultThreadFactory(), handler);
    }

    public ThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        if (corePoolSize < 0 || maximumPoolSize <= 0 || maximumPoolSize < corePoolSize || keepAliveTime < (long)0) {
            throw new IllegalArgumentException();
        }
        if (workQueue == null || threadFactory == null || handler == null) {
            throw new NullPointerException();
        }
        this.corePoolSize = corePoolSize;
        this.maximumPoolSize = maximumPoolSize;
        this.workQueue = workQueue;
        this.keepAliveTime = unit.toNanos(keepAliveTime);
        this.threadFactory = threadFactory;
        this.handler = handler;
    }

    public void execute(Runnable command) {
        Runnable r;
        if (command == null) {
            throw new NullPointerException();
        }
        do {
            if (this.runState != 0) {
                this.reject(command);
                return;
            }
            if (this.poolSize < this.corePoolSize && this.addIfUnderCorePoolSize(command)) {
                return;
            }
            if (this.workQueue.offer(command)) {
                return;
            }
            r = this.addIfUnderMaximumPoolSize(command);
            if (r != command) continue;
            return;
        } while (r != null);
        this.reject(command);
    }

    public void shutdown() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            AccessController.checkPermission(shutdownPerm);
        }
        boolean fullyTerminated = false;
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            if (this.workers.size() > 0) {
                int state;
                if (security != null) {
                    Iterator i = this.workers.iterator();
                    while (i.hasNext()) {
                        Worker w = (Worker)i.next();
                        security.checkAccess(w.thread);
                    }
                }
                if ((state = this.runState) == 0) {
                    this.runState = 1;
                }
                try {
                    Iterator i = this.workers.iterator();
                    while (i.hasNext()) {
                        Worker w = (Worker)i.next();
                        w.interruptIfIdle();
                    }
                }
                catch (SecurityException se) {
                    this.runState = state;
                    throw se;
                }
            } else {
                fullyTerminated = true;
                this.runState = 3;
                this.termination.signalAll();
            }
            Object var8_9 = null;
            mainLock.unlock();
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            mainLock.unlock();
            throw throwable;
        }
        if (fullyTerminated) {
            this.terminated();
        }
    }

    public List shutdownNow() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            AccessController.checkPermission(shutdownPerm);
        }
        boolean fullyTerminated = false;
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            if (this.workers.size() > 0) {
                int state;
                if (security != null) {
                    Iterator w = this.workers.iterator();
                    while (w.hasNext()) {
                        security.checkAccess(((Worker)w.next()).thread);
                    }
                }
                if ((state = this.runState) != 3) {
                    this.runState = 2;
                }
                try {
                    Iterator w = this.workers.iterator();
                    while (w.hasNext()) {
                        ((Worker)w.next()).interruptNow();
                    }
                }
                catch (SecurityException se) {
                    this.runState = state;
                    throw se;
                }
            } else {
                fullyTerminated = true;
                this.runState = 3;
                this.termination.signalAll();
            }
            Object var7_8 = null;
            mainLock.unlock();
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            mainLock.unlock();
            throw throwable;
        }
        if (fullyTerminated) {
            this.terminated();
        }
        return Arrays.asList(this.workQueue.toArray(EMPTY_RUNNABLE_ARRAY));
    }

    public boolean isShutdown() {
        return this.runState != 0;
    }

    public boolean isTerminating() {
        return this.runState == 2;
    }

    public boolean isTerminated() {
        return this.runState == 3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        boolean bl;
        long nanos = unit.toNanos(timeout);
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            long deadline = Utils.nanoTime() + nanos;
            while (true) {
                if (this.runState == 3) {
                    boolean bl2 = true;
                    Object var11_8 = null;
                    mainLock.unlock();
                    return bl2;
                }
                if (nanos <= (long)0) {
                    bl = false;
                    break;
                }
                this.termination.await(nanos, TimeUnit.NANOSECONDS);
                nanos = deadline - Utils.nanoTime();
            }
        }
        catch (Throwable throwable) {
            Object var11_10 = null;
            mainLock.unlock();
            throw throwable;
        }
        Object var11_9 = null;
        mainLock.unlock();
        return bl;
    }

    protected void finalize() {
        this.shutdown();
    }

    public void setThreadFactory(ThreadFactory threadFactory) {
        if (threadFactory == null) {
            throw new NullPointerException();
        }
        this.threadFactory = threadFactory;
    }

    public ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    public void setRejectedExecutionHandler(RejectedExecutionHandler handler) {
        if (handler == null) {
            throw new NullPointerException();
        }
        this.handler = handler;
    }

    public RejectedExecutionHandler getRejectedExecutionHandler() {
        return this.handler;
    }

    public BlockingQueue getQueue() {
        return this.workQueue;
    }

    public boolean remove(Runnable task) {
        return this.getQueue().remove(task);
    }

    public void purge() {
        try {
            Iterator it = this.getQueue().iterator();
            while (it.hasNext()) {
                Future c;
                Runnable r = (Runnable)it.next();
                if (!(r instanceof Future) || !(c = (Future)((Object)r)).isCancelled()) continue;
                it.remove();
            }
        }
        catch (ConcurrentModificationException ex) {
            return;
        }
    }

    public void setCorePoolSize(int corePoolSize) {
        if (corePoolSize < 0) {
            throw new IllegalArgumentException();
        }
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            int extra = this.corePoolSize - corePoolSize;
            this.corePoolSize = corePoolSize;
            if (extra < 0) {
                Thread t;
                int n = this.workQueue.size();
                while (extra++ < 0 && n-- > 0 && this.poolSize < corePoolSize && (t = this.addThread(null)) != null) {
                    t.start();
                }
            } else if (extra > 0 && this.poolSize > corePoolSize) {
                Iterator it = this.workers.iterator();
                while (it.hasNext() && extra-- > 0 && this.poolSize > corePoolSize && this.workQueue.remainingCapacity() == 0) {
                    ((Worker)it.next()).interruptIfIdle();
                }
            }
            Object var7_7 = null;
            mainLock.unlock();
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            mainLock.unlock();
            throw throwable;
        }
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    public boolean prestartCoreThread() {
        return this.addIfUnderCorePoolSize(null);
    }

    public int prestartAllCoreThreads() {
        int n = 0;
        while (this.addIfUnderCorePoolSize(null)) {
            ++n;
        }
        return n;
    }

    public void setMaximumPoolSize(int maximumPoolSize) {
        if (maximumPoolSize <= 0 || maximumPoolSize < this.corePoolSize) {
            throw new IllegalArgumentException();
        }
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            int extra;
            this.maximumPoolSize = maximumPoolSize;
            if (extra > 0 && this.poolSize > maximumPoolSize) {
                Iterator it = this.workers.iterator();
                for (extra = this.maximumPoolSize - maximumPoolSize; it.hasNext() && extra > 0 && this.poolSize > maximumPoolSize; --extra) {
                    ((Worker)it.next()).interruptIfIdle();
                }
            }
            Object var6_5 = null;
            mainLock.unlock();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            mainLock.unlock();
            throw throwable;
        }
    }

    public int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    public void setKeepAliveTime(long time, TimeUnit unit) {
        if (time < (long)0) {
            throw new IllegalArgumentException();
        }
        this.keepAliveTime = unit.toNanos(time);
    }

    public long getKeepAliveTime(TimeUnit unit) {
        return unit.convert(this.keepAliveTime, TimeUnit.NANOSECONDS);
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public int getActiveCount() {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            int n = 0;
            Iterator i = this.workers.iterator();
            while (i.hasNext()) {
                Worker w = (Worker)i.next();
                if (!w.isActive()) continue;
                ++n;
            }
            int n2 = n;
            Object var6_6 = null;
            mainLock.unlock();
            return n2;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            mainLock.unlock();
            throw throwable;
        }
    }

    public int getLargestPoolSize() {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            int n = this.largestPoolSize;
            Object var4_3 = null;
            mainLock.unlock();
            return n;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            mainLock.unlock();
            throw throwable;
        }
    }

    public long getTaskCount() {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            long n = this.completedTaskCount;
            Iterator i = this.workers.iterator();
            while (i.hasNext()) {
                Worker w = (Worker)i.next();
                n += w.completedTasks;
                if (!w.isActive()) continue;
                ++n;
            }
            long l = n + (long)this.workQueue.size();
            Object var7_6 = null;
            mainLock.unlock();
            return l;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            mainLock.unlock();
            throw throwable;
        }
    }

    public long getCompletedTaskCount() {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            long n = this.completedTaskCount;
            Iterator i = this.workers.iterator();
            while (i.hasNext()) {
                Worker w = (Worker)i.next();
                n += w.completedTasks;
            }
            long l = n;
            Object var7_6 = null;
            mainLock.unlock();
            return l;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            mainLock.unlock();
            throw throwable;
        }
    }

    protected void beforeExecute(Thread t, Runnable r) {
    }

    protected void afterExecute(Runnable r, Throwable t) {
    }

    protected void terminated() {
    }

    static Class class$(String x$0) {
        try {
            return Class.forName(x$0);
        }
        catch (ClassNotFoundException x$02) {
            throw new NoClassDefFoundError(x$02.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$edu$emory$mathcs$util$concurrent$ThreadPoolExecutor == null ? (class$edu$emory$mathcs$util$concurrent$ThreadPoolExecutor = ThreadPoolExecutor.class$("edu.emory.mathcs.util.concurrent.ThreadPoolExecutor")) : class$edu$emory$mathcs$util$concurrent$ThreadPoolExecutor).desiredAssertionStatus();
        EMPTY_RUNNABLE_ARRAY = new Runnable[0];
        shutdownPerm = new RuntimePermission("modifyThread");
        RUNNING = 0;
        SHUTDOWN = 1;
        STOP = 2;
        TERMINATED = 3;
        defaultHandler = new AbortPolicy();
    }

    public static class DiscardOldestPolicy
    implements RejectedExecutionHandler {
        public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
            if (!e.isShutdown()) {
                e.getQueue().poll();
                e.execute(r);
            }
        }
    }

    public static class DiscardPolicy
    implements RejectedExecutionHandler {
        public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
        }
    }

    public static class AbortPolicy
    implements RejectedExecutionHandler {
        public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
            throw new RejectedExecutionException();
        }
    }

    public static class CallerRunsPolicy
    implements RejectedExecutionHandler {
        public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
            if (!e.isShutdown()) {
                r.run();
            }
        }
    }

    private class Worker
    implements Runnable {
        private final ReentrantLock runLock = new ReentrantLock();
        private Runnable firstTask;
        volatile long completedTasks;
        Thread thread;

        Worker(Runnable firstTask) {
            this.firstTask = firstTask;
        }

        boolean isActive() {
            return this.runLock.isLocked();
        }

        void interruptIfIdle() {
            ReentrantLock runLock = this.runLock;
            if (runLock.tryLock()) {
                try {
                    this.thread.interrupt();
                    Object var3_2 = null;
                    runLock.unlock();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    runLock.unlock();
                    throw throwable;
                }
            }
        }

        void interruptNow() {
            this.thread.interrupt();
        }

        private void runTask(Runnable task) {
            ReentrantLock runLock = this.runLock;
            runLock.lock();
            try {
                if (ThreadPoolExecutor.this.runState == 2) {
                    Object var6_3 = null;
                    runLock.unlock();
                    return;
                }
                Thread.interrupted();
                boolean ran = false;
                ThreadPoolExecutor.this.beforeExecute(this.thread, task);
                try {
                    task.run();
                    ran = true;
                    ThreadPoolExecutor.this.afterExecute(task, null);
                    ++this.completedTasks;
                }
                catch (RuntimeException ex) {
                    if (!ran) {
                        ThreadPoolExecutor.this.afterExecute(task, ex);
                    }
                    throw ex;
                }
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                runLock.unlock();
                throw throwable;
            }
            Object var6_4 = null;
            runLock.unlock();
        }

        public void run() {
            try {
                try {
                    Runnable task = this.firstTask;
                    this.firstTask = null;
                    while (task != null || (task = ThreadPoolExecutor.this.getTask()) != null) {
                        this.runTask(task);
                        task = null;
                    }
                    Object var3_3 = null;
                    ThreadPoolExecutor.this.workerDone(this);
                }
                catch (InterruptedException interruptedException) {
                    Object var3_4 = null;
                    ThreadPoolExecutor.this.workerDone(this);
                }
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                ThreadPoolExecutor.this.workerDone(this);
                throw throwable;
            }
        }
    }
}

