/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.concurrent;

import edu.emory.mathcs.util.AbstractQueue;
import edu.emory.mathcs.util.PriorityQueue;
import edu.emory.mathcs.util.concurrent.BlockingQueue;
import edu.emory.mathcs.util.concurrent.TimeUnit;
import edu.emory.mathcs.util.concurrent.helpers.Utils;
import edu.emory.mathcs.util.concurrent.locks.Condition;
import edu.emory.mathcs.util.concurrent.locks.ReentrantLock;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;

public class PriorityBlockingQueue
extends AbstractQueue
implements BlockingQueue,
Serializable {
    private static final long serialVersionUID = 5595510919245408276L;
    private final PriorityQueue q;
    private final ReentrantLock lock = new ReentrantLock(true);
    private final Condition notEmpty = this.lock.newCondition();
    private static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$edu$emory$mathcs$util$concurrent$PriorityBlockingQueue;

    public PriorityBlockingQueue() {
        this.q = new PriorityQueue();
    }

    public PriorityBlockingQueue(int initialCapacity) {
        this.q = new PriorityQueue(initialCapacity, null);
    }

    public PriorityBlockingQueue(int initialCapacity, Comparator comparator) {
        this.q = new PriorityQueue(initialCapacity, comparator);
    }

    public PriorityBlockingQueue(Collection c) {
        this.q = new PriorityQueue(c);
    }

    public boolean add(Object o) {
        return super.add(o);
    }

    public Comparator comparator() {
        return this.q.comparator();
    }

    public boolean offer(Object o) {
        if (o == null) {
            throw new NullPointerException();
        }
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            boolean ok = this.q.offer(o);
            if (!$assertionsDisabled && !ok) {
                throw new AssertionError();
            }
            this.notEmpty.signal();
            boolean bl = true;
            Object var6_5 = null;
            lock.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            lock.unlock();
            throw throwable;
        }
    }

    public void put(Object o) {
        this.offer(o);
    }

    public boolean offer(Object o, long timeout, TimeUnit unit) {
        return this.offer(o);
    }

    public Object take() throws InterruptedException {
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            try {
                while (this.q.size() == 0) {
                    this.notEmpty.await();
                }
            }
            catch (InterruptedException ie) {
                this.notEmpty.signal();
                throw ie;
            }
            Object x = this.q.poll();
            if (!$assertionsDisabled && x == null) {
                throw new AssertionError();
            }
            Object object = x;
            Object var5_5 = null;
            lock.unlock();
            return object;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            lock.unlock();
            throw throwable;
        }
    }

    public Object poll() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object object = this.q.poll();
            Object var4_3 = null;
            lock.unlock();
            return object;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object poll(long timeout, TimeUnit unit) throws InterruptedException {
        block7: {
            nanos = unit.toNanos(timeout);
            lock = this.lock;
            lock.lockInterruptibly();
            try {
                deadline = Utils.nanoTime() + nanos;
                while (true) lbl-1000:
                // 2 sources

                {
                    if ((x = this.q.poll()) != null) {
                        var10_7 = x;
                        var12_10 = null;
                        lock.unlock();
                        return var10_7;
                    }
                    if (nanos <= (long)0) {
                        var10_8 = null;
                        break block7;
                    }
                    try {
                        this.notEmpty.await(nanos, TimeUnit.NANOSECONDS);
                        nanos = deadline - Utils.nanoTime();
                        continue;
                    }
                    catch (InterruptedException ie) {
                        this.notEmpty.signal();
                        throw ie;
                    }
                    break;
                }
            }
            catch (Throwable var11_13) {
                var12_12 = null;
                lock.unlock();
                throw var11_13;
            }
            {
                ** while (true)
            }
        }
        var12_11 = null;
        lock.unlock();
        return var10_8;
    }

    public Object peek() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object object = this.q.peek();
            Object var4_3 = null;
            lock.unlock();
            return object;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            lock.unlock();
            throw throwable;
        }
    }

    public int size() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int n = this.q.size();
            Object var4_3 = null;
            lock.unlock();
            return n;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            lock.unlock();
            throw throwable;
        }
    }

    public int remainingCapacity() {
        return Integer.MAX_VALUE;
    }

    public boolean remove(Object o) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            boolean bl = this.q.remove(o);
            Object var5_4 = null;
            lock.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            lock.unlock();
            throw throwable;
        }
    }

    public boolean contains(Object o) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            boolean bl = this.q.contains(o);
            Object var5_4 = null;
            lock.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            lock.unlock();
            throw throwable;
        }
    }

    public Object[] toArray() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object[] objectArray = this.q.toArray();
            Object var4_3 = null;
            lock.unlock();
            return objectArray;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            lock.unlock();
            throw throwable;
        }
    }

    public String toString() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            String string = this.q.toString();
            Object var4_3 = null;
            lock.unlock();
            return string;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            lock.unlock();
            throw throwable;
        }
    }

    public int drainTo(Collection c) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object e;
            int n = 0;
            while ((e = this.q.poll()) != null) {
                c.add(e);
                ++n;
            }
            int n2 = n;
            Object var7_6 = null;
            lock.unlock();
            return n2;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            lock.unlock();
            throw throwable;
        }
    }

    public int drainTo(Collection c, int maxElements) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        if (maxElements <= 0) {
            return 0;
        }
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object e;
            int n;
            for (n = 0; n < maxElements && (e = this.q.poll()) != null; ++n) {
                c.add(e);
            }
            int n2 = n;
            Object var8_7 = null;
            lock.unlock();
            return n2;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            lock.unlock();
            throw throwable;
        }
    }

    public void clear() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            this.q.clear();
            Object var3_2 = null;
            lock.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            lock.unlock();
            throw throwable;
        }
    }

    public Object[] toArray(Object[] a) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object[] objectArray = this.q.toArray(a);
            Object var5_4 = null;
            lock.unlock();
            return objectArray;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            lock.unlock();
            throw throwable;
        }
    }

    public Iterator iterator() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Itr itr = new Itr(this.q.iterator());
            Object var4_3 = null;
            lock.unlock();
            return itr;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            lock.unlock();
            throw throwable;
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        this.lock.lock();
        try {
            s.defaultWriteObject();
            Object var3_2 = null;
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    static Class class$(String x$0) {
        try {
            return Class.forName(x$0);
        }
        catch (ClassNotFoundException x$02) {
            throw new NoClassDefFoundError(x$02.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$edu$emory$mathcs$util$concurrent$PriorityBlockingQueue == null ? (class$edu$emory$mathcs$util$concurrent$PriorityBlockingQueue = PriorityBlockingQueue.class$("edu.emory.mathcs.util.concurrent.PriorityBlockingQueue")) : class$edu$emory$mathcs$util$concurrent$PriorityBlockingQueue).desiredAssertionStatus();
        serialVersionUID = 5595510919245408276L;
    }

    private class Itr
    implements Iterator {
        private final Iterator iter;

        Itr(Iterator i) {
            this.iter = i;
        }

        public boolean hasNext() {
            return this.iter.hasNext();
        }

        public Object next() {
            ReentrantLock lock = PriorityBlockingQueue.this.lock;
            lock.lock();
            try {
                Object e = this.iter.next();
                Object var4_3 = null;
                lock.unlock();
                return e;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                lock.unlock();
                throw throwable;
            }
        }

        public void remove() {
            ReentrantLock lock = PriorityBlockingQueue.this.lock;
            lock.lock();
            try {
                this.iter.remove();
                Object var3_2 = null;
                lock.unlock();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                lock.unlock();
                throw throwable;
            }
        }
    }
}

