/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.concurrent;

import edu.emory.mathcs.util.concurrent.Callable;
import edu.emory.mathcs.util.concurrent.CancellationException;
import edu.emory.mathcs.util.concurrent.ExecutionException;
import edu.emory.mathcs.util.concurrent.Executors;
import edu.emory.mathcs.util.concurrent.Future;
import edu.emory.mathcs.util.concurrent.TimeUnit;
import edu.emory.mathcs.util.concurrent.TimeoutException;
import edu.emory.mathcs.util.concurrent.helpers.Utils;

public class FutureTask
implements Future,
Runnable {
    private static final int RUNNING = 1;
    private static final int RAN = 2;
    private static final int CANCELLED = 4;
    private final Callable callable;
    private Object result;
    private Throwable exception;
    private int state;
    private volatile Thread runner;

    public FutureTask(Callable callable) {
        if (callable == null) {
            throw new NullPointerException();
        }
        this.callable = callable;
    }

    public FutureTask(Runnable runnable, Object result) {
        this(Executors.callable(runnable, result));
    }

    public synchronized boolean isCancelled() {
        return this.state == 4;
    }

    public synchronized boolean isDone() {
        return this.ranOrCancelled() && this.runner == null;
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        FutureTask futureTask = this;
        synchronized (futureTask) {
            Thread r;
            if (this.ranOrCancelled()) {
                boolean bl = false;
                return bl;
            }
            this.state = 4;
            if (mayInterruptIfRunning && (r = this.runner) != null) {
                r.interrupt();
            }
            this.runner = null;
            this.notifyAll();
        }
        this.done();
        return true;
    }

    public synchronized Object get() throws ExecutionException, InterruptedException {
        this.waitFor();
        return this.getResult();
    }

    public synchronized Object get(long timeout, TimeUnit unit) throws TimeoutException, ExecutionException, InterruptedException {
        this.waitFor(unit.toNanos(timeout));
        return this.getResult();
    }

    protected void done() {
    }

    protected void set(Object v) {
        this.setCompleted(v);
    }

    protected void setException(Throwable t) {
        this.setFailed(t);
    }

    public void run() {
        FutureTask futureTask = this;
        synchronized (futureTask) {
            if (this.state != 0) {
                return;
            }
            this.state = 1;
            this.runner = Thread.currentThread();
        }
        try {
            this.setCompleted(this.callable.call());
        }
        catch (Throwable ex) {
            this.setFailed(ex);
        }
    }

    protected boolean runAndReset() {
        FutureTask futureTask = this;
        synchronized (futureTask) {
            if (this.state != 0) {
                boolean bl = false;
                return bl;
            }
            this.state = 1;
            this.runner = Thread.currentThread();
        }
        try {
            this.callable.call();
            FutureTask futureTask2 = this;
            synchronized (futureTask2) {
                this.runner = null;
                if (this.state == 1) {
                    this.state = 0;
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
        }
        catch (Throwable ex) {
            this.setFailed(ex);
            boolean bl = false;
            return bl;
        }
    }

    private boolean ranOrCancelled() {
        return (this.state & 6) != 0;
    }

    private void setCompleted(Object result) {
        FutureTask futureTask = this;
        synchronized (futureTask) {
            if (this.ranOrCancelled()) {
                return;
            }
            this.state = 2;
            this.result = result;
            this.runner = null;
            this.notifyAll();
        }
        this.done();
    }

    private void setFailed(Throwable exception) {
        FutureTask futureTask = this;
        synchronized (futureTask) {
            if (this.ranOrCancelled()) {
                return;
            }
            this.state = 2;
            this.exception = exception;
            this.runner = null;
            this.notifyAll();
        }
        this.done();
    }

    private void waitFor() throws InterruptedException {
        while (!this.isDone()) {
            this.wait();
        }
    }

    private void waitFor(long nanos) throws TimeoutException, InterruptedException {
        if (nanos < (long)0) {
            throw new IllegalArgumentException();
        }
        if (this.isDone()) {
            return;
        }
        long deadline = Utils.nanoTime() + nanos;
        while (nanos > (long)0) {
            TimeUnit.NANOSECONDS.timedWait(this, nanos);
            if (this.isDone()) {
                return;
            }
            nanos = deadline - Utils.nanoTime();
        }
        throw new TimeoutException();
    }

    private Object getResult() throws ExecutionException {
        if (this.state == 4) {
            throw new CancellationException();
        }
        if (this.exception != null) {
            throw new ExecutionException(this.exception);
        }
        return this.result;
    }

    static {
        RUNNING = 1;
        RAN = 2;
        CANCELLED = 4;
    }
}

