/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.concurrent;

import edu.emory.mathcs.util.concurrent.AbstractExecutorService;
import edu.emory.mathcs.util.concurrent.BlockingQueue;
import edu.emory.mathcs.util.concurrent.Callable;
import edu.emory.mathcs.util.concurrent.ExecutionException;
import edu.emory.mathcs.util.concurrent.ExecutorService;
import edu.emory.mathcs.util.concurrent.Executors;
import edu.emory.mathcs.util.concurrent.Future;
import edu.emory.mathcs.util.concurrent.LinkedBlockingQueue;
import edu.emory.mathcs.util.concurrent.ScheduledExecutorService;
import edu.emory.mathcs.util.concurrent.ScheduledFuture;
import edu.emory.mathcs.util.concurrent.ScheduledThreadPoolExecutor;
import edu.emory.mathcs.util.concurrent.SynchronousQueue;
import edu.emory.mathcs.util.concurrent.ThreadFactory;
import edu.emory.mathcs.util.concurrent.ThreadPoolExecutor;
import edu.emory.mathcs.util.concurrent.TimeUnit;
import edu.emory.mathcs.util.concurrent.TimeoutException;
import edu.emory.mathcs.util.concurrent.atomic.AtomicInteger;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.List;

public class Executors {
    public static ExecutorService newFixedThreadPool(int nThreads) {
        return new ThreadPoolExecutor(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue());
    }

    public static ExecutorService newFixedThreadPool(int nThreads, ThreadFactory threadFactory) {
        return new ThreadPoolExecutor(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, (BlockingQueue)new LinkedBlockingQueue(), threadFactory);
    }

    public static ExecutorService newSingleThreadExecutor() {
        return new DelegatedExecutorService(new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue()));
    }

    public static ExecutorService newSingleThreadExecutor(ThreadFactory threadFactory) {
        return new DelegatedExecutorService(new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, (BlockingQueue)new LinkedBlockingQueue(), threadFactory));
    }

    public static ExecutorService newCachedThreadPool() {
        return new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue());
    }

    public static ExecutorService newCachedThreadPool(ThreadFactory threadFactory) {
        return new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, (BlockingQueue)new SynchronousQueue(), threadFactory);
    }

    public static ScheduledExecutorService newSingleThreadScheduledExecutor() {
        return new DelegatedScheduledExecutorService(new ScheduledThreadPoolExecutor(1));
    }

    public static ScheduledExecutorService newSingleThreadScheduledExecutor(ThreadFactory threadFactory) {
        return new DelegatedScheduledExecutorService(new ScheduledThreadPoolExecutor(1, threadFactory));
    }

    public static ScheduledExecutorService newScheduledThreadPool(int corePoolSize) {
        return new ScheduledThreadPoolExecutor(corePoolSize);
    }

    public static ScheduledExecutorService newScheduledThreadPool(int corePoolSize, ThreadFactory threadFactory) {
        return new ScheduledThreadPoolExecutor(corePoolSize, threadFactory);
    }

    public static ExecutorService unconfigurableExecutorService(ExecutorService executor) {
        if (executor == null) {
            throw new NullPointerException();
        }
        return new DelegatedExecutorService(executor);
    }

    public static ScheduledExecutorService unconfigurableScheduledExecutorService(ScheduledExecutorService executor) {
        if (executor == null) {
            throw new NullPointerException();
        }
        return new DelegatedScheduledExecutorService(executor);
    }

    public static ThreadFactory defaultThreadFactory() {
        return new DefaultThreadFactory();
    }

    public static ThreadFactory privilegedThreadFactory() {
        return new PrivilegedThreadFactory();
    }

    public static Callable callable(Runnable task, Object result) {
        if (task == null) {
            throw new NullPointerException();
        }
        return new RunnableAdapter(task, result);
    }

    public static Callable callable(Runnable task) {
        if (task == null) {
            throw new NullPointerException();
        }
        return new RunnableAdapter(task, null);
    }

    public static Callable callable(PrivilegedAction action) {
        if (action == null) {
            throw new NullPointerException();
        }
        return new PrivilegedActionAdapter(action);
    }

    public static Callable callable(PrivilegedExceptionAction action) {
        if (action == null) {
            throw new NullPointerException();
        }
        return new PrivilegedExceptionActionAdapter(action);
    }

    public static Callable privilegedCallable(Callable callable) {
        if (callable == null) {
            throw new NullPointerException();
        }
        return new PrivilegedCallable(callable);
    }

    public static Callable privilegedCallableUsingCurrentClassLoader(Callable callable) {
        if (callable == null) {
            throw new NullPointerException();
        }
        return new PrivilegedCallableUsingCurrentClassLoader(callable);
    }

    private Executors() {
    }

    static class DelegatedScheduledExecutorService
    extends DelegatedExecutorService
    implements ScheduledExecutorService {
        private final ScheduledExecutorService e;

        DelegatedScheduledExecutorService(ScheduledExecutorService executor) {
            super(executor);
            this.e = executor;
        }

        public ScheduledFuture schedule(Runnable command, long delay, TimeUnit unit) {
            return this.e.schedule(command, delay, unit);
        }

        public ScheduledFuture schedule(Callable callable, long delay, TimeUnit unit) {
            return this.e.schedule(callable, delay, unit);
        }

        public ScheduledFuture scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
            return this.e.scheduleAtFixedRate(command, initialDelay, period, unit);
        }

        public ScheduledFuture scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
            return this.e.scheduleWithFixedDelay(command, initialDelay, delay, unit);
        }
    }

    static class DelegatedExecutorService
    extends AbstractExecutorService {
        private final ExecutorService e;

        DelegatedExecutorService(ExecutorService executor) {
            this.e = executor;
        }

        public void execute(Runnable command) {
            this.e.execute(command);
        }

        public void shutdown() {
            this.e.shutdown();
        }

        public List shutdownNow() {
            return this.e.shutdownNow();
        }

        public boolean isShutdown() {
            return this.e.isShutdown();
        }

        public boolean isTerminated() {
            return this.e.isTerminated();
        }

        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return this.e.awaitTermination(timeout, unit);
        }

        public Future submit(Runnable task) {
            return this.e.submit(task);
        }

        public Future submit(Callable task) {
            return this.e.submit(task);
        }

        public Future submit(Runnable task, Object result) {
            return this.e.submit(task, result);
        }

        public List invokeAll(Collection tasks) throws InterruptedException {
            return this.e.invokeAll(tasks);
        }

        public List invokeAll(Collection tasks, long timeout, TimeUnit unit) throws InterruptedException {
            return this.e.invokeAll(tasks, timeout, unit);
        }

        public Object invokeAny(Collection tasks) throws ExecutionException, InterruptedException {
            return this.e.invokeAny(tasks);
        }

        public Object invokeAny(Collection tasks, long timeout, TimeUnit unit) throws TimeoutException, ExecutionException, InterruptedException {
            return this.e.invokeAny(tasks, timeout, unit);
        }
    }

    static class PrivilegedThreadFactory
    extends DefaultThreadFactory {
        private final ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        private final AccessControlContext acc = AccessController.getContext();

        PrivilegedThreadFactory() {
            this.acc.checkPermission(new RuntimePermission("setContextClassLoader"));
        }

        public Thread newThread(Runnable r) {
            return super.newThread(new Runnable(this, r){
                private final /* synthetic */ PrivilegedThreadFactory this$1;
                private final /* synthetic */ Runnable val$r;
                {
                    this.this$1 = this$1;
                    this.val$r = val$r;
                }

                public void run() {
                    AccessController.doPrivileged(new PrivilegedAction(this){
                        private final /* synthetic */ 3 this$2;
                        {
                            this.this$2 = this$2;
                        }

                        public Object run() {
                            Thread.currentThread().setContextClassLoader(PrivilegedThreadFactory.access$8(3.access$7(this.this$2)));
                            3.access$9(this.this$2).run();
                            return null;
                        }
                    }, PrivilegedThreadFactory.access$10(this.this$1));
                }

                static /* synthetic */ PrivilegedThreadFactory access$7(3 x$0) {
                    return x$0.this$1;
                }

                static /* synthetic */ Runnable access$9(3 x$0) {
                    return x$0.val$r;
                }
            });
        }

        static /* synthetic */ AccessControlContext access$10(PrivilegedThreadFactory x$0) {
            return x$0.acc;
        }

        static /* synthetic */ ClassLoader access$8(PrivilegedThreadFactory x$0) {
            return x$0.ccl;
        }
    }

    static class DefaultThreadFactory
    implements ThreadFactory {
        static final AtomicInteger poolNumber = new AtomicInteger(1);
        final ThreadGroup group;
        final AtomicInteger threadNumber = new AtomicInteger(1);
        final String namePrefix;

        DefaultThreadFactory() {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = String.valueOf(String.valueOf(new StringBuffer("pool-").append(poolNumber.getAndIncrement()).append("-thread-")));
        }

        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, String.valueOf(String.valueOf(this.namePrefix)).concat(String.valueOf(String.valueOf(this.threadNumber.getAndIncrement()))), 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }

    static final class PrivilegedCallableUsingCurrentClassLoader
    implements Callable {
        private final ClassLoader ccl;
        private final AccessControlContext acc;
        private final Callable task;
        private Object result;
        private Exception exception;

        PrivilegedCallableUsingCurrentClassLoader(Callable task) {
            this.task = task;
            this.ccl = Thread.currentThread().getContextClassLoader();
            this.acc = AccessController.getContext();
            this.acc.checkPermission(new RuntimePermission("getContextClassLoader"));
            this.acc.checkPermission(new RuntimePermission("setContextClassLoader"));
        }

        public Object call() throws Exception {
            AccessController.doPrivileged(new PrivilegedAction(this){
                private final /* synthetic */ PrivilegedCallableUsingCurrentClassLoader this$1;
                {
                    this.this$1 = this$1;
                }

                public Object run() {
                    ClassLoader savedcl = null;
                    Thread t = Thread.currentThread();
                    try {
                        try {
                            ClassLoader cl = t.getContextClassLoader();
                            if (PrivilegedCallableUsingCurrentClassLoader.access$3(this.this$1) != cl) {
                                t.setContextClassLoader(PrivilegedCallableUsingCurrentClassLoader.access$3(this.this$1));
                                savedcl = cl;
                            }
                            PrivilegedCallableUsingCurrentClassLoader.access$4(this.this$1, PrivilegedCallableUsingCurrentClassLoader.access$5(this.this$1).call());
                        }
                        catch (Exception ex) {
                            PrivilegedCallableUsingCurrentClassLoader.access$6(this.this$1, ex);
                            Object var5_6 = null;
                            if (savedcl != null) {
                                t.setContextClassLoader(savedcl);
                            }
                        }
                        Object var5_5 = null;
                        if (savedcl != null) {
                            t.setContextClassLoader(savedcl);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var5_7 = null;
                        if (savedcl != null) {
                            t.setContextClassLoader(savedcl);
                        }
                        throw throwable;
                    }
                    return null;
                }
            }, this.acc);
            if (this.exception != null) {
                throw this.exception;
            }
            return this.result;
        }

        static /* synthetic */ ClassLoader access$3(PrivilegedCallableUsingCurrentClassLoader x$0) {
            return x$0.ccl;
        }

        static /* synthetic */ Object access$4(PrivilegedCallableUsingCurrentClassLoader x$0, Object x$1) {
            x$0.result = x$1;
            return x$0.result;
        }

        static /* synthetic */ Callable access$5(PrivilegedCallableUsingCurrentClassLoader x$0) {
            return x$0.task;
        }

        static /* synthetic */ Exception access$6(PrivilegedCallableUsingCurrentClassLoader x$0, Exception x$1) {
            x$0.exception = x$1;
            return x$0.exception;
        }
    }

    static final class PrivilegedCallable
    implements Callable {
        private final AccessControlContext acc;
        private final Callable task;
        private Object result;
        private Exception exception;

        PrivilegedCallable(Callable task) {
            this.task = task;
            this.acc = AccessController.getContext();
        }

        public Object call() throws Exception {
            AccessController.doPrivileged(new PrivilegedAction(this){
                private final /* synthetic */ PrivilegedCallable this$1;
                {
                    this.this$1 = this$1;
                }

                public Object run() {
                    try {
                        PrivilegedCallable.access$0(this.this$1, PrivilegedCallable.access$1(this.this$1).call());
                    }
                    catch (Exception ex) {
                        PrivilegedCallable.access$2(this.this$1, ex);
                    }
                    return null;
                }
            }, this.acc);
            if (this.exception != null) {
                throw this.exception;
            }
            return this.result;
        }

        static /* synthetic */ Object access$0(PrivilegedCallable x$0, Object x$1) {
            x$0.result = x$1;
            return x$0.result;
        }

        static /* synthetic */ Callable access$1(PrivilegedCallable x$0) {
            return x$0.task;
        }

        static /* synthetic */ Exception access$2(PrivilegedCallable x$0, Exception x$1) {
            x$0.exception = x$1;
            return x$0.exception;
        }
    }

    static final class PrivilegedExceptionActionAdapter
    implements Callable {
        private final PrivilegedExceptionAction action;

        PrivilegedExceptionActionAdapter(PrivilegedExceptionAction action) {
            this.action = action;
        }

        public Object call() throws Exception {
            return this.action.run();
        }
    }

    static final class PrivilegedActionAdapter
    implements Callable {
        private final PrivilegedAction action;

        PrivilegedActionAdapter(PrivilegedAction action) {
            this.action = action;
        }

        public Object call() {
            return this.action.run();
        }
    }

    static final class RunnableAdapter
    implements Callable {
        final Runnable task;
        final Object result;

        RunnableAdapter(Runnable task, Object result) {
            this.task = task;
            this.result = result;
        }

        public Object call() {
            this.task.run();
            return this.result;
        }
    }
}

