/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.concurrent;

import edu.emory.mathcs.util.AbstractQueue;
import edu.emory.mathcs.util.PriorityQueue;
import edu.emory.mathcs.util.concurrent.BlockingQueue;
import edu.emory.mathcs.util.concurrent.Delayed;
import edu.emory.mathcs.util.concurrent.TimeUnit;
import edu.emory.mathcs.util.concurrent.helpers.Utils;
import edu.emory.mathcs.util.concurrent.locks.Condition;
import edu.emory.mathcs.util.concurrent.locks.ReentrantLock;
import java.util.Collection;
import java.util.Iterator;

public class DelayQueue
extends AbstractQueue
implements BlockingQueue {
    private final transient ReentrantLock lock = new ReentrantLock();
    private final transient Condition available = this.lock.newCondition();
    private final PriorityQueue q = new PriorityQueue();
    private static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$edu$emory$mathcs$util$concurrent$DelayQueue;

    public DelayQueue() {
    }

    public DelayQueue(Collection c) {
        this.addAll(c);
    }

    public boolean offer(Object o) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object first = this.q.peek();
            this.q.offer(o);
            if (first == null || ((Delayed)o).compareTo(first) < 0) {
                this.available.signalAll();
            }
            boolean bl = true;
            Object var6_5 = null;
            lock.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            lock.unlock();
            throw throwable;
        }
    }

    public void put(Object o) {
        this.offer(o);
    }

    public boolean offer(Object o, long timeout, TimeUnit unit) {
        return this.offer(o);
    }

    public boolean add(Object o) {
        return this.offer(o);
    }

    public Object take() throws InterruptedException {
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            while (true) {
                Object first;
                if ((first = this.q.peek()) == null) {
                    this.available.await();
                    continue;
                }
                long delay = ((Delayed)first).getDelay(TimeUnit.NANOSECONDS);
                if (delay <= (long)0) break;
                this.available.await(delay, TimeUnit.NANOSECONDS);
            }
            Object x = this.q.poll();
            if (!$assertionsDisabled && x == null) {
                throw new AssertionError();
            }
            if (this.q.size() != 0) {
                this.available.signalAll();
            }
            Object object = x;
            Object var8_6 = null;
            lock.unlock();
            return object;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            lock.unlock();
            throw throwable;
        }
    }

    public Object poll(long timeout, TimeUnit unit) throws InterruptedException {
        Object object;
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        long nanos = unit.toNanos(timeout);
        try {
            long deadline = Utils.nanoTime() + nanos;
            while (true) {
                Object first;
                if ((first = this.q.peek()) == null) {
                    if (nanos <= (long)0) {
                        Object var10_8 = null;
                        Object var15_9 = null;
                        lock.unlock();
                        return var10_8;
                    }
                    this.available.await(nanos, TimeUnit.NANOSECONDS);
                    nanos = deadline - Utils.nanoTime();
                    continue;
                }
                long delay = ((Delayed)first).getDelay(TimeUnit.NANOSECONDS);
                if (delay <= (long)0) break;
                if (delay > nanos) {
                    delay = nanos;
                }
                this.available.await(delay, TimeUnit.NANOSECONDS);
                nanos = deadline - Utils.nanoTime();
            }
            Object x = this.q.poll();
            if (!$assertionsDisabled && x == null) {
                throw new AssertionError();
            }
            if (this.q.size() != 0) {
                this.available.signalAll();
            }
            object = x;
        }
        catch (Throwable throwable) {
            Object var15_11 = null;
            lock.unlock();
            throw throwable;
        }
        Object var15_10 = null;
        lock.unlock();
        return object;
    }

    public Object poll() {
        Object object;
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object first = this.q.peek();
            if (first == null || ((Delayed)first).getDelay(TimeUnit.NANOSECONDS) > (long)0) {
                Object var3_3 = null;
                Object var6_5 = null;
                lock.unlock();
                return var3_3;
            }
            Object x = this.q.poll();
            if (!$assertionsDisabled && x == null) {
                throw new AssertionError();
            }
            if (this.q.size() != 0) {
                this.available.signalAll();
            }
            object = x;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            lock.unlock();
            throw throwable;
        }
        Object var6_6 = null;
        lock.unlock();
        return object;
    }

    public Object peek() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object object = this.q.peek();
            Object var4_3 = null;
            lock.unlock();
            return object;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            lock.unlock();
            throw throwable;
        }
    }

    public int size() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int n = this.q.size();
            Object var4_3 = null;
            lock.unlock();
            return n;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            lock.unlock();
            throw throwable;
        }
    }

    public int drainTo(Collection c) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object first;
            int n = 0;
            while ((first = this.q.peek()) != null && ((Delayed)first).getDelay(TimeUnit.NANOSECONDS) <= (long)0) {
                c.add(this.q.poll());
                ++n;
            }
            if (n > 0) {
                this.available.signalAll();
            }
            int n2 = n;
            Object var6_6 = null;
            lock.unlock();
            return n2;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            lock.unlock();
            throw throwable;
        }
    }

    public int drainTo(Collection c, int maxElements) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        if (maxElements <= 0) {
            return 0;
        }
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object first;
            int n;
            for (n = 0; n < maxElements && (first = this.q.peek()) != null && ((Delayed)first).getDelay(TimeUnit.NANOSECONDS) <= (long)0; ++n) {
                c.add(this.q.poll());
            }
            if (n > 0) {
                this.available.signalAll();
            }
            int n2 = n;
            Object var7_7 = null;
            lock.unlock();
            return n2;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            lock.unlock();
            throw throwable;
        }
    }

    public void clear() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            this.q.clear();
            Object var3_2 = null;
            lock.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            lock.unlock();
            throw throwable;
        }
    }

    public int remainingCapacity() {
        return Integer.MAX_VALUE;
    }

    public Object[] toArray() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object[] objectArray = this.q.toArray();
            Object var4_3 = null;
            lock.unlock();
            return objectArray;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            lock.unlock();
            throw throwable;
        }
    }

    public Object[] toArray(Object[] array) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object[] objectArray = this.q.toArray(array);
            Object var5_4 = null;
            lock.unlock();
            return objectArray;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            lock.unlock();
            throw throwable;
        }
    }

    public boolean remove(Object o) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            boolean bl = this.q.remove(o);
            Object var5_4 = null;
            lock.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            lock.unlock();
            throw throwable;
        }
    }

    public Iterator iterator() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Itr itr = new Itr(this.q.iterator());
            Object var4_3 = null;
            lock.unlock();
            return itr;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            lock.unlock();
            throw throwable;
        }
    }

    static Class class$(String x$0) {
        try {
            return Class.forName(x$0);
        }
        catch (ClassNotFoundException x$02) {
            throw new NoClassDefFoundError(x$02.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$edu$emory$mathcs$util$concurrent$DelayQueue == null ? (class$edu$emory$mathcs$util$concurrent$DelayQueue = DelayQueue.class$("edu.emory.mathcs.util.concurrent.DelayQueue")) : class$edu$emory$mathcs$util$concurrent$DelayQueue).desiredAssertionStatus();
    }

    private class Itr
    implements Iterator {
        private final Iterator iter;

        Itr(Iterator i) {
            this.iter = i;
        }

        public boolean hasNext() {
            return this.iter.hasNext();
        }

        public Object next() {
            ReentrantLock lock = DelayQueue.this.lock;
            lock.lock();
            try {
                Object e = this.iter.next();
                Object var4_3 = null;
                lock.unlock();
                return e;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                lock.unlock();
                throw throwable;
            }
        }

        public void remove() {
            ReentrantLock lock = DelayQueue.this.lock;
            lock.lock();
            try {
                this.iter.remove();
                Object var3_2 = null;
                lock.unlock();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                lock.unlock();
                throw throwable;
            }
        }
    }
}

