/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.concurrent;

import edu.emory.mathcs.util.concurrent.BrokenBarrierException;
import edu.emory.mathcs.util.concurrent.TimeUnit;
import edu.emory.mathcs.util.concurrent.TimeoutException;
import edu.emory.mathcs.util.concurrent.helpers.Utils;
import edu.emory.mathcs.util.concurrent.locks.Condition;
import edu.emory.mathcs.util.concurrent.locks.ReentrantLock;

public class CyclicBarrier {
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition trip = this.lock.newCondition();
    private final int parties;
    private final Runnable barrierCommand;
    private long generation;
    private boolean broken;
    private int count;

    private void nextGeneration() {
        this.count = this.parties;
        ++this.generation;
        this.trip.signalAll();
    }

    private void breakBarrier() {
        this.broken = true;
        this.trip.signalAll();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int dowait(boolean timed, long nanos) throws TimeoutException, BrokenBarrierException, InterruptedException {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            long deadline;
            int index = --this.count;
            long g = this.generation;
            if (this.broken) {
                throw new BrokenBarrierException();
            }
            if (Thread.interrupted()) {
                this.breakBarrier();
                throw new InterruptedException();
            }
            if (index == 0) {
                int n;
                this.nextGeneration();
                boolean ranAction = false;
                try {
                    Runnable command = this.barrierCommand;
                    if (command != null) {
                        command.run();
                    }
                    ranAction = true;
                    n = 0;
                    Object var12_12 = null;
                    if (!ranAction) {
                        this.breakBarrier();
                    }
                }
                catch (Throwable throwable) {
                    Object var12_13 = null;
                    if (ranAction) throw throwable;
                    this.breakBarrier();
                    throw throwable;
                }
                Object var14_14 = null;
                lock.unlock();
                return n;
            }
            do {
                deadline = Utils.nanoTime() + nanos;
                try {
                    if (!timed) {
                        this.trip.await();
                    } else {
                        this.trip.await(nanos, TimeUnit.NANOSECONDS);
                    }
                }
                catch (InterruptedException ie) {
                    this.breakBarrier();
                    throw ie;
                }
                if (this.broken) throw new BrokenBarrierException();
                if (g > this.generation) {
                    throw new BrokenBarrierException();
                }
                if (g >= this.generation) continue;
                int n = index;
                Object var14_15 = null;
                lock.unlock();
                return n;
            } while (!timed || (nanos = deadline - Utils.nanoTime()) > 0L);
            this.breakBarrier();
            throw new TimeoutException();
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            lock.unlock();
            throw throwable;
        }
    }

    public CyclicBarrier(int parties, Runnable barrierAction) {
        if (parties <= 0) {
            throw new IllegalArgumentException();
        }
        this.parties = parties;
        this.count = parties;
        this.barrierCommand = barrierAction;
    }

    public CyclicBarrier(int parties) {
        this(parties, null);
    }

    public int getParties() {
        return this.parties;
    }

    public int await() throws BrokenBarrierException, InterruptedException {
        try {
            int n = this.dowait(false, 0L);
            return n;
        }
        catch (TimeoutException toe) {
            throw new Error(toe);
        }
    }

    public int await(long timeout, TimeUnit unit) throws TimeoutException, BrokenBarrierException, InterruptedException {
        return this.dowait(true, unit.toNanos(timeout));
    }

    public boolean isBroken() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            boolean bl = this.broken;
            Object var4_3 = null;
            lock.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            lock.unlock();
            throw throwable;
        }
    }

    public void reset() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            this.generation -= (long)4;
            this.broken = false;
            this.trip.signalAll();
            Object var3_2 = null;
            lock.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            lock.unlock();
            throw throwable;
        }
    }

    public int getNumberWaiting() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int n = this.parties - this.count;
            Object var4_3 = null;
            lock.unlock();
            return n;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            lock.unlock();
            throw throwable;
        }
    }
}

