/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.snippet;

import org.springframework.restdocs.RestDocumentationContext;
import org.springframework.util.PropertyPlaceholderHelper;

public class RestDocumentationContextPlaceholderResolver
implements PropertyPlaceholderHelper.PlaceholderResolver {
    private final RestDocumentationContext context;

    public RestDocumentationContextPlaceholderResolver(RestDocumentationContext context) {
        this.context = context;
    }

    public String resolvePlaceholder(String placeholderName) {
        if ("step".equals(placeholderName)) {
            return Integer.toString(this.context.getStepCount());
        }
        String converted = this.tryMethodNameConversion(placeholderName);
        if (converted != null) {
            return converted;
        }
        return this.tryClassNameConversion(placeholderName);
    }

    private String tryMethodNameConversion(String placeholderName) {
        if ("methodName".equals(placeholderName)) {
            return this.context.getTestMethodName();
        }
        if ("method-name".equals(placeholderName)) {
            return this.camelCaseToKebabCase(this.context.getTestMethodName());
        }
        if ("method_name".equals(placeholderName)) {
            return this.camelCaseToSnakeCase(this.context.getTestMethodName());
        }
        return null;
    }

    private String tryClassNameConversion(String placeholderName) {
        if ("ClassName".equals(placeholderName)) {
            return this.context.getTestClass().getSimpleName();
        }
        if ("class-name".equals(placeholderName)) {
            return this.camelCaseToKebabCase(this.context.getTestClass().getSimpleName());
        }
        if ("class_name".equals(placeholderName)) {
            return this.camelCaseToSnakeCase(this.context.getTestClass().getSimpleName());
        }
        return null;
    }

    protected final String camelCaseToKebabCase(String string) {
        return this.camelCaseToSeparator(string, "-");
    }

    protected final String camelCaseToSnakeCase(String string) {
        return this.camelCaseToSeparator(string, "_");
    }

    protected final RestDocumentationContext getContext() {
        return this.context;
    }

    private String camelCaseToSeparator(String string, String separator) {
        StringBuffer result = new StringBuffer();
        char[] chars = string.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char current = chars[i];
            if (Character.isUpperCase(current) && i > 0 && (Character.isLowerCase(chars[i - 1]) || i < chars.length - 1 && Character.isLowerCase(chars[i + 1]))) {
                result.append(separator);
            }
            result.append(Character.toLowerCase(chars[i]));
        }
        return result.toString();
    }
}

