/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.payload;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.springframework.http.MediaType;
import org.springframework.restdocs.operation.Operation;
import org.springframework.restdocs.operation.OperationRequestPart;
import org.springframework.restdocs.payload.AbstractFieldsSnippet;
import org.springframework.restdocs.payload.FieldDescriptor;
import org.springframework.restdocs.payload.PayloadDocumentation;
import org.springframework.restdocs.payload.PayloadSubsectionExtractor;
import org.springframework.restdocs.snippet.SnippetException;

public class RequestPartFieldsSnippet
extends AbstractFieldsSnippet {
    private final String partName;

    protected RequestPartFieldsSnippet(String partName, List<FieldDescriptor> descriptors) {
        this(partName, descriptors, null, false);
    }

    protected RequestPartFieldsSnippet(String partName, List<FieldDescriptor> descriptors, boolean ignoreUndocumentedFields) {
        this(partName, descriptors, null, ignoreUndocumentedFields);
    }

    protected RequestPartFieldsSnippet(String partName, List<FieldDescriptor> descriptors, Map<String, Object> attributes) {
        this(partName, descriptors, attributes, false);
    }

    protected RequestPartFieldsSnippet(String partName, List<FieldDescriptor> descriptors, Map<String, Object> attributes, boolean ignoreUndocumentedFields) {
        this(partName, (PayloadSubsectionExtractor<?>)null, descriptors, attributes, ignoreUndocumentedFields);
    }

    protected RequestPartFieldsSnippet(String partName, PayloadSubsectionExtractor<?> subsectionExtractor, List<FieldDescriptor> descriptors) {
        this(partName, subsectionExtractor, descriptors, null, false);
    }

    protected RequestPartFieldsSnippet(String partName, PayloadSubsectionExtractor<?> subsectionExtractor, List<FieldDescriptor> descriptors, boolean ignoreUndocumentedFields) {
        this(partName, subsectionExtractor, descriptors, null, ignoreUndocumentedFields);
    }

    protected RequestPartFieldsSnippet(String partName, PayloadSubsectionExtractor<?> subsectionExtractor, List<FieldDescriptor> descriptors, Map<String, Object> attributes) {
        this(partName, subsectionExtractor, descriptors, attributes, false);
    }

    protected RequestPartFieldsSnippet(String partName, PayloadSubsectionExtractor<?> subsectionExtractor, List<FieldDescriptor> descriptors, Map<String, Object> attributes, boolean ignoreUndocumentedFields) {
        super("request-part-" + partName, "request-part", descriptors, attributes, ignoreUndocumentedFields, subsectionExtractor);
        this.partName = partName;
    }

    @Override
    protected MediaType getContentType(Operation operation) {
        return this.findPart(operation).getHeaders().getContentType();
    }

    @Override
    protected byte[] getContent(Operation operation) throws IOException {
        return this.findPart(operation).getContent();
    }

    private OperationRequestPart findPart(Operation operation) {
        for (OperationRequestPart candidate : operation.getRequest().getParts()) {
            if (!candidate.getName().equals(this.partName)) continue;
            return candidate;
        }
        throw new SnippetException("A request part named '" + this.partName + "' was not found in the request");
    }

    public final RequestPartFieldsSnippet and(FieldDescriptor ... additionalDescriptors) {
        return this.andWithPrefix("", additionalDescriptors);
    }

    public final RequestPartFieldsSnippet and(List<FieldDescriptor> additionalDescriptors) {
        return this.andWithPrefix("", additionalDescriptors);
    }

    public final RequestPartFieldsSnippet andWithPrefix(String pathPrefix, FieldDescriptor ... additionalDescriptors) {
        ArrayList<FieldDescriptor> combinedDescriptors = new ArrayList<FieldDescriptor>();
        combinedDescriptors.addAll(this.getFieldDescriptors());
        combinedDescriptors.addAll(PayloadDocumentation.applyPathPrefix(pathPrefix, Arrays.asList(additionalDescriptors)));
        return new RequestPartFieldsSnippet(this.partName, combinedDescriptors, this.getAttributes());
    }

    public final RequestPartFieldsSnippet andWithPrefix(String pathPrefix, List<FieldDescriptor> additionalDescriptors) {
        ArrayList<FieldDescriptor> combinedDescriptors = new ArrayList<FieldDescriptor>(this.getFieldDescriptors());
        combinedDescriptors.addAll(PayloadDocumentation.applyPathPrefix(pathPrefix, additionalDescriptors));
        return new RequestPartFieldsSnippet(this.partName, combinedDescriptors, this.getAttributes());
    }
}

