/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.operation;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.restdocs.operation.OperationMessage;

abstract class AbstractOperationMessage
implements OperationMessage {
    private final byte[] content;
    private final HttpHeaders headers;

    AbstractOperationMessage(byte[] content, HttpHeaders headers) {
        this.content = content != null ? content : new byte[]{};
        this.headers = headers;
    }

    @Override
    public byte[] getContent() {
        return Arrays.copyOf(this.content, this.content.length);
    }

    @Override
    public HttpHeaders getHeaders() {
        return HttpHeaders.readOnlyHttpHeaders((HttpHeaders)this.headers);
    }

    @Override
    public String getContentAsString() {
        if (this.content.length > 0) {
            Charset charset = this.extractCharsetFromContentTypeHeader();
            if (charset == null) {
                charset = StandardCharsets.UTF_8;
            }
            return new String(this.content, charset);
        }
        return "";
    }

    private Charset extractCharsetFromContentTypeHeader() {
        if (this.headers == null) {
            return null;
        }
        MediaType contentType = this.headers.getContentType();
        if (contentType == null) {
            return null;
        }
        return contentType.getCharset();
    }
}

