/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.config;

import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.restdocs.RestDocumentationContext;
import org.springframework.restdocs.config.AbstractConfigurer;
import org.springframework.restdocs.config.SnippetConfiguration;
import org.springframework.restdocs.mustache.Mustache;
import org.springframework.restdocs.snippet.RestDocumentationContextPlaceholderResolverFactory;
import org.springframework.restdocs.snippet.StandardWriterResolver;
import org.springframework.restdocs.snippet.WriterResolver;
import org.springframework.restdocs.templates.StandardTemplateResourceResolver;
import org.springframework.restdocs.templates.TemplateEngine;
import org.springframework.restdocs.templates.TemplateFormats;
import org.springframework.restdocs.templates.mustache.AsciidoctorTableCellContentLambda;
import org.springframework.restdocs.templates.mustache.MustacheTemplateEngine;

public abstract class RestDocumentationConfigurer<S extends AbstractConfigurer, P extends AbstractConfigurer, T> {
    private final WriterResolverConfigurer writerResolverConfigurer = new WriterResolverConfigurer();
    private final TemplateEngineConfigurer templateEngineConfigurer = new TemplateEngineConfigurer();

    public abstract S snippets();

    public abstract P operationPreprocessors();

    public final T templateEngine(TemplateEngine templateEngine) {
        this.templateEngineConfigurer.setTemplateEngine(templateEngine);
        return (T)this;
    }

    public final T writerResolver(WriterResolver writerResolver) {
        this.writerResolverConfigurer.setWriterResolver(writerResolver);
        return (T)this;
    }

    protected final void apply(Map<String, Object> configuration, RestDocumentationContext context) {
        List<AbstractConfigurer> configurers = Arrays.asList(this.snippets(), this.operationPreprocessors(), this.templateEngineConfigurer, this.writerResolverConfigurer);
        for (AbstractConfigurer configurer : configurers) {
            configurer.apply(configuration, context);
        }
    }

    private static final class WriterResolverConfigurer
    extends AbstractConfigurer {
        private WriterResolver writerResolver;

        private WriterResolverConfigurer() {
        }

        @Override
        public void apply(Map<String, Object> configuration, RestDocumentationContext context) {
            WriterResolver resolverToUse = this.writerResolver;
            if (resolverToUse == null) {
                SnippetConfiguration snippetConfiguration = (SnippetConfiguration)configuration.get(SnippetConfiguration.class.getName());
                resolverToUse = new StandardWriterResolver(new RestDocumentationContextPlaceholderResolverFactory(), snippetConfiguration.getEncoding(), snippetConfiguration.getTemplateFormat());
            }
            configuration.put(WriterResolver.class.getName(), resolverToUse);
        }

        private void setWriterResolver(WriterResolver writerResolver) {
            this.writerResolver = writerResolver;
        }
    }

    private static final class TemplateEngineConfigurer
    extends AbstractConfigurer {
        private TemplateEngine templateEngine;

        private TemplateEngineConfigurer() {
        }

        @Override
        public void apply(Map<String, Object> configuration, RestDocumentationContext context) {
            TemplateEngine engineToUse = this.templateEngine;
            if (engineToUse == null) {
                SnippetConfiguration snippetConfiguration = (SnippetConfiguration)configuration.get(SnippetConfiguration.class.getName());
                HashMap<String, Object> templateContext = new HashMap<String, Object>();
                if (snippetConfiguration.getTemplateFormat().getId().equals(TemplateFormats.asciidoctor().getId())) {
                    templateContext.put("tableCellContent", new AsciidoctorTableCellContentLambda());
                }
                engineToUse = new MustacheTemplateEngine(new StandardTemplateResourceResolver(snippetConfiguration.getTemplateFormat()), Charset.forName(snippetConfiguration.getEncoding()), Mustache.compiler().escapeHTML(false), templateContext);
            }
            configuration.put(TemplateEngine.class.getName(), engineToUse);
        }

        private void setTemplateEngine(TemplateEngine templateEngine) {
            this.templateEngine = templateEngine;
        }
    }
}

