/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.templates.mustache;

import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.Map;
import org.springframework.core.io.Resource;
import org.springframework.restdocs.mustache.Mustache;
import org.springframework.restdocs.templates.Template;
import org.springframework.restdocs.templates.TemplateEngine;
import org.springframework.restdocs.templates.TemplateResourceResolver;
import org.springframework.restdocs.templates.mustache.MustacheTemplate;

public class MustacheTemplateEngine
implements TemplateEngine {
    private final TemplateResourceResolver templateResourceResolver;
    private final Mustache.Compiler compiler;
    private final Map<String, Object> context;

    public MustacheTemplateEngine(TemplateResourceResolver templateResourceResolver) {
        this(templateResourceResolver, Mustache.compiler().escapeHTML(false));
    }

    public MustacheTemplateEngine(TemplateResourceResolver templateResourceResolver, Mustache.Compiler compiler) {
        this(templateResourceResolver, compiler, Collections.emptyMap());
    }

    public MustacheTemplateEngine(TemplateResourceResolver templateResourceResolver, Mustache.Compiler compiler, Map<String, Object> context) {
        this.templateResourceResolver = templateResourceResolver;
        this.compiler = compiler;
        this.context = context;
    }

    @Override
    public Template compileTemplate(String name) throws IOException {
        Resource templateResource = this.templateResourceResolver.resolveTemplateResource(name);
        return new MustacheTemplate(this.compiler.compile(new InputStreamReader(templateResource.getInputStream())), this.context);
    }

    protected final Mustache.Compiler getCompiler() {
        return this.compiler;
    }

    protected final TemplateResourceResolver getTemplateResourceResolver() {
        return this.templateResourceResolver;
    }
}

