/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.snippet;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.springframework.restdocs.RestDocumentationContext;
import org.springframework.restdocs.snippet.PlaceholderResolverFactory;
import org.springframework.restdocs.snippet.WriterResolver;
import org.springframework.restdocs.templates.TemplateFormat;
import org.springframework.restdocs.templates.TemplateFormats;
import org.springframework.util.PropertyPlaceholderHelper;

public final class StandardWriterResolver
implements WriterResolver {
    private final PlaceholderResolverFactory placeholderResolverFactory;
    private final PropertyPlaceholderHelper propertyPlaceholderHelper = new PropertyPlaceholderHelper("{", "}");
    private String encoding = "UTF-8";
    private TemplateFormat templateFormat;

    @Deprecated
    public StandardWriterResolver(PropertyPlaceholderHelper.PlaceholderResolver placeholderResolver) {
        this(new SingleInstancePlaceholderResolverFactory(placeholderResolver), "UTF-8", TemplateFormats.asciidoctor());
    }

    public StandardWriterResolver(PlaceholderResolverFactory placeholderResolverFactory, String encoding, TemplateFormat templateFormat) {
        this.placeholderResolverFactory = placeholderResolverFactory;
        this.encoding = encoding;
        this.templateFormat = templateFormat;
    }

    @Override
    public Writer resolve(String operationName, String snippetName, RestDocumentationContext context) throws IOException {
        File outputFile = this.resolveFile(this.propertyPlaceholderHelper.replacePlaceholders(operationName, this.placeholderResolverFactory.create(context)), snippetName + "." + this.templateFormat.getFileExtension(), context);
        if (outputFile != null) {
            this.createDirectoriesIfNecessary(outputFile);
            return new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), this.encoding);
        }
        return new OutputStreamWriter((OutputStream)System.out, this.encoding);
    }

    @Override
    @Deprecated
    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    File resolveFile(String outputDirectory, String fileName, RestDocumentationContext context) {
        File outputFile = new File(outputDirectory, fileName);
        if (!outputFile.isAbsolute()) {
            outputFile = this.makeRelativeToConfiguredOutputDir(outputFile, context);
        }
        return outputFile;
    }

    private File makeRelativeToConfiguredOutputDir(File outputFile, RestDocumentationContext context) {
        File configuredOutputDir = context.getOutputDirectory();
        if (configuredOutputDir != null) {
            return new File(configuredOutputDir, outputFile.getPath());
        }
        return null;
    }

    private void createDirectoriesIfNecessary(File outputFile) {
        File parent = outputFile.getParentFile();
        if (!parent.isDirectory() && !parent.mkdirs()) {
            throw new IllegalStateException("Failed to create directory '" + parent + "'");
        }
    }

    private static final class SingleInstancePlaceholderResolverFactory
    implements PlaceholderResolverFactory {
        private final PropertyPlaceholderHelper.PlaceholderResolver placeholderResolver;

        private SingleInstancePlaceholderResolverFactory(PropertyPlaceholderHelper.PlaceholderResolver placeholderResolver) {
            this.placeholderResolver = placeholderResolver;
        }

        @Override
        public PropertyPlaceholderHelper.PlaceholderResolver create(RestDocumentationContext context) {
            return this.placeholderResolver;
        }
    }
}

