/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.payload;

import java.util.Collection;
import java.util.Map;
import org.springframework.restdocs.payload.JsonFieldPath;
import org.springframework.restdocs.payload.JsonFieldProcessor;
import org.springframework.restdocs.payload.JsonFieldType;

class JsonFieldTypeResolver {
    private final JsonFieldProcessor fieldProcessor = new JsonFieldProcessor();

    JsonFieldTypeResolver() {
    }

    JsonFieldType resolveFieldType(String path, Object payload) {
        JsonFieldPath fieldPath = JsonFieldPath.compile(path);
        Object field = this.fieldProcessor.extract(fieldPath, payload);
        if (field instanceof Collection && !fieldPath.isPrecise()) {
            JsonFieldType commonType = null;
            for (Object item : (Collection)field) {
                JsonFieldType fieldType = this.determineFieldType(item);
                if (commonType == null) {
                    commonType = fieldType;
                    continue;
                }
                if (fieldType == commonType) continue;
                return JsonFieldType.VARIES;
            }
            return commonType;
        }
        return this.determineFieldType(field);
    }

    private JsonFieldType determineFieldType(Object fieldValue) {
        if (fieldValue == null) {
            return JsonFieldType.NULL;
        }
        if (fieldValue instanceof String) {
            return JsonFieldType.STRING;
        }
        if (fieldValue instanceof Map) {
            return JsonFieldType.OBJECT;
        }
        if (fieldValue instanceof Collection) {
            return JsonFieldType.ARRAY;
        }
        if (fieldValue instanceof Boolean) {
            return JsonFieldType.BOOLEAN;
        }
        return JsonFieldType.NUMBER;
    }
}

