/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.payload;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class JsonFieldPath {
    private static final Pattern BRACKETS_AND_ARRAY_PATTERN = Pattern.compile("\\['(.+?)'\\]|\\[([0-9]+|\\*){0,1}\\]");
    private static final Pattern ARRAY_INDEX_PATTERN = Pattern.compile("\\[([0-9]+|\\*){0,1}\\]");
    private final String rawPath;
    private final List<String> segments;
    private final boolean precise;
    private final boolean array;

    private JsonFieldPath(String rawPath, List<String> segments, boolean precise, boolean array) {
        this.rawPath = rawPath;
        this.segments = segments;
        this.precise = precise;
        this.array = array;
    }

    boolean isPrecise() {
        return this.precise;
    }

    boolean isArray() {
        return this.array;
    }

    List<String> getSegments() {
        return this.segments;
    }

    public String toString() {
        return this.rawPath;
    }

    static JsonFieldPath compile(String path) {
        List<String> segments = JsonFieldPath.extractSegments(path);
        return new JsonFieldPath(path, segments, JsonFieldPath.matchesSingleValue(segments), JsonFieldPath.isArraySegment(segments.get(segments.size() - 1)));
    }

    static boolean isArraySegment(String segment) {
        return ARRAY_INDEX_PATTERN.matcher(segment).matches();
    }

    static boolean matchesSingleValue(List<String> segments) {
        Iterator<String> iterator = segments.iterator();
        while (iterator.hasNext()) {
            if (!JsonFieldPath.isArraySegment(iterator.next()) || !iterator.hasNext()) continue;
            return false;
        }
        return true;
    }

    private static List<String> extractSegments(String path) {
        Matcher matcher = BRACKETS_AND_ARRAY_PATTERN.matcher(path);
        int previous = 0;
        ArrayList<String> segments = new ArrayList<String>();
        while (matcher.find()) {
            if (previous != matcher.start()) {
                segments.addAll(JsonFieldPath.extractDotSeparatedSegments(path.substring(previous, matcher.start())));
            }
            if (matcher.group(1) != null) {
                segments.add(matcher.group(1));
            } else {
                segments.add(matcher.group());
            }
            previous = matcher.end(0);
        }
        if (previous < path.length()) {
            segments.addAll(JsonFieldPath.extractDotSeparatedSegments(path.substring(previous)));
        }
        return segments;
    }

    private static List<String> extractDotSeparatedSegments(String path) {
        ArrayList<String> segments = new ArrayList<String>();
        for (String segment : path.split("\\.")) {
            if (segment.length() <= 0) continue;
            segments.add(segment);
        }
        return segments;
    }
}

