/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs;

import java.io.File;
import org.springframework.restdocs.RestDocumentationContext;
import org.springframework.restdocs.RestDocumentationContextProvider;

public final class ManualRestDocumentation
implements RestDocumentationContextProvider {
    private final File outputDirectory;
    private RestDocumentationContext context;

    public ManualRestDocumentation(String outputDirectory) {
        this.outputDirectory = new File(outputDirectory);
    }

    public void beforeTest(Class<?> testClass, String testMethodName) {
        if (this.context != null) {
            throw new IllegalStateException("Context already exists. Did you forget to call afterTest()?");
        }
        this.context = new RestDocumentationContext(testClass, testMethodName, this.outputDirectory);
    }

    public void afterTest() {
        this.context = null;
    }

    @Override
    public RestDocumentationContext beforeOperation() {
        this.context.getAndIncrementStepCount();
        return this.context;
    }
}

