/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.repository.config;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.dao.NonTransientDataAccessException;
import org.springframework.data.relational.core.dialect.Db2Dialect;
import org.springframework.data.relational.core.dialect.Dialect;
import org.springframework.data.relational.core.dialect.H2Dialect;
import org.springframework.data.relational.core.dialect.HsqlDbDialect;
import org.springframework.data.relational.core.dialect.MySqlDialect;
import org.springframework.data.relational.core.dialect.PostgresDialect;
import org.springframework.data.relational.core.dialect.SqlServerDialect;
import org.springframework.data.relational.core.sql.IdentifierProcessing;
import org.springframework.data.util.Optionals;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public class DialectResolver {
    private static final List<JdbcDialectProvider> DETECTORS = SpringFactoriesLoader.loadFactories(JdbcDialectProvider.class, (ClassLoader)DialectResolver.class.getClassLoader());

    private DialectResolver() {
    }

    public static Dialect getDialect(JdbcOperations operations) {
        return (Dialect)DETECTORS.stream().map(it -> it.getDialect(operations)).flatMap(xva$0 -> Optionals.toStream((Optional[])new Optional[]{xva$0})).findFirst().orElseThrow(() -> new NoDialectException(String.format("Cannot determine a dialect for %s. Please provide a Dialect.", operations)));
    }

    public static class NoDialectException
    extends NonTransientDataAccessException {
        NoDialectException(String msg) {
            super(msg);
        }
    }

    public static class DefaultDialectProvider
    implements JdbcDialectProvider {
        @Override
        public Optional<Dialect> getDialect(JdbcOperations operations) {
            return Optional.ofNullable(operations.execute(DefaultDialectProvider::getDialect));
        }

        @Nullable
        private static Dialect getDialect(Connection connection) throws SQLException {
            DatabaseMetaData metaData = connection.getMetaData();
            String name = metaData.getDatabaseProductName().toLowerCase(Locale.ENGLISH);
            if (name.contains("hsql")) {
                return HsqlDbDialect.INSTANCE;
            }
            if (name.contains("h2")) {
                return H2Dialect.INSTANCE;
            }
            if (name.contains("mysql")) {
                return new MySqlDialect(DefaultDialectProvider.getIdentifierProcessing(metaData));
            }
            if (name.contains("postgresql")) {
                return PostgresDialect.INSTANCE;
            }
            if (name.contains("microsoft")) {
                return SqlServerDialect.INSTANCE;
            }
            if (name.contains("db2")) {
                return Db2Dialect.INSTANCE;
            }
            return null;
        }

        private static IdentifierProcessing getIdentifierProcessing(DatabaseMetaData metaData) throws SQLException {
            IdentifierProcessing.Quoting quoting;
            String quoteString = metaData.getIdentifierQuoteString();
            IdentifierProcessing.Quoting quoting2 = quoting = StringUtils.hasText((String)quoteString) ? new IdentifierProcessing.Quoting(quoteString) : IdentifierProcessing.Quoting.NONE;
            IdentifierProcessing.LetterCasing letterCasing = metaData.supportsMixedCaseIdentifiers() ? IdentifierProcessing.LetterCasing.AS_IS : (metaData.storesUpperCaseIdentifiers() ? IdentifierProcessing.LetterCasing.UPPER_CASE : (metaData.storesLowerCaseIdentifiers() ? IdentifierProcessing.LetterCasing.LOWER_CASE : IdentifierProcessing.LetterCasing.UPPER_CASE));
            return IdentifierProcessing.create((IdentifierProcessing.Quoting)quoting, (IdentifierProcessing.LetterCasing)letterCasing);
        }
    }

    public static interface JdbcDialectProvider {
        public Optional<Dialect> getDialect(JdbcOperations var1);
    }
}

