/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.partition.support;

import java.util.ArrayList;
import java.util.Collection;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.partition.support.DefaultStepExecutionAggregator;
import org.springframework.batch.core.partition.support.StepExecutionAggregator;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class RemoteStepExecutionAggregator
implements StepExecutionAggregator,
InitializingBean {
    private StepExecutionAggregator delegate = new DefaultStepExecutionAggregator();
    private JobExplorer jobExplorer;

    public RemoteStepExecutionAggregator() {
    }

    public RemoteStepExecutionAggregator(JobExplorer jobExplorer) {
        this.jobExplorer = jobExplorer;
    }

    public void setJobExplorer(JobExplorer jobExplorer) {
        this.jobExplorer = jobExplorer;
    }

    public void setDelegate(StepExecutionAggregator delegate) {
        this.delegate = delegate;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.jobExplorer != null ? 1 : 0) != 0, (String)"A JobExplorer must be provided");
    }

    @Override
    public void aggregate(StepExecution result, Collection<StepExecution> executions) {
        Assert.notNull((Object)result, (String)"To aggregate into a result it must be non-null.");
        if (executions == null) {
            return;
        }
        ArrayList<StepExecution> updates = new ArrayList<StepExecution>();
        for (StepExecution stepExecution : executions) {
            Long id = stepExecution.getId();
            Assert.state((id != null ? 1 : 0) != 0, (String)("StepExecution has null id. It must be saved first: " + stepExecution));
            StepExecution update = this.jobExplorer.getStepExecution(stepExecution.getJobExecutionId(), id);
            Assert.state((update != null ? 1 : 0) != 0, (String)("Could not reload StepExecution from JobRepository: " + stepExecution));
            updates.add(update);
        }
        this.delegate.aggregate(result, updates);
    }
}

