/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.config;

import java.util.List;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.BeanDefinitionParserDelegate;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.core.Conventions;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public abstract class NamespaceUtils {
    static final String BASE_PACKAGE = "org.springframework.amqp.core.rabbit.config";
    static final String REF_ATTRIBUTE = "ref";
    static final String METHOD_ATTRIBUTE = "method";
    static final String ORDER = "order";

    public static boolean setValueIfAttributeDefined(BeanDefinitionBuilder builder, Element element, String attributeName, String propertyName) {
        String attributeValue = element.getAttribute(attributeName);
        if (StringUtils.hasText((String)attributeValue)) {
            builder.addPropertyValue(propertyName, (Object)new TypedStringValue(attributeValue));
            return true;
        }
        return false;
    }

    public static boolean setValueIfAttributeDefined(BeanDefinitionBuilder builder, Element element, String attributeName) {
        return NamespaceUtils.setValueIfAttributeDefined(builder, element, attributeName, Conventions.attributeNameToPropertyName((String)attributeName));
    }

    public static boolean isAttributeDefined(Element element, String attributeName) {
        String value = element.getAttribute(attributeName);
        return StringUtils.hasText((String)value);
    }

    public static boolean addConstructorArgValueIfAttributeDefined(BeanDefinitionBuilder builder, Element element, String attributeName) {
        String value = element.getAttribute(attributeName);
        if (StringUtils.hasText((String)value)) {
            builder.addConstructorArgValue((Object)new TypedStringValue(value));
            return true;
        }
        return false;
    }

    public static void addConstructorArgBooleanValueIfAttributeDefined(BeanDefinitionBuilder builder, Element element, String attributeName, boolean defaultValue) {
        String value = element.getAttribute(attributeName);
        if (StringUtils.hasText((String)value)) {
            builder.addConstructorArgValue((Object)new TypedStringValue(value));
        } else {
            builder.addConstructorArgValue((Object)defaultValue);
        }
    }

    public static boolean addConstructorArgRefIfAttributeDefined(BeanDefinitionBuilder builder, Element element, String attributeName) {
        String value = element.getAttribute(attributeName);
        if (StringUtils.hasText((String)value)) {
            builder.addConstructorArgReference(value);
            return true;
        }
        return false;
    }

    public static boolean addConstructorArgParentRefIfAttributeDefined(BeanDefinitionBuilder builder, Element element, String attributeName) {
        String value = element.getAttribute(attributeName);
        if (StringUtils.hasText((String)value)) {
            BeanDefinitionBuilder child = BeanDefinitionBuilder.genericBeanDefinition();
            child.setParentName(value);
            builder.addConstructorArgValue((Object)child.getBeanDefinition());
            return true;
        }
        return false;
    }

    public static boolean setReferenceIfAttributeDefined(BeanDefinitionBuilder builder, Element element, String attributeName, String propertyName) {
        String attributeValue = element.getAttribute(attributeName);
        if (StringUtils.hasText((String)attributeValue)) {
            builder.addPropertyReference(propertyName, attributeValue);
            return true;
        }
        return false;
    }

    public static boolean setReferenceIfAttributeDefined(BeanDefinitionBuilder builder, Element element, String attributeName) {
        return NamespaceUtils.setReferenceIfAttributeDefined(builder, element, attributeName, Conventions.attributeNameToPropertyName((String)attributeName));
    }

    public static String createElementDescription(Element element) {
        String elementId = "'" + element.getNodeName() + "'";
        String id = element.getAttribute("id");
        if (StringUtils.hasText((String)id)) {
            elementId = elementId + " with id='" + id + "'";
        }
        return elementId;
    }

    public static BeanComponentDefinition parseInnerBeanDefinition(Element element, ParserContext parserContext) {
        String ref;
        List childElements = DomUtils.getChildElementsByTagName((Element)element, (String)"bean");
        String innerComponentDefinition = null;
        if (childElements != null && childElements.size() == 1) {
            Element beanElement = (Element)childElements.get(0);
            BeanDefinitionParserDelegate delegate = parserContext.getDelegate();
            BeanDefinitionHolder bdHolder = delegate.parseBeanDefinitionElement(beanElement);
            bdHolder = delegate.decorateBeanDefinitionIfRequired(beanElement, bdHolder);
            BeanDefinition inDef = bdHolder.getBeanDefinition();
            String beanName = BeanDefinitionReaderUtils.generateBeanName((BeanDefinition)inDef, (BeanDefinitionRegistry)parserContext.getRegistry());
            innerComponentDefinition = new BeanComponentDefinition(inDef, beanName);
            parserContext.registerBeanComponent((BeanComponentDefinition)innerComponentDefinition);
        }
        Assert.isTrue((!StringUtils.hasText((String)(ref = element.getAttribute(REF_ATTRIBUTE))) || innerComponentDefinition == null ? 1 : 0) != 0, (String)("Ambiguous definition. Inner bean " + (innerComponentDefinition == null ? innerComponentDefinition : innerComponentDefinition.getBeanDefinition().getBeanClassName()) + " declaration and \"ref\" " + ref + " are not allowed together."));
        return innerComponentDefinition;
    }

    public static void parseDeclarationControls(Element element, BeanDefinitionBuilder builder) {
        NamespaceUtils.setValueIfAttributeDefined(builder, element, "auto-declare", "shouldDeclare");
        String admins = element.getAttribute("declared-by");
        if (StringUtils.hasText((String)admins)) {
            String[] adminBeanNames = admins.split(",");
            ManagedList adminBeanRefs = new ManagedList();
            for (String adminBeanName : adminBeanNames) {
                adminBeanRefs.add((Object)new RuntimeBeanReference(adminBeanName.trim()));
            }
            builder.addPropertyValue("adminsThatShouldDeclare", (Object)adminBeanRefs);
        }
    }
}

