/*
 * Decompiled with CFR 0.152.
 */
package net.razorvine.pickle.objects;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import net.razorvine.pickle.IObjectConstructor;
import net.razorvine.pickle.PickleException;

public class ByteArrayConstructor
implements IObjectConstructor {
    @Override
    public Object construct(Object[] objectArray) throws PickleException {
        if (objectArray.length != 1 && objectArray.length != 2) {
            throw new PickleException("invalid pickle data for bytearray; expected 1 or 2 args, got " + objectArray.length);
        }
        if (objectArray.length == 1) {
            ArrayList arrayList = (ArrayList)objectArray[0];
            byte[] byArray = new byte[arrayList.size()];
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = ((Number)arrayList.get(i)).byteValue();
            }
            return byArray;
        }
        String string = (String)objectArray[0];
        String string2 = (String)objectArray[1];
        if (string2.startsWith("latin-")) {
            string2 = "ISO-8859-" + string2.substring(6);
        }
        try {
            return string.getBytes(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new PickleException("error creating bytearray: " + unsupportedEncodingException);
        }
    }
}

