/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.sonar.api.internal.apachecommons.io.FileUtils;
import org.sonar.api.internal.apachecommons.io.IOUtils;

public final class ZipUtils {
    private static final String ERROR_CREATING_DIRECTORY = "Error creating directory: ";

    private ZipUtils() {
    }

    public static File unzip(File zip, File toDir) throws IOException {
        return ZipUtils.unzip(zip, toDir, (ZipEntry ze) -> true);
    }

    public static File unzip(InputStream zip, File toDir) throws IOException {
        return ZipUtils.unzip(zip, toDir, (ZipEntry ze) -> true);
    }

    @Deprecated
    public static File unzip(InputStream stream, File toDir, ZipEntryFilter filter) throws IOException {
        return ZipUtils.unzip(stream, toDir, (Predicate<ZipEntry>)new ZipEntryFilterDelegate(filter));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File unzip(InputStream stream, File toDir, Predicate<ZipEntry> filter) throws IOException {
        if (!toDir.exists()) {
            FileUtils.forceMkdir(toDir);
        }
        try (ZipInputStream zipStream = new ZipInputStream(stream);){
            ZipEntry entry;
            while ((entry = zipStream.getNextEntry()) != null) {
                if (!filter.test(entry)) continue;
                ZipUtils.unzipEntry(entry, zipStream, toDir);
            }
            File file = toDir;
            return file;
        }
    }

    private static void unzipEntry(ZipEntry entry, ZipInputStream zipStream, File toDir) throws IOException {
        File to = new File(toDir, entry.getName());
        if (entry.isDirectory()) {
            ZipUtils.throwExceptionIfDirectoryIsNotCreatable(to);
        } else {
            File parent = to.getParentFile();
            ZipUtils.throwExceptionIfDirectoryIsNotCreatable(parent);
            ZipUtils.copy(zipStream, to);
        }
    }

    private static void throwExceptionIfDirectoryIsNotCreatable(File to) throws IOException {
        if (!to.exists() && !to.mkdirs()) {
            throw new IOException(ERROR_CREATING_DIRECTORY + to);
        }
    }

    @Deprecated
    public static File unzip(File zip, File toDir, ZipEntryFilter filter) throws IOException {
        return ZipUtils.unzip(zip, toDir, (Predicate<ZipEntry>)new ZipEntryFilterDelegate(filter));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File unzip(File zip, File toDir, Predicate<ZipEntry> filter) throws IOException {
        if (!toDir.exists()) {
            FileUtils.forceMkdir(toDir);
        }
        try (ZipFile zipFile = new ZipFile(zip);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (!filter.test(entry)) continue;
                File to = new File(toDir, entry.getName());
                if (entry.isDirectory()) {
                    ZipUtils.throwExceptionIfDirectoryIsNotCreatable(to);
                    continue;
                }
                File parent = to.getParentFile();
                ZipUtils.throwExceptionIfDirectoryIsNotCreatable(parent);
                ZipUtils.copy(zipFile, entry, to);
            }
            File file = toDir;
            return file;
        }
    }

    private static void copy(ZipInputStream zipStream, File to) throws IOException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(to);
            IOUtils.copy((InputStream)zipStream, (OutputStream)fos);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fos);
            throw throwable;
        }
        IOUtils.closeQuietly(fos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copy(ZipFile zipFile, ZipEntry entry, File to) throws IOException {
        FileOutputStream fos = new FileOutputStream(to);
        InputStream input = null;
        try {
            input = zipFile.getInputStream(entry);
            IOUtils.copy(input, (OutputStream)fos);
        }
        finally {
            IOUtils.closeQuietly(input);
            IOUtils.closeQuietly(fos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipDir(File dir, File zip) throws IOException {
        FileOutputStream out = null;
        ZipOutputStream zout = null;
        try {
            out = FileUtils.openOutputStream(zip);
            zout = new ZipOutputStream(out);
            ZipUtils.doZipDir(dir, zout);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(zout);
            IOUtils.closeQuietly(out);
            throw throwable;
        }
        IOUtils.closeQuietly(zout);
        IOUtils.closeQuietly(out);
    }

    private static void doZip(String entryName, InputStream in, ZipOutputStream out) throws IOException {
        ZipEntry entry = new ZipEntry(entryName);
        out.putNextEntry(entry);
        IOUtils.copy(in, (OutputStream)out);
        out.closeEntry();
    }

    private static void doZip(String entryName, File file, ZipOutputStream out) throws IOException {
        if (file.isDirectory()) {
            entryName = entryName + "/";
            ZipEntry entry = new ZipEntry(entryName);
            out.putNextEntry(entry);
            out.closeEntry();
            File[] files = file.listFiles();
            if (files == null) {
                throw new IllegalStateException("Fail to list files of directory " + file.getAbsolutePath());
            }
            for (File f : files) {
                ZipUtils.doZip(entryName + f.getName(), f, out);
            }
        } else {
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
                ZipUtils.doZip(entryName, in, out);
            }
        }
    }

    private static void doZipDir(File dir, ZipOutputStream out) throws IOException {
        File[] children = dir.listFiles();
        if (children == null) {
            throw new IllegalStateException("Fail to list files of directory " + dir.getAbsolutePath());
        }
        for (File child : children) {
            ZipUtils.doZip(child.getName(), child, out);
        }
    }

    private static class ZipEntryFilterDelegate
    implements Predicate<ZipEntry> {
        private final ZipEntryFilter delegate;

        private ZipEntryFilterDelegate(ZipEntryFilter delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean test(ZipEntry zipEntry) {
            return this.delegate.accept(zipEntry);
        }
    }

    @Deprecated
    @FunctionalInterface
    public static interface ZipEntryFilter {
        public boolean accept(ZipEntry var1);
    }
}

