/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.resolve;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.TypePath;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.java.resolve.AnnotationInstanceResolve;
import org.sonar.java.resolve.ArrayJavaType;
import org.sonar.java.resolve.BytecodeAnnotationVisitor;
import org.sonar.java.resolve.BytecodeCompleter;
import org.sonar.java.resolve.BytecodeFieldVisitor;
import org.sonar.java.resolve.BytecodeMethodVisitor;
import org.sonar.java.resolve.ClassJavaType;
import org.sonar.java.resolve.Convert;
import org.sonar.java.resolve.Flags;
import org.sonar.java.resolve.JavaSymbol;
import org.sonar.java.resolve.JavaType;
import org.sonar.java.resolve.MethodJavaType;
import org.sonar.java.resolve.ParametrizedTypeCache;
import org.sonar.java.resolve.Scope;
import org.sonar.java.resolve.SymbolMetadataResolve;
import org.sonar.java.resolve.Symbols;
import org.sonar.java.resolve.TypeSubstitution;
import org.sonar.java.resolve.TypeVariableJavaType;
import org.sonar.java.resolve.WildCardType;

public class BytecodeVisitor
extends ClassVisitor {
    private static final Logger LOG = Loggers.get(BytecodeVisitor.class);
    private final Symbols symbols;
    private final JavaSymbol.TypeJavaSymbol classSymbol;
    private final ParametrizedTypeCache parametrizedTypeCache;
    private BytecodeCompleter bytecodeCompleter;
    private String className;

    BytecodeVisitor(BytecodeCompleter bytecodeCompleter, Symbols symbols, JavaSymbol.TypeJavaSymbol classSymbol, ParametrizedTypeCache parametrizedTypeCache) {
        super(327680);
        this.bytecodeCompleter = bytecodeCompleter;
        this.symbols = symbols;
        this.classSymbol = classSymbol;
        this.parametrizedTypeCache = parametrizedTypeCache;
    }

    private JavaSymbol.TypeJavaSymbol getClassSymbol(String bytecodeName) {
        return this.bytecodeCompleter.getClassSymbol(Convert.flatName(bytecodeName));
    }

    private JavaSymbol.TypeJavaSymbol getClassSymbol(JavaSymbol.TypeJavaSymbol classSymbol, String bytecodeName, int flags) {
        return this.bytecodeCompleter.getClassSymbol(classSymbol, Convert.flatName(bytecodeName), flags);
    }

    private JavaSymbol.TypeJavaSymbol getClassSymbol(String bytecodeName, int flags) {
        return this.bytecodeCompleter.getClassSymbol(Convert.flatName(bytecodeName), flags);
    }

    public void visit(int version, int flags, String name, @Nullable String signature, @Nullable String superName, @Nullable String[] interfaces) {
        Preconditions.checkState((boolean)name.endsWith(this.classSymbol.name), (String)"Name : '%s' should ends with %s", (Object[])new Object[]{name, this.classSymbol.name});
        Preconditions.checkState((name.endsWith("package-info") || BytecodeVisitor.isNotSynthetic(flags) ? 1 : 0) != 0, (String)"%s is synthetic", (Object[])new Object[]{name});
        this.className = name;
        if (signature != null) {
            SignatureReader signatureReader = new SignatureReader(signature);
            signatureReader.accept((SignatureVisitor)new TypeParameterDeclaration(this.classSymbol));
            ReadGenericSignature readGenericSignature = new ReadGenericSignature();
            signatureReader.accept((SignatureVisitor)readGenericSignature);
            ((ClassJavaType)this.classSymbol.type).interfaces = readGenericSignature.interfaces();
        } else {
            if (superName == null) {
                Preconditions.checkState((boolean)"java/lang/Object".equals(this.className), (String)"superName must be null only for java/lang/Object, but not for %s", (Object[])new Object[]{this.className});
            } else {
                ((ClassJavaType)this.classSymbol.type).supertype = this.getClassSymbol((String)superName).type;
            }
            ((ClassJavaType)this.classSymbol.type).interfaces = this.getCompletedClassSymbolsType(interfaces);
        }
        this.classSymbol.flags = (this.classSymbol.flags & 7) != 0 ? (this.classSymbol.flags |= Flags.filterAccessBytecodeFlags(flags & 0xFFFFFFF8)) : (this.classSymbol.flags |= Flags.filterAccessBytecodeFlags(flags));
        this.classSymbol.members = new Scope(this.classSymbol);
    }

    private static boolean isNotSynthetic(int flags) {
        return Flags.isNotFlagged(flags, 4096);
    }

    public void visitSource(@Nullable String source, @Nullable String debug) {
        throw new IllegalStateException();
    }

    public void visitOuterClass(String owner, String name, String desc) {
        throw new IllegalStateException();
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        JavaType annotationType = this.convertAsmType(Type.getType((String)desc), 8192);
        AnnotationInstanceResolve annotationInstance = new AnnotationInstanceResolve(annotationType.getSymbol());
        ((SymbolMetadataResolve)this.classSymbol.metadata()).addAnnotation(annotationInstance);
        return new BytecodeAnnotationVisitor(annotationInstance, this);
    }

    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
        return null;
    }

    public void visitAttribute(Attribute attr) {
    }

    public void visitInnerClass(String name, @Nullable String outerName, @Nullable String innerName, int flags) {
        if (BytecodeVisitor.isNotSynthetic(flags) && innerName != null && outerName != null) {
            if (this.className.equals(outerName)) {
                this.defineInnerClass(name, flags);
            } else if (this.className.equals(name)) {
                this.defineOuterClass(outerName, innerName, flags);
            }
        }
    }

    private void defineInnerClass(String bytecodeName, int flags) {
        JavaSymbol.TypeJavaSymbol innerClass = this.getClassSymbol(this.classSymbol, bytecodeName, flags);
        innerClass.flags |= Flags.filterAccessBytecodeFlags(flags);
        Preconditions.checkState((innerClass.owner == this.classSymbol ? 1 : 0) != 0, (Object)("Innerclass: " + innerClass.owner.getName() + " and classSymbol: " + this.classSymbol.getName() + " are not the same."));
        this.classSymbol.members.enter(innerClass);
    }

    private void defineOuterClass(String outerName, String innerName, int flags) {
        JavaSymbol.TypeJavaSymbol outerClassSymbol = this.getClassSymbol(outerName, flags);
        Preconditions.checkState((outerClassSymbol.completer == null || outerClassSymbol.completer instanceof BytecodeCompleter ? 1 : 0) != 0);
        this.classSymbol.name = innerName;
        this.classSymbol.flags = flags | Flags.filterAccessBytecodeFlags(this.classSymbol.flags & 0xFFFFFFF8);
        this.classSymbol.owner = outerClassSymbol;
    }

    public FieldVisitor visitField(int flags, String name, String desc, @Nullable String signature, @Nullable Object value) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)desc);
        if (BytecodeVisitor.isNotSynthetic(flags)) {
            int filteredFlags = Flags.filterAccessBytecodeFlags(flags);
            JavaType type = this.convertAsmType(Type.getType((String)desc));
            JavaSymbol.VariableJavaSymbol symbol = new JavaSymbol.VariableJavaSymbol(filteredFlags, name, type, this.classSymbol, value);
            this.classSymbol.members.enter(symbol);
            if (signature != null) {
                ReadType typeReader = new ReadType();
                new SignatureReader(signature).accept((SignatureVisitor)typeReader);
                symbol.type = typeReader.typeRead;
            }
            return new BytecodeFieldVisitor(symbol, this);
        }
        return null;
    }

    public MethodVisitor visitMethod(int flags, String name, String desc, @Nullable String signature, @Nullable String[] exceptions) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)desc);
        if (BytecodeVisitor.isNotSynthetic(flags)) {
            if ((flags & 0x40) != 0) {
                LOG.warn("bridge method {} not marked as synthetic in class {}", (Object)name, (Object)this.className);
                return null;
            }
            MethodJavaType type = new MethodJavaType(this.convertAsmTypes(Type.getArgumentTypes((String)desc)), this.convertAsmType(Type.getReturnType((String)desc)), this.getCompletedClassSymbolsType(exceptions), this.classSymbol);
            int methodFlags = Flags.filterAccessBytecodeFlags(flags);
            if (this.classSymbol.isInterface() && Flags.isNotFlagged(methodFlags, 1034)) {
                methodFlags |= 0x8000;
            }
            JavaSymbol.MethodJavaSymbol methodSymbol = new JavaSymbol.MethodJavaSymbol(methodFlags, name, type, (JavaSymbol)this.classSymbol);
            methodSymbol.desc = desc;
            this.classSymbol.members.enter(methodSymbol);
            if (signature != null) {
                SignatureReader signatureReader = new SignatureReader(signature);
                signatureReader.accept((SignatureVisitor)new TypeParameterDeclaration(methodSymbol));
                signatureReader.accept((SignatureVisitor)new ReadMethodSignature(methodSymbol));
            }
            methodSymbol.parameters = new Scope(methodSymbol);
            for (int i = 0; i < type.argTypes.size(); ++i) {
                methodSymbol.parameters.enter(new JavaSymbol.VariableJavaSymbol(0, "arg" + i, methodSymbol));
            }
            return new BytecodeMethodVisitor(methodSymbol, this);
        }
        return null;
    }

    private List<JavaType> convertAsmTypes(Type[] asmTypes) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (Type asmType : asmTypes) {
            result.add((Object)this.convertAsmType(asmType));
        }
        return result.build();
    }

    public JavaType convertAsmType(Type asmType) {
        return this.convertAsmType(asmType, 0);
    }

    public JavaType convertAsmType(Type asmType, int flags) {
        JavaType result;
        switch (asmType.getSort()) {
            case 10: {
                result = this.getClassSymbol((String)asmType.getInternalName(), (int)flags).type;
                break;
            }
            case 3: {
                result = this.symbols.byteType;
                break;
            }
            case 2: {
                result = this.symbols.charType;
                break;
            }
            case 4: {
                result = this.symbols.shortType;
                break;
            }
            case 5: {
                result = this.symbols.intType;
                break;
            }
            case 7: {
                result = this.symbols.longType;
                break;
            }
            case 6: {
                result = this.symbols.floatType;
                break;
            }
            case 8: {
                result = this.symbols.doubleType;
                break;
            }
            case 1: {
                result = this.symbols.booleanType;
                break;
            }
            case 9: {
                result = this.buildArrayType(this.convertAsmType(asmType.getElementType()), asmType.getDimensions());
                break;
            }
            case 0: {
                result = this.symbols.voidType;
                break;
            }
            default: {
                throw new IllegalArgumentException(asmType.toString());
            }
        }
        return result;
    }

    private JavaType buildArrayType(JavaType elementType, int dimensions) {
        ArrayJavaType type = new ArrayJavaType(elementType, this.symbols.arrayClass);
        for (int i = 1; i < dimensions; ++i) {
            type = new ArrayJavaType(type, this.symbols.arrayClass);
        }
        return type;
    }

    public void visitEnd() {
        if (this.classSymbol.owner == null) {
            String flatName = this.className.replace('/', '.');
            this.classSymbol.name = flatName.substring(flatName.lastIndexOf(46) + 1);
            this.classSymbol.owner = this.bytecodeCompleter.enterPackage(flatName);
            JavaSymbol.PackageJavaSymbol owner = (JavaSymbol.PackageJavaSymbol)this.classSymbol.owner;
            if (owner.members == null) {
                owner.members = new Scope(owner);
            }
            owner.members.enter(this.classSymbol);
        }
    }

    private List<JavaType> getCompletedClassSymbolsType(@Nullable String[] bytecodeNames) {
        if (bytecodeNames == null) {
            return ImmutableList.of();
        }
        return Arrays.stream(bytecodeNames).map(bName -> this.getClassSymbol((String)bName).type).collect(Collectors.toList());
    }

    private class ReadType
    extends SignatureVisitor {
        @Nullable
        private final JavaSymbol.MethodJavaSymbol methodSymbol;
        JavaType typeRead;
        String bytecodeName;
        List<JavaType> typeArguments;

        public ReadType() {
            super(327680);
            this.typeArguments = Lists.newArrayList();
            this.methodSymbol = null;
        }

        public ReadType(JavaSymbol.MethodJavaSymbol methodSymbol) {
            super(327680);
            this.typeArguments = Lists.newArrayList();
            this.methodSymbol = methodSymbol;
        }

        public void visitInnerClassType(String name) {
            this.bytecodeName = this.bytecodeName + "$" + name;
            this.typeRead = ((BytecodeVisitor)BytecodeVisitor.this).getClassSymbol((String)this.bytecodeName).type;
            this.typeArguments = Lists.newArrayList();
        }

        public void visitClassType(String name) {
            this.bytecodeName = name;
            this.typeRead = ((BytecodeVisitor)BytecodeVisitor.this).getClassSymbol((String)name).type;
        }

        public void visitTypeArgument() {
            this.typeArguments.add(((BytecodeVisitor)BytecodeVisitor.this).symbols.unboundedWildcard);
        }

        public SignatureVisitor visitTypeArgument(final char wildcard) {
            return new ReadType(this.methodSymbol){

                @Override
                public void visitEnd() {
                    JavaType typeArgument;
                    super.visitEnd();
                    switch (wildcard) {
                        case '+': {
                            typeArgument = BytecodeVisitor.this.parametrizedTypeCache.getWildcardType(this.typeRead, WildCardType.BoundType.EXTENDS);
                            break;
                        }
                        case '-': {
                            typeArgument = BytecodeVisitor.this.parametrizedTypeCache.getWildcardType(this.typeRead, WildCardType.BoundType.SUPER);
                            break;
                        }
                        default: {
                            typeArgument = this.typeRead;
                        }
                    }
                    ReadType.this.typeArguments.add(typeArgument);
                }
            };
        }

        public SignatureVisitor visitArrayType() {
            return new ReadType(this.methodSymbol){

                @Override
                public void visitEnd() {
                    super.visitEnd();
                    ReadType.this.typeRead = new ArrayJavaType(this.typeRead, ((BytecodeVisitor)BytecodeVisitor.this).symbols.arrayClass);
                    ReadType.this.visitEnd();
                }
            };
        }

        public void visitBaseType(char descriptor) {
            this.typeRead = BytecodeVisitor.this.symbols.getPrimitiveFromDescriptor(descriptor);
            this.visitEnd();
        }

        public void visitTypeVariable(String name) {
            List<Object> lookup = Lists.newArrayList();
            JavaSymbol currentSymbol = BytecodeVisitor.this.classSymbol;
            if (this.methodSymbol != null) {
                currentSymbol = this.methodSymbol;
            }
            while ((currentSymbol.isKind(2) || currentSymbol.isKind(16)) && lookup.isEmpty()) {
                if (currentSymbol.isKind(16)) {
                    lookup = ((JavaSymbol.MethodJavaSymbol)currentSymbol).typeParameters().lookup(name);
                } else if (currentSymbol.isKind(2)) {
                    lookup = ((JavaSymbol.TypeJavaSymbol)currentSymbol).typeParameters().lookup(name);
                }
                currentSymbol = currentSymbol.owner();
            }
            Preconditions.checkState((!lookup.isEmpty() ? 1 : 0) != 0, (String)"Could not resolve type parameter: %s in class %s", (Object[])new Object[]{name, BytecodeVisitor.this.classSymbol.getName()});
            Preconditions.checkState((lookup.size() == 1 ? 1 : 0) != 0, (Object)"More than one type parameter with the same name");
            this.typeRead = ((JavaSymbol)lookup.get((int)0)).type;
            this.visitEnd();
        }

        public void visitEnd() {
            if (!this.typeArguments.isEmpty()) {
                JavaSymbol.TypeJavaSymbol readSymbol = this.typeRead.symbol;
                readSymbol.complete();
                if (this.typeArguments.size() == readSymbol.typeVariableTypes.size()) {
                    TypeSubstitution substitution = new TypeSubstitution();
                    int i = 0;
                    for (JavaType typeArgument : this.typeArguments) {
                        substitution.add(readSymbol.typeVariableTypes.get(i), typeArgument);
                        ++i;
                    }
                    this.typeRead = BytecodeVisitor.this.parametrizedTypeCache.getParametrizedTypeType(readSymbol, substitution);
                }
            }
        }
    }

    private class ReadMethodSignature
    extends SignatureVisitor {
        private final JavaSymbol.MethodJavaSymbol methodSymbol;
        private int exceptionRead;
        JavaSymbol.TypeVariableJavaSymbol typeVariableSymbol;
        List<JavaType> bounds;

        public ReadMethodSignature(JavaSymbol.MethodJavaSymbol methodSymbol) {
            super(327680);
            this.exceptionRead = 0;
            this.methodSymbol = methodSymbol;
            ((MethodJavaType)methodSymbol.type).argTypes = Lists.newArrayList();
        }

        public void visitFormalTypeParameter(String name) {
            List<JavaSymbol> lookup = this.methodSymbol.typeParameters.lookup(name);
            int lookupSize = lookup.size();
            Preconditions.checkState((lookupSize == 1 ? 1 : 0) != 0, (String)"found %s instead of 1", (Object[])new Object[]{lookupSize});
            this.typeVariableSymbol = (JavaSymbol.TypeVariableJavaSymbol)lookup.iterator().next();
            this.bounds = ((TypeVariableJavaType)this.typeVariableSymbol.type).bounds;
        }

        public SignatureVisitor visitClassBound() {
            return new ReadType(this.methodSymbol){

                @Override
                public void visitEnd() {
                    super.visitEnd();
                    ReadMethodSignature.this.bounds.add(this.typeRead);
                }
            };
        }

        public SignatureVisitor visitInterfaceBound() {
            return new ReadType(this.methodSymbol){

                @Override
                public void visitEnd() {
                    super.visitEnd();
                    ReadMethodSignature.this.bounds.add(this.typeRead);
                }
            };
        }

        public SignatureVisitor visitParameterType() {
            return new ReadType(this.methodSymbol){

                @Override
                public void visitEnd() {
                    super.visitEnd();
                    ((MethodJavaType)((ReadMethodSignature)ReadMethodSignature.this).methodSymbol.type).argTypes.add(this.typeRead);
                }
            };
        }

        public SignatureVisitor visitReturnType() {
            return new ReadType(this.methodSymbol){

                @Override
                public void visitEnd() {
                    super.visitEnd();
                    ((MethodJavaType)((ReadMethodSignature)ReadMethodSignature.this).methodSymbol.type).resultType = this.typeRead;
                    ((ReadMethodSignature)ReadMethodSignature.this).methodSymbol.returnType = this.typeRead.symbol;
                }
            };
        }

        public SignatureVisitor visitExceptionType() {
            return new ReadType(this.methodSymbol){

                @Override
                public void visitEnd() {
                    super.visitEnd();
                    ((MethodJavaType)((ReadMethodSignature)ReadMethodSignature.this).methodSymbol.type).thrown.remove(ReadMethodSignature.this.exceptionRead);
                    ((MethodJavaType)((ReadMethodSignature)ReadMethodSignature.this).methodSymbol.type).thrown.add(ReadMethodSignature.this.exceptionRead, this.typeRead);
                    ReadMethodSignature.this.exceptionRead++;
                }
            };
        }

        public void visitEnd() {
            if (this.typeVariableSymbol != null) {
                if (this.bounds.isEmpty()) {
                    this.bounds.add(((BytecodeVisitor)BytecodeVisitor.this).symbols.objectType);
                }
                this.typeVariableSymbol = null;
                this.bounds = null;
            }
        }
    }

    private static class TypeParameterDeclaration
    extends SignatureVisitor {
        private final JavaSymbol symbol;

        public TypeParameterDeclaration(JavaSymbol symbol) {
            super(327680);
            this.symbol = symbol;
            if (symbol.isTypeSymbol()) {
                ((JavaSymbol.TypeJavaSymbol)symbol).typeParameters = new Scope(symbol);
            } else if (symbol.isMethodSymbol()) {
                ((JavaSymbol.MethodJavaSymbol)symbol).typeParameters = new Scope(symbol);
            }
        }

        public void visitFormalTypeParameter(String name) {
            JavaSymbol.TypeVariableJavaSymbol typeVariableSymbol = new JavaSymbol.TypeVariableJavaSymbol(name, this.symbol);
            ((TypeVariableJavaType)typeVariableSymbol.type).bounds = Lists.newArrayList();
            if (this.symbol.isTypeSymbol()) {
                JavaSymbol.TypeJavaSymbol typeJavaSymbol = (JavaSymbol.TypeJavaSymbol)this.symbol;
                typeJavaSymbol.typeParameters.enter(typeVariableSymbol);
                typeJavaSymbol.addTypeParameter((TypeVariableJavaType)typeVariableSymbol.type);
            } else if (this.symbol.isMethodSymbol()) {
                JavaSymbol.MethodJavaSymbol methodSymbol = (JavaSymbol.MethodJavaSymbol)this.symbol;
                methodSymbol.typeParameters.enter(typeVariableSymbol);
                methodSymbol.addTypeParameter((TypeVariableJavaType)typeVariableSymbol.type);
            }
        }
    }

    private class ReadGenericSignature
    extends SignatureVisitor {
        JavaSymbol.TypeVariableJavaSymbol typeVariableSymbol;
        List<JavaType> bounds;
        ImmutableList.Builder<JavaType> interfaces;

        public ReadGenericSignature() {
            super(327680);
            this.interfaces = ImmutableList.builder();
        }

        public void visitFormalTypeParameter(String name) {
            List<JavaSymbol> lookup = ((BytecodeVisitor)BytecodeVisitor.this).classSymbol.typeParameters.lookup(name);
            int lookupSize = lookup.size();
            Preconditions.checkState((lookupSize == 1 ? 1 : 0) != 0, (String)"found %s instead of 1", (Object[])new Object[]{lookupSize});
            this.typeVariableSymbol = (JavaSymbol.TypeVariableJavaSymbol)lookup.iterator().next();
            this.bounds = ((TypeVariableJavaType)this.typeVariableSymbol.type).bounds;
        }

        public SignatureVisitor visitSuperclass() {
            return new ReadType(){

                @Override
                public void visitEnd() {
                    super.visitEnd();
                    ((ClassJavaType)((BytecodeVisitor)BytecodeVisitor.this).classSymbol.type).supertype = this.typeRead;
                }
            };
        }

        public SignatureVisitor visitInterface() {
            return new ReadType(){

                @Override
                public void visitEnd() {
                    super.visitEnd();
                    ReadGenericSignature.this.interfaces.add((Object)this.typeRead);
                }
            };
        }

        public SignatureVisitor visitInterfaceBound() {
            return this.boundVisitor();
        }

        public SignatureVisitor visitClassBound() {
            return this.boundVisitor();
        }

        private ReadType boundVisitor() {
            return new ReadType(){

                @Override
                public void visitEnd() {
                    super.visitEnd();
                    if (ReadGenericSignature.this.bounds != null) {
                        ReadGenericSignature.this.bounds.add(this.typeRead);
                    }
                }
            };
        }

        public void visitClassType(String name) {
            if (this.bounds != null) {
                this.bounds.add(((BytecodeVisitor)BytecodeVisitor.this).getClassSymbol((String)name).type);
            }
        }

        public void visitEnd() {
            if (this.typeVariableSymbol != null) {
                if (this.bounds.isEmpty()) {
                    this.bounds.add(((BytecodeVisitor)BytecodeVisitor.this).symbols.objectType);
                }
                this.typeVariableSymbol = null;
                this.bounds = null;
            }
        }

        public List<JavaType> interfaces() {
            return this.interfaces.build();
        }
    }
}

