/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.bytecode.cfg;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Set;
import org.objectweb.asm.Type;
import org.objectweb.asm.util.Printer;

public class Instruction {
    private static final Set<Integer> LONG_DOUBLE_OPCODES = ImmutableSet.of((Object)97, (Object)101, (Object)105, (Object)109, (Object)127, (Object)129, (Object[])new Integer[]{131, 113, 121, 123, 125, 99, 103, 107, 111, 115, 14, 15, 9, 10, 47, 49, 119, 117});
    public final int opcode;
    public final Integer operand;
    public final String className;
    public final FieldOrMethod fieldOrMethod;

    @VisibleForTesting
    public Instruction(int opcode, int operand) {
        this.opcode = opcode;
        this.operand = operand;
        this.className = null;
        this.fieldOrMethod = null;
    }

    public Instruction(int opcode) {
        this.opcode = opcode;
        this.operand = null;
        this.className = null;
        this.fieldOrMethod = null;
    }

    public Instruction(int opcode, String className) {
        this.opcode = opcode;
        this.className = className;
        this.operand = null;
        this.fieldOrMethod = null;
    }

    public Instruction(int opcode, FieldOrMethod fieldOrMethod) {
        this.opcode = opcode;
        this.fieldOrMethod = fieldOrMethod;
        this.operand = null;
        this.className = null;
    }

    int opcode() {
        return this.opcode;
    }

    public int arity() {
        Preconditions.checkState((boolean)this.isInvoke(), (Object)"Not an INVOKE opcode");
        Type methodType = Type.getMethodType((String)this.fieldOrMethod.desc);
        return methodType.getArgumentTypes().length;
    }

    public boolean hasReturnValue() {
        Preconditions.checkState((boolean)this.isInvoke(), (Object)"Not an INVOKE opcode");
        return Type.getMethodType((String)this.fieldOrMethod.desc).getReturnType() != Type.VOID_TYPE;
    }

    @VisibleForTesting
    public boolean isInvoke() {
        return 182 <= this.opcode && this.opcode <= 186;
    }

    public boolean isLongOrDoubleValue() {
        if (LONG_DOUBLE_OPCODES.contains(this.opcode)) {
            return true;
        }
        if (this.opcode == 180 || this.opcode == 178) {
            return Type.getType((String)this.fieldOrMethod.desc).getSize() == 2;
        }
        if (this.isInvoke()) {
            return Type.getReturnType((String)this.fieldOrMethod.desc).getSize() == 2;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Instruction that = (Instruction)o;
        return this.opcode == that.opcode && Objects.equals(this.operand, that.operand) && Objects.equals(this.className, that.className) && Objects.equals(this.fieldOrMethod, that.fieldOrMethod);
    }

    public int hashCode() {
        return Objects.hash(this.opcode, this.operand, this.className, this.fieldOrMethod);
    }

    public String toString() {
        return Printer.OPCODES[this.opcode];
    }

    public static class LdcInsn
    extends Instruction {
        public final Object cst;

        public LdcInsn(Object cst) {
            super(18);
            this.cst = cst;
        }

        @Override
        public boolean isLongOrDoubleValue() {
            return this.cst instanceof Long || this.cst instanceof Double;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LdcInsn ldcInsn = (LdcInsn)o;
            return Objects.equals(this.cst, ldcInsn.cst);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.cst);
        }
    }

    public static class InvokeDynamicInsn
    extends Instruction {
        private final String desc;

        public InvokeDynamicInsn(String desc) {
            super(186);
            this.desc = desc;
        }

        @Override
        public int arity() {
            Type methodType = Type.getMethodType((String)this.desc);
            return methodType.getArgumentTypes().length;
        }

        @Override
        public boolean hasReturnValue() {
            return Type.getMethodType((String)this.desc).getReturnType() != Type.VOID_TYPE;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            InvokeDynamicInsn that = (InvokeDynamicInsn)o;
            return Objects.equals(this.desc, that.desc);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.desc);
        }
    }

    public static class MultiANewArrayInsn
    extends Instruction {
        public final int dim;

        public MultiANewArrayInsn(String className, int dim) {
            super(197, className);
            this.dim = dim;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            MultiANewArrayInsn that = (MultiANewArrayInsn)o;
            return this.dim == that.dim;
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.dim);
        }
    }

    public static class FieldOrMethod {
        public final String owner;
        public final String name;
        public final String desc;
        public final boolean ownerIsInterface;

        public FieldOrMethod(String owner, String name, String desc, boolean ownerIsInterface) {
            this.owner = owner;
            this.name = name;
            this.desc = desc;
            this.ownerIsInterface = ownerIsInterface;
        }

        public FieldOrMethod(String owner, String name, String desc) {
            this(owner, name, desc, false);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FieldOrMethod that = (FieldOrMethod)o;
            return this.ownerIsInterface == that.ownerIsInterface && Objects.equals(this.owner, that.owner) && Objects.equals(this.name, that.name) && Objects.equals(this.desc, that.desc);
        }

        public int hashCode() {
            return Objects.hash(this.owner, this.name, this.desc, this.ownerIsInterface);
        }

        public String completeSignature() {
            return Type.getObjectType((String)this.owner).getClassName() + "#" + this.name + this.desc;
        }
    }
}

