/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.resolve;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Closeables;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.sonar.java.bytecode.loader.SquidClassLoader;
import org.sonar.java.resolve.BytecodeVisitor;
import org.sonar.java.resolve.ClassJavaType;
import org.sonar.java.resolve.Convert;
import org.sonar.java.resolve.Flags;
import org.sonar.java.resolve.JavaSymbol;
import org.sonar.java.resolve.ParametrizedTypeCache;
import org.sonar.java.resolve.Resolve;
import org.sonar.java.resolve.Scope;
import org.sonar.java.resolve.Symbols;
import org.sonar.plugins.java.api.semantic.Symbol;

public class BytecodeCompleter
implements JavaSymbol.Completer {
    private Symbols symbols;
    private final ParametrizedTypeCache parametrizedTypeCache;
    private final SquidClassLoader classLoader;
    private final Map<String, JavaSymbol.TypeJavaSymbol> classes = new HashMap<String, JavaSymbol.TypeJavaSymbol>();
    private final Map<String, JavaSymbol.PackageJavaSymbol> packages = new HashMap<String, JavaSymbol.PackageJavaSymbol>();
    private final Map<JavaSymbol.TypeJavaSymbol, Map<String, Object>> constantValues = new HashMap<JavaSymbol.TypeJavaSymbol, Map<String, Object>>();
    private Set<String> classesNotFound = new TreeSet<String>();

    public BytecodeCompleter(SquidClassLoader classLoader, ParametrizedTypeCache parametrizedTypeCache) {
        this.classLoader = classLoader;
        this.parametrizedTypeCache = parametrizedTypeCache;
    }

    public void init(Symbols symbols) {
        this.symbols = symbols;
    }

    public JavaSymbol.TypeJavaSymbol registerClass(JavaSymbol.TypeJavaSymbol classSymbol) {
        String flatName = this.formFullName(classSymbol);
        Preconditions.checkState((!this.classes.containsKey(flatName) ? 1 : 0) != 0, (String)"Registering class 2 times : %s", (Object[])new Object[]{flatName});
        this.classes.put(flatName, classSymbol);
        return classSymbol;
    }

    @Override
    public void complete(JavaSymbol symbol) {
        String bytecodeName = this.formFullName(symbol);
        if (symbol.isPackageSymbol()) {
            bytecodeName = bytecodeName + ".package-info";
        }
        JavaSymbol.TypeJavaSymbol classSymbol = this.getClassSymbol(bytecodeName);
        if (symbol.isPackageSymbol()) {
            ((JavaSymbol.PackageJavaSymbol)symbol).packageInfo = classSymbol;
        }
        Preconditions.checkState((symbol.isPackageSymbol() || classSymbol == symbol ? 1 : 0) != 0);
        byte[] bytes = this.classLoader.getBytesForClass(bytecodeName);
        if (bytes != null) {
            ClassReader classReader = new ClassReader(bytes);
            classReader.accept((ClassVisitor)new BytecodeVisitor(this, this.symbols, classSymbol, this.parametrizedTypeCache), 7);
        }
    }

    @CheckForNull
    public Object constantValue(Symbol owner, String constantName) {
        JavaSymbol.TypeJavaSymbol typeSymbol;
        String bytecodeName;
        byte[] bytes;
        if (this.constantValues.containsKey(owner)) {
            return this.constantValues.get(owner).get(constantName);
        }
        if (owner.isTypeSymbol() && (bytes = this.classLoader.getBytesForClass(bytecodeName = (typeSymbol = (JavaSymbol.TypeJavaSymbol)owner).getFullyQualifiedName())) != null) {
            final HashMap valuesByFieldName = new HashMap();
            ClassReader classReader = new ClassReader(bytes);
            classReader.accept(new ClassVisitor(327680){

                public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
                    valuesByFieldName.put(name, value);
                    return super.visitField(access, name, descriptor, signature, value);
                }
            }, 7);
            this.constantValues.put(typeSymbol, valuesByFieldName);
            return valuesByFieldName.get(constantName);
        }
        return null;
    }

    @Nullable
    private InputStream inputStreamFor(String fullname) {
        return this.classLoader.getResourceAsStream(Convert.bytecodeName(fullname) + ".class");
    }

    private String formFullName(JavaSymbol symbol) {
        if (symbol.isTypeSymbol()) {
            return ((JavaSymbol.TypeJavaSymbol)symbol).getFullyQualifiedName();
        }
        return this.formFullName(symbol.name, symbol.owner);
    }

    String formFullName(String name, JavaSymbol site) {
        String result = name;
        for (JavaSymbol owner = site; owner != this.symbols.defaultPackage; owner = owner.owner()) {
            String separator = ".";
            if (owner.kind == 2) {
                separator = "$";
            }
            result = owner.name + separator + result;
        }
        return result;
    }

    @VisibleForTesting
    JavaSymbol.TypeJavaSymbol getClassSymbol(String bytecodeName) {
        return this.getClassSymbol(bytecodeName, 0);
    }

    JavaSymbol.TypeJavaSymbol getClassSymbol(String bytecodeName, int flags) {
        return this.getClassSymbol(null, bytecodeName, flags);
    }

    public JavaSymbol.TypeJavaSymbol getClassSymbol(@Nullable JavaSymbol.TypeJavaSymbol classSymbolOwner, String bytecodeName, int flags) {
        String flatName = Convert.flatName(bytecodeName);
        JavaSymbol.TypeJavaSymbol symbol = this.classes.get(flatName);
        if (symbol == null) {
            String shortName = Convert.shortName(flatName);
            String packageName = Convert.packagePart(flatName);
            JavaSymbol.TypeJavaSymbol owner = classSymbolOwner;
            if (owner == null) {
                owner = this.getEnclosingClass(shortName, packageName);
            }
            int classFlags = Flags.filterAccessBytecodeFlags(flags);
            if (owner != null) {
                String name = Convert.innerClassName(Convert.shortName(owner.getFullyQualifiedName()), shortName);
                symbol = new JavaSymbol.TypeJavaSymbol(classFlags, name, owner, bytecodeName);
            } else {
                symbol = new JavaSymbol.TypeJavaSymbol(classFlags, shortName, this.enterPackage(packageName));
            }
            symbol.members = new Scope(symbol);
            symbol.typeParameters = new Scope(symbol);
            if (this.classLoader.getResource(Convert.bytecodeName(flatName) + ".class") != null) {
                symbol.completer = this;
            } else {
                if (!bytecodeName.endsWith("package-info") && BytecodeCompleter.isNotAnnotation(flags)) {
                    this.classesNotFound.add(bytecodeName);
                }
                ((ClassJavaType)symbol.type).interfaces = ImmutableList.of();
                ((ClassJavaType)symbol.type).supertype = Symbols.unknownType;
            }
            this.classes.put(flatName, symbol);
        }
        return symbol;
    }

    private static boolean isNotAnnotation(int flags) {
        return (flags & 0x2000) == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private JavaSymbol.TypeJavaSymbol getEnclosingClass(String shortName, String packageName) {
        JavaSymbol.TypeJavaSymbol owner = null;
        String enclosingClassName = Convert.enclosingClassName(shortName);
        if (StringUtils.isNotEmpty((String)enclosingClassName)) {
            enclosingClassName = Convert.fullName(packageName, enclosingClassName);
            InputStream inputStream = null;
            try {
                inputStream = this.inputStreamFor(enclosingClassName);
                while (inputStream == null && enclosingClassName.endsWith("$")) {
                    enclosingClassName = enclosingClassName.substring(0, enclosingClassName.length() - 1);
                    inputStream = this.inputStreamFor(enclosingClassName);
                }
            }
            finally {
                Closeables.closeQuietly((InputStream)inputStream);
            }
            owner = this.getClassSymbol(enclosingClassName);
        }
        return owner;
    }

    public JavaSymbol loadClass(String fullname) {
        JavaSymbol.TypeJavaSymbol symbol = this.classes.get(fullname);
        if (symbol != null) {
            return symbol;
        }
        byte[] bytesForClass = this.classLoader.getBytesForClass(fullname);
        if (bytesForClass == null) {
            return new Resolve.JavaSymbolNotFound();
        }
        ClassReader classReader = new ClassReader(bytesForClass);
        String className = classReader.getClassName();
        if (!className.equals(Convert.bytecodeName(fullname))) {
            return new Resolve.JavaSymbolNotFound();
        }
        return this.getClassSymbol(fullname);
    }

    public JavaSymbol.PackageJavaSymbol enterPackage(String fullname) {
        if (StringUtils.isBlank((String)fullname)) {
            return this.symbols.defaultPackage;
        }
        return this.packages.computeIfAbsent(fullname, name -> {
            JavaSymbol.PackageJavaSymbol pck = new JavaSymbol.PackageJavaSymbol(fullname, this.symbols.defaultPackage);
            pck.completer = this;
            return pck;
        });
    }

    public Set<String> classesNotFound() {
        return this.classesNotFound;
    }
}

