/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.executor;

import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.NavigableSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.redisson.executor.CronExpression;

public class CronExpressionEx
extends CronExpression {
    private static final ThreadLocal<NavigableSet<Integer>> YEARS_FIELD = new ThreadLocal();
    private final NavigableSet<Integer> years = YEARS_FIELD.get();

    public CronExpressionEx(String expr) {
        super(CronExpressionEx.parseYear(expr));
        YEARS_FIELD.remove();
    }

    public CronExpressionEx(String expr, boolean withSeconds) {
        super(CronExpressionEx.parseYear(expr), withSeconds);
        YEARS_FIELD.remove();
    }

    @Override
    public ZonedDateTime nextTimeAfter(ZonedDateTime afterTime) {
        if (this.years != null) {
            afterTime = afterTime.withYear(this.years.ceiling(afterTime.getYear()));
        }
        return super.nextTimeAfter(afterTime);
    }

    private static String parseYear(String expr) {
        String[] parts = expr.split("\\s+");
        if (parts.length == 7) {
            String[] yearsRange;
            String year = parts[6];
            String[] years = year.split(",");
            if (years.length > 1) {
                TreeSet yy = new TreeSet(Arrays.stream(years).map(y -> Integer.valueOf(y)).collect(Collectors.toList()));
                YEARS_FIELD.set(yy);
            }
            if ((yearsRange = year.split("-")).length > 1) {
                TreeSet yy = new TreeSet(IntStream.rangeClosed(Integer.valueOf(yearsRange[0]), Integer.valueOf(yearsRange[1])).boxed().collect(Collectors.toList()));
                YEARS_FIELD.set(yy);
            }
            return expr.replace(year, "").trim();
        }
        return expr;
    }
}

