/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.runtime.kotlin.elements;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.dom.kotlin.KotlinFile;
import org.mybatis.generator.api.dom.kotlin.KotlinModifier;
import org.mybatis.generator.api.dom.kotlin.KotlinProperty;
import org.mybatis.generator.config.Context;
import org.mybatis.generator.runtime.kotlin.elements.AbstractKotlinFunctionGenerator;
import org.mybatis.generator.runtime.kotlin.elements.KotlinPropertyAndImports;

public class ColumnListGenerator {
    private final Context context;
    private final IntrospectedTable introspectedTable;
    private final String supportObjectImport;
    private final String tableFieldName;

    private ColumnListGenerator(Builder builder) {
        this.context = Objects.requireNonNull(builder.context);
        this.introspectedTable = Objects.requireNonNull(builder.introspectedTable);
        this.supportObjectImport = Objects.requireNonNull(builder.supportObjectImport);
        this.tableFieldName = Objects.requireNonNull(builder.tableFieldName);
    }

    public KotlinPropertyAndImports generatePropertyAndImports() {
        List<AbstractKotlinFunctionGenerator.FieldNameAndImport> fieldsAndImports = this.introspectedTable.getAllColumns().stream().map(this::calculateFieldAndImport).collect(Collectors.toList());
        KotlinPropertyAndImports propertyAndImports = KotlinPropertyAndImports.withProperty(((KotlinProperty.Builder)KotlinProperty.newVal("columnList").withModifier(KotlinModifier.PRIVATE)).withInitializationString(this.getInitializationString(fieldsAndImports)).build()).withImports(this.getImports(fieldsAndImports)).build();
        this.context.getCommentGenerator().addGeneralPropertyComment(propertyAndImports.getProperty(), this.introspectedTable, propertyAndImports.getImports());
        return propertyAndImports;
    }

    private AbstractKotlinFunctionGenerator.FieldNameAndImport calculateFieldAndImport(IntrospectedColumn column) {
        return AbstractKotlinFunctionGenerator.calculateFieldNameAndImport(this.tableFieldName, this.supportObjectImport, column);
    }

    private String getInitializationString(List<AbstractKotlinFunctionGenerator.FieldNameAndImport> fieldsAndImports) {
        return fieldsAndImports.stream().map(AbstractKotlinFunctionGenerator.FieldNameAndImport::fieldName).collect(Collectors.joining(", ", "listOf(", ")"));
    }

    private Set<String> getImports(List<AbstractKotlinFunctionGenerator.FieldNameAndImport> fieldsAndImports) {
        return fieldsAndImports.stream().map(AbstractKotlinFunctionGenerator.FieldNameAndImport::importString).collect(Collectors.toSet());
    }

    public boolean callPlugins(KotlinProperty kotlinProperty, KotlinFile kotlinFile) {
        return this.context.getPlugins().clientColumnListPropertyGenerated(kotlinProperty, kotlinFile, this.introspectedTable);
    }

    public static class Builder {
        private Context context;
        private IntrospectedTable introspectedTable;
        private String supportObjectImport;
        private String tableFieldName;

        public Builder withSupportObjectImport(String supportObjectImport) {
            this.supportObjectImport = supportObjectImport;
            return this;
        }

        public Builder withContext(Context context) {
            this.context = context;
            return this;
        }

        public Builder withIntrospectedTable(IntrospectedTable introspectedTable) {
            this.introspectedTable = introspectedTable;
            return this;
        }

        public Builder withTableFieldName(String tableFieldName) {
            this.tableFieldName = tableFieldName;
            return this;
        }

        public ColumnListGenerator build() {
            return new ColumnListGenerator(this);
        }
    }
}

