/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.runtime.kotlin.elements;

import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.dom.kotlin.KotlinArg;
import org.mybatis.generator.api.dom.kotlin.KotlinFile;
import org.mybatis.generator.api.dom.kotlin.KotlinFunction;
import org.mybatis.generator.config.Context;
import org.mybatis.generator.runtime.kotlin.elements.KotlinFunctionAndImports;
import org.mybatis.generator.runtime.kotlin.elements.KotlinFunctionParts;

public abstract class AbstractKotlinFunctionGenerator {
    protected final Context context;
    protected final IntrospectedTable introspectedTable;
    protected final String tableFieldName;

    protected AbstractKotlinFunctionGenerator(BaseBuilder<?> builder) {
        this.context = ((BaseBuilder)builder).context;
        this.introspectedTable = ((BaseBuilder)builder).introspectedTable;
        this.tableFieldName = ((BaseBuilder)builder).tableFieldName;
    }

    protected void acceptParts(KotlinFile kotlinFile, KotlinFunction kotlinFunction, KotlinFunctionParts functionParts) {
        for (KotlinArg argument : functionParts.getArguments()) {
            kotlinFunction.addArgument(argument);
        }
        for (String annotation : functionParts.getAnnotations()) {
            kotlinFunction.addAnnotation(annotation);
        }
        kotlinFunction.addCodeLines(functionParts.getCodeLines());
        kotlinFile.addImports(functionParts.getImports());
    }

    protected void acceptParts(KotlinFunctionAndImports functionAndImports, KotlinFunctionParts functionParts) {
        for (KotlinArg argument : functionParts.getArguments()) {
            functionAndImports.getFunction().addArgument(argument);
        }
        for (String annotation : functionParts.getAnnotations()) {
            functionAndImports.getFunction().addAnnotation(annotation);
        }
        functionAndImports.getFunction().addCodeLines(functionParts.getCodeLines());
        functionAndImports.getImports().addAll(functionParts.getImports());
    }

    protected void addFunctionComment(KotlinFunctionAndImports functionAndImports) {
        this.context.getCommentGenerator().addGeneralFunctionComment(functionAndImports.getFunction(), this.introspectedTable, functionAndImports.getImports());
    }

    public static FieldNameAndImport calculateFieldNameAndImport(String tableFieldName, String supportObjectImport, IntrospectedColumn column) {
        FieldNameAndImport answer = new FieldNameAndImport();
        answer.fieldName = column.getJavaProperty();
        if (answer.fieldName.equals(tableFieldName)) {
            answer.fieldName = tableFieldName + "." + answer.fieldName;
            answer.importString = supportObjectImport + "." + tableFieldName;
        } else {
            answer.importString = supportObjectImport + "." + answer.fieldName;
        }
        return answer;
    }

    public abstract KotlinFunctionAndImports generateMethodAndImports();

    public abstract boolean callPlugins(KotlinFunction var1, KotlinFile var2);

    public static abstract class BaseBuilder<T extends BaseBuilder<T>> {
        private Context context;
        private IntrospectedTable introspectedTable;
        private String tableFieldName;

        public T withContext(Context context) {
            this.context = context;
            return this.getThis();
        }

        public T withTableFieldName(String tableFieldName) {
            this.tableFieldName = tableFieldName;
            return this.getThis();
        }

        public T withIntrospectedTable(IntrospectedTable introspectedTable) {
            this.introspectedTable = introspectedTable;
            return this.getThis();
        }

        public abstract T getThis();
    }

    public static class FieldNameAndImport {
        private String fieldName;
        private String importString;

        public String fieldName() {
            return this.fieldName;
        }

        public String importString() {
            return this.importString;
        }
    }
}

