/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.runtime.dynamic.sql;

import java.util.List;
import org.mybatis.generator.api.CommentGenerator;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.dom.java.Field;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.InnerClass;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.codegen.mybatis3.MyBatis3FormattingUtilities;
import org.mybatis.generator.internal.util.JavaBeansUtil;
import org.mybatis.generator.internal.util.StringUtility;
import org.mybatis.generator.internal.util.messages.Messages;

public class DynamicSqlSupportClassGenerator {
    private IntrospectedTable introspectedTable;
    private CommentGenerator commentGenerator;
    private List<String> warnings;

    private DynamicSqlSupportClassGenerator() {
    }

    public TopLevelClass generate() {
        TopLevelClass topLevelClass = this.buildBasicClass();
        Field tableField = this.calculateTableDefinition(topLevelClass);
        topLevelClass.addImportedType(tableField.getType());
        topLevelClass.addField(tableField);
        InnerClass innerClass = this.buildInnerTableClass(topLevelClass);
        topLevelClass.addInnerClass(innerClass);
        List<IntrospectedColumn> columns = this.introspectedTable.getAllColumns();
        for (IntrospectedColumn column : columns) {
            this.handleColumn(topLevelClass, innerClass, column, tableField.getName());
        }
        return topLevelClass;
    }

    private TopLevelClass buildBasicClass() {
        TopLevelClass topLevelClass = new TopLevelClass(this.introspectedTable.getMyBatisDynamicSqlSupportType());
        topLevelClass.setVisibility(JavaVisibility.PUBLIC);
        topLevelClass.setFinal(true);
        topLevelClass.addImportedType(new FullyQualifiedJavaType("org.mybatis.dynamic.sql.SqlColumn"));
        topLevelClass.addImportedType(new FullyQualifiedJavaType("org.mybatis.dynamic.sql.AliasableSqlTable"));
        topLevelClass.addImportedType(new FullyQualifiedJavaType("java.sql.JDBCType"));
        return topLevelClass;
    }

    private InnerClass buildInnerTableClass(TopLevelClass topLevelClass) {
        FullyQualifiedJavaType fqjt = new FullyQualifiedJavaType(this.introspectedTable.getMyBatisDynamicSQLTableObjectName());
        InnerClass innerClass = new InnerClass(fqjt.getShortName());
        innerClass.setVisibility(JavaVisibility.PUBLIC);
        innerClass.setStatic(true);
        innerClass.setFinal(true);
        innerClass.setSuperClass(new FullyQualifiedJavaType("org.mybatis.dynamic.sql.AliasableSqlTable<" + fqjt.getShortName() + ">"));
        Method method = new Method(fqjt.getShortName());
        method.setVisibility(JavaVisibility.PUBLIC);
        method.setConstructor(true);
        method.addBodyLine("super(\"" + StringUtility.escapeStringForJava(this.introspectedTable.getFullyQualifiedTableNameAtRuntime()) + "\", " + fqjt.getShortName() + "::new);");
        innerClass.addMethod(method);
        this.commentGenerator.addClassAnnotation(innerClass, this.introspectedTable, topLevelClass.getImportedTypes());
        return innerClass;
    }

    private Field calculateTableDefinition(TopLevelClass topLevelClass) {
        FullyQualifiedJavaType fqjt = new FullyQualifiedJavaType(this.introspectedTable.getMyBatisDynamicSQLTableObjectName());
        String fieldName = JavaBeansUtil.getValidPropertyName(this.introspectedTable.getMyBatisDynamicSQLTableObjectName());
        Field field = new Field(fieldName, fqjt);
        this.commentGenerator.addFieldAnnotation(field, this.introspectedTable, topLevelClass.getImportedTypes());
        field.setVisibility(JavaVisibility.PUBLIC);
        field.setStatic(true);
        field.setFinal(true);
        String initializationString = String.format("new %s()", StringUtility.escapeStringForJava(this.introspectedTable.getMyBatisDynamicSQLTableObjectName()));
        field.setInitializationString(initializationString);
        return field;
    }

    private void handleColumn(TopLevelClass topLevelClass, InnerClass innerClass, IntrospectedColumn column, String tableFieldName) {
        Field field;
        topLevelClass.addImportedType(column.getFullyQualifiedJavaType());
        FullyQualifiedJavaType javaType = column.getFullyQualifiedJavaType().isPrimitive() ? column.getFullyQualifiedJavaType().getPrimitiveTypeWrapper() : column.getFullyQualifiedJavaType();
        FullyQualifiedJavaType fieldType = this.calculateFieldType(javaType);
        String fieldName = column.getJavaProperty();
        if (fieldName.equals(tableFieldName)) {
            this.warnings.add(Messages.getString("Warning.29", fieldName, topLevelClass.getType().getFullyQualifiedName()));
        } else {
            field = new Field(fieldName, fieldType);
            field.setVisibility(JavaVisibility.PUBLIC);
            field.setStatic(true);
            field.setFinal(true);
            field.setInitializationString(tableFieldName + "." + fieldName);
            this.commentGenerator.addFieldAnnotation(field, this.introspectedTable, column, topLevelClass.getImportedTypes());
            topLevelClass.addField(field);
        }
        field = new Field(fieldName, fieldType);
        field.setVisibility(JavaVisibility.PUBLIC);
        field.setFinal(true);
        field.setInitializationString(this.calculateInnerInitializationString(column, javaType));
        innerClass.addField(field);
    }

    private FullyQualifiedJavaType calculateFieldType(FullyQualifiedJavaType javaType) {
        return new FullyQualifiedJavaType(String.format("SqlColumn<%s>", javaType.getShortName()));
    }

    private String calculateInnerInitializationString(IntrospectedColumn column, FullyQualifiedJavaType javaType) {
        StringBuilder initializationString = new StringBuilder();
        initializationString.append(String.format("column(\"%s\", JDBCType.%s", StringUtility.escapeStringForJava(MyBatis3FormattingUtilities.getEscapedColumnName(column)), column.getJdbcTypeName()));
        if (StringUtility.stringHasValue(column.getTypeHandler())) {
            initializationString.append(String.format(", \"%s\")", column.getTypeHandler()));
        } else {
            initializationString.append(')');
        }
        if (StringUtility.isTrue(column.getProperties().getProperty("forceJavaTypeIntoMapping"))) {
            initializationString.append(".withJavaType(");
            initializationString.append(javaType.getShortName());
            initializationString.append(".class)");
        }
        return initializationString.toString();
    }

    public static DynamicSqlSupportClassGenerator of(IntrospectedTable introspectedTable, CommentGenerator commentGenerator, List<String> warnings) {
        DynamicSqlSupportClassGenerator generator = new DynamicSqlSupportClassGenerator();
        generator.introspectedTable = introspectedTable;
        generator.commentGenerator = commentGenerator;
        generator.warnings = warnings;
        return generator;
    }
}

