/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.internal.rules;

import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.codegen.mybatis3.ListUtilities;
import org.mybatis.generator.config.TableConfiguration;
import org.mybatis.generator.internal.rules.Rules;
import org.mybatis.generator.internal.util.StringUtility;

public abstract class BaseRules
implements Rules {
    protected final TableConfiguration tableConfiguration;
    protected final IntrospectedTable introspectedTable;
    protected final boolean isModelOnly;

    protected BaseRules(IntrospectedTable introspectedTable) {
        this.introspectedTable = introspectedTable;
        this.tableConfiguration = introspectedTable.getTableConfiguration();
        String modelOnly = this.tableConfiguration.getProperty("modelOnly");
        this.isModelOnly = StringUtility.isTrue(modelOnly);
    }

    @Override
    public boolean generateInsert() {
        if (this.isModelOnly) {
            return false;
        }
        return this.tableConfiguration.isInsertStatementEnabled();
    }

    @Override
    public boolean generateInsertSelective() {
        return this.generateInsert();
    }

    @Override
    public FullyQualifiedJavaType calculateAllFieldsClass() {
        String answer = this.generateRecordWithBLOBsClass() ? this.introspectedTable.getRecordWithBLOBsType() : (this.generateBaseRecordClass() ? this.introspectedTable.getBaseRecordType() : this.introspectedTable.getPrimaryKeyType());
        return new FullyQualifiedJavaType(answer);
    }

    @Override
    public boolean generateUpdateByPrimaryKeyWithoutBLOBs() {
        if (this.isModelOnly) {
            return false;
        }
        if (ListUtilities.removeGeneratedAlwaysColumns(this.introspectedTable.getBaseColumns()).isEmpty()) {
            return false;
        }
        return this.tableConfiguration.isUpdateByPrimaryKeyStatementEnabled() && this.introspectedTable.hasPrimaryKeyColumns() && this.introspectedTable.hasBaseColumns();
    }

    @Override
    public boolean generateUpdateByPrimaryKeyWithBLOBs() {
        if (this.isModelOnly) {
            return false;
        }
        if (ListUtilities.removeGeneratedAlwaysColumns(this.introspectedTable.getNonPrimaryKeyColumns()).isEmpty()) {
            return false;
        }
        return this.tableConfiguration.isUpdateByPrimaryKeyStatementEnabled() && this.introspectedTable.hasPrimaryKeyColumns() && this.introspectedTable.hasBLOBColumns();
    }

    @Override
    public boolean generateUpdateByPrimaryKeySelective() {
        if (this.isModelOnly) {
            return false;
        }
        if (ListUtilities.removeGeneratedAlwaysColumns(this.introspectedTable.getNonPrimaryKeyColumns()).isEmpty()) {
            return false;
        }
        return this.tableConfiguration.isUpdateByPrimaryKeyStatementEnabled() && this.introspectedTable.hasPrimaryKeyColumns() && (this.introspectedTable.hasBLOBColumns() || this.introspectedTable.hasBaseColumns());
    }

    @Override
    public boolean generateDeleteByPrimaryKey() {
        if (this.isModelOnly) {
            return false;
        }
        return this.tableConfiguration.isDeleteByPrimaryKeyStatementEnabled() && this.introspectedTable.hasPrimaryKeyColumns();
    }

    @Override
    public boolean generateDeleteByExample() {
        if (this.isModelOnly) {
            return false;
        }
        return this.tableConfiguration.isDeleteByExampleStatementEnabled();
    }

    @Override
    public boolean generateBaseResultMap() {
        if (this.isModelOnly) {
            return true;
        }
        return this.tableConfiguration.isSelectByExampleStatementEnabled() || this.tableConfiguration.isSelectByPrimaryKeyStatementEnabled();
    }

    @Override
    public boolean generateResultMapWithBLOBs() {
        boolean rc = this.introspectedTable.hasBLOBColumns() ? (this.isModelOnly ? true : this.tableConfiguration.isSelectByExampleStatementEnabled() || this.tableConfiguration.isSelectByPrimaryKeyStatementEnabled()) : false;
        return rc;
    }

    @Override
    public boolean generateSQLExampleWhereClause() {
        if (this.isModelOnly) {
            return false;
        }
        return this.tableConfiguration.isSelectByExampleStatementEnabled() || this.tableConfiguration.isDeleteByExampleStatementEnabled() || this.tableConfiguration.isCountByExampleStatementEnabled();
    }

    @Override
    public boolean generateMyBatis3UpdateByExampleWhereClause() {
        if (this.isModelOnly) {
            return false;
        }
        return this.introspectedTable.getTargetRuntime() == IntrospectedTable.TargetRuntime.MYBATIS3 && this.tableConfiguration.isUpdateByExampleStatementEnabled();
    }

    @Override
    public boolean generateSelectByPrimaryKey() {
        if (this.isModelOnly) {
            return false;
        }
        return this.tableConfiguration.isSelectByPrimaryKeyStatementEnabled() && this.introspectedTable.hasPrimaryKeyColumns() && (this.introspectedTable.hasBaseColumns() || this.introspectedTable.hasBLOBColumns());
    }

    @Override
    public boolean generateSelectByExampleWithoutBLOBs() {
        if (this.isModelOnly) {
            return false;
        }
        return this.tableConfiguration.isSelectByExampleStatementEnabled();
    }

    @Override
    public boolean generateSelectByExampleWithBLOBs() {
        if (this.isModelOnly) {
            return false;
        }
        return this.tableConfiguration.isSelectByExampleStatementEnabled() && this.introspectedTable.hasBLOBColumns();
    }

    @Override
    public boolean generateExampleClass() {
        if (this.introspectedTable.getContext().getSqlMapGeneratorConfiguration() == null && this.introspectedTable.getContext().getJavaClientGeneratorConfiguration() == null) {
            return false;
        }
        if (this.isModelOnly) {
            return false;
        }
        return this.tableConfiguration.isSelectByExampleStatementEnabled() || this.tableConfiguration.isDeleteByExampleStatementEnabled() || this.tableConfiguration.isCountByExampleStatementEnabled() || this.tableConfiguration.isUpdateByExampleStatementEnabled();
    }

    @Override
    public boolean generateCountByExample() {
        if (this.isModelOnly) {
            return false;
        }
        return this.tableConfiguration.isCountByExampleStatementEnabled();
    }

    @Override
    public boolean generateUpdateByExampleSelective() {
        if (this.isModelOnly) {
            return false;
        }
        return this.tableConfiguration.isUpdateByExampleStatementEnabled();
    }

    @Override
    public boolean generateUpdateByExampleWithoutBLOBs() {
        if (this.isModelOnly) {
            return false;
        }
        return this.tableConfiguration.isUpdateByExampleStatementEnabled() && (this.introspectedTable.hasPrimaryKeyColumns() || this.introspectedTable.hasBaseColumns());
    }

    @Override
    public boolean generateUpdateByExampleWithBLOBs() {
        if (this.isModelOnly) {
            return false;
        }
        return this.tableConfiguration.isUpdateByExampleStatementEnabled() && this.introspectedTable.hasBLOBColumns();
    }

    @Override
    public IntrospectedTable getIntrospectedTable() {
        return this.introspectedTable;
    }

    @Override
    public boolean generateBaseColumnList() {
        if (this.isModelOnly) {
            return false;
        }
        return this.generateSelectByPrimaryKey() || this.generateSelectByExampleWithoutBLOBs();
    }

    @Override
    public boolean generateBlobColumnList() {
        if (this.isModelOnly) {
            return false;
        }
        return this.introspectedTable.hasBLOBColumns() && (this.tableConfiguration.isSelectByExampleStatementEnabled() || this.tableConfiguration.isSelectByPrimaryKeyStatementEnabled());
    }

    @Override
    public boolean generateJavaClient() {
        return !this.isModelOnly;
    }
}

