/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.api.dom.java;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.JavaElement;
import org.mybatis.generator.api.dom.java.Parameter;
import org.mybatis.generator.api.dom.java.TypeParameter;

public class Method
extends JavaElement {
    private final List<String> bodyLines = new ArrayList<String>();
    private boolean constructor;
    private FullyQualifiedJavaType returnType;
    private String name;
    private final List<TypeParameter> typeParameters = new ArrayList<TypeParameter>();
    private final List<Parameter> parameters = new ArrayList<Parameter>();
    private final List<FullyQualifiedJavaType> exceptions = new ArrayList<FullyQualifiedJavaType>();
    private boolean isSynchronized;
    private boolean isNative;
    private boolean isDefault;
    private boolean isAbstract;
    private boolean isFinal;

    public Method(String name) {
        this.name = name;
    }

    public Method(Method original) {
        super(original);
        this.bodyLines.addAll(original.bodyLines);
        this.constructor = original.constructor;
        this.exceptions.addAll(original.exceptions);
        this.name = original.name;
        this.typeParameters.addAll(original.typeParameters);
        this.parameters.addAll(original.parameters);
        this.returnType = original.returnType;
        this.isNative = original.isNative;
        this.isSynchronized = original.isSynchronized;
        this.isDefault = original.isDefault;
        this.isAbstract = original.isAbstract;
        this.isFinal = original.isFinal;
    }

    public List<String> getBodyLines() {
        return this.bodyLines;
    }

    public void addBodyLine(String line) {
        this.bodyLines.add(line);
    }

    public void addBodyLine(int index, String line) {
        this.bodyLines.add(index, line);
    }

    public void addBodyLines(Collection<String> lines) {
        this.bodyLines.addAll(lines);
    }

    public void addBodyLines(int index, Collection<String> lines) {
        this.bodyLines.addAll(index, lines);
    }

    public boolean isConstructor() {
        return this.constructor;
    }

    public void setConstructor(boolean constructor) {
        this.constructor = constructor;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<TypeParameter> getTypeParameters() {
        return this.typeParameters;
    }

    public void addTypeParameter(TypeParameter typeParameter) {
        this.typeParameters.add(typeParameter);
    }

    public void addTypeParameter(int index, TypeParameter typeParameter) {
        this.typeParameters.add(index, typeParameter);
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public void addParameter(Parameter parameter) {
        this.parameters.add(parameter);
    }

    public void addParameter(int index, Parameter parameter) {
        this.parameters.add(index, parameter);
    }

    public Optional<FullyQualifiedJavaType> getReturnType() {
        return Optional.ofNullable(this.returnType);
    }

    public void setReturnType(FullyQualifiedJavaType returnType) {
        this.returnType = returnType;
    }

    public List<FullyQualifiedJavaType> getExceptions() {
        return this.exceptions;
    }

    public void addException(FullyQualifiedJavaType exception) {
        this.exceptions.add(exception);
    }

    public boolean isSynchronized() {
        return this.isSynchronized;
    }

    public void setSynchronized(boolean isSynchronized) {
        this.isSynchronized = isSynchronized;
    }

    public boolean isNative() {
        return this.isNative;
    }

    public void setNative(boolean isNative) {
        this.isNative = isNative;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public void setDefault(boolean isDefault) {
        this.isDefault = isDefault;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public void setAbstract(boolean isAbstract) {
        this.isAbstract = isAbstract;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public void setFinal(boolean isFinal) {
        this.isFinal = isFinal;
    }
}

