/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.api;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mybatis.generator.api.FullyQualifiedTable;
import org.mybatis.generator.api.GeneratedJavaFile;
import org.mybatis.generator.api.GeneratedKotlinFile;
import org.mybatis.generator.api.GeneratedXmlFile;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.ProgressCallback;
import org.mybatis.generator.config.Context;
import org.mybatis.generator.config.GeneratedKey;
import org.mybatis.generator.config.JavaClientGeneratorConfiguration;
import org.mybatis.generator.config.JavaModelGeneratorConfiguration;
import org.mybatis.generator.config.ModelType;
import org.mybatis.generator.config.PropertyHolder;
import org.mybatis.generator.config.SqlMapGeneratorConfiguration;
import org.mybatis.generator.config.TableConfiguration;
import org.mybatis.generator.internal.rules.ConditionalModelRules;
import org.mybatis.generator.internal.rules.FlatModelRules;
import org.mybatis.generator.internal.rules.HierarchicalModelRules;
import org.mybatis.generator.internal.rules.Rules;
import org.mybatis.generator.internal.util.StringUtility;

public abstract class IntrospectedTable {
    protected TableConfiguration tableConfiguration;
    protected FullyQualifiedTable fullyQualifiedTable;
    protected Context context;
    protected Rules rules;
    protected final List<IntrospectedColumn> primaryKeyColumns = new ArrayList<IntrospectedColumn>();
    protected final List<IntrospectedColumn> baseColumns = new ArrayList<IntrospectedColumn>();
    protected final List<IntrospectedColumn> blobColumns = new ArrayList<IntrospectedColumn>();
    protected TargetRuntime targetRuntime;
    protected final Map<String, Object> attributes = new HashMap<String, Object>();
    protected final Map<InternalAttribute, String> internalAttributes = new EnumMap<InternalAttribute, String>(InternalAttribute.class);
    protected String remarks;
    protected String tableType;

    protected IntrospectedTable(TargetRuntime targetRuntime) {
        this.targetRuntime = targetRuntime;
    }

    public FullyQualifiedTable getFullyQualifiedTable() {
        return this.fullyQualifiedTable;
    }

    public String getSelectByExampleQueryId() {
        return this.tableConfiguration.getSelectByExampleQueryId();
    }

    public String getSelectByPrimaryKeyQueryId() {
        return this.tableConfiguration.getSelectByPrimaryKeyQueryId();
    }

    public Optional<GeneratedKey> getGeneratedKey() {
        return this.tableConfiguration.getGeneratedKey();
    }

    public Optional<IntrospectedColumn> getColumn(String columnName) {
        return Stream.of(this.primaryKeyColumns.stream(), this.baseColumns.stream(), this.blobColumns.stream()).flatMap(Function.identity()).filter(ic -> this.columnMatches((IntrospectedColumn)ic, columnName)).findFirst();
    }

    private boolean columnMatches(IntrospectedColumn introspectedColumn, String columnName) {
        if (introspectedColumn.isColumnNameDelimited()) {
            return introspectedColumn.getActualColumnName().equals(columnName);
        }
        return introspectedColumn.getActualColumnName().equalsIgnoreCase(columnName);
    }

    public boolean hasJDBCDateColumns() {
        return Stream.of(this.primaryKeyColumns.stream(), this.baseColumns.stream()).flatMap(Function.identity()).anyMatch(IntrospectedColumn::isJDBCDateColumn);
    }

    public boolean hasJDBCTimeColumns() {
        return Stream.of(this.primaryKeyColumns.stream(), this.baseColumns.stream()).flatMap(Function.identity()).anyMatch(IntrospectedColumn::isJDBCTimeColumn);
    }

    public List<IntrospectedColumn> getPrimaryKeyColumns() {
        return this.primaryKeyColumns;
    }

    public boolean hasPrimaryKeyColumns() {
        return !this.primaryKeyColumns.isEmpty();
    }

    public List<IntrospectedColumn> getBaseColumns() {
        return this.baseColumns;
    }

    public List<IntrospectedColumn> getAllColumns() {
        return Stream.of(this.primaryKeyColumns.stream(), this.baseColumns.stream(), this.blobColumns.stream()).flatMap(Function.identity()).collect(Collectors.toList());
    }

    public List<IntrospectedColumn> getNonBLOBColumns() {
        return Stream.of(this.primaryKeyColumns.stream(), this.baseColumns.stream()).flatMap(Function.identity()).collect(Collectors.toList());
    }

    public int getNonBLOBColumnCount() {
        return this.primaryKeyColumns.size() + this.baseColumns.size();
    }

    public List<IntrospectedColumn> getNonPrimaryKeyColumns() {
        return Stream.of(this.baseColumns.stream(), this.blobColumns.stream()).flatMap(Function.identity()).collect(Collectors.toList());
    }

    public List<IntrospectedColumn> getBLOBColumns() {
        return this.blobColumns;
    }

    public boolean hasBLOBColumns() {
        return !this.blobColumns.isEmpty();
    }

    public boolean hasBaseColumns() {
        return !this.baseColumns.isEmpty();
    }

    public Rules getRules() {
        return this.rules;
    }

    public String getTableConfigurationProperty(String property) {
        return this.tableConfiguration.getProperty(property);
    }

    public String getPrimaryKeyType() {
        return this.internalAttributes.get((Object)InternalAttribute.ATTR_PRIMARY_KEY_TYPE);
    }

    public String getBaseRecordType() {
        return this.internalAttributes.get((Object)InternalAttribute.ATTR_BASE_RECORD_TYPE);
    }

    public String getKotlinRecordType() {
        return this.internalAttributes.get((Object)InternalAttribute.ATTR_KOTLIN_RECORD_TYPE);
    }

    public String getExampleType() {
        return this.internalAttributes.get((Object)InternalAttribute.ATTR_EXAMPLE_TYPE);
    }

    public String getRecordWithBLOBsType() {
        return this.internalAttributes.get((Object)InternalAttribute.ATTR_RECORD_WITH_BLOBS_TYPE);
    }

    public String getMyBatis3SqlMapNamespace() {
        String namespace = this.getMyBatis3JavaMapperType();
        if (namespace == null) {
            namespace = this.getMyBatis3FallbackSqlMapNamespace();
        }
        return namespace;
    }

    public String getMyBatis3FallbackSqlMapNamespace() {
        return this.internalAttributes.get((Object)InternalAttribute.ATTR_MYBATIS3_FALLBACK_SQL_MAP_NAMESPACE);
    }

    public boolean hasAnyColumns() {
        return this.hasPrimaryKeyColumns() || this.hasBaseColumns() || this.hasBLOBColumns();
    }

    public void setTableConfiguration(TableConfiguration tableConfiguration) {
        this.tableConfiguration = tableConfiguration;
    }

    public void setFullyQualifiedTable(FullyQualifiedTable fullyQualifiedTable) {
        this.fullyQualifiedTable = fullyQualifiedTable;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public void addColumn(IntrospectedColumn introspectedColumn) {
        if (introspectedColumn.isBLOBColumn()) {
            this.blobColumns.add(introspectedColumn);
        } else {
            this.baseColumns.add(introspectedColumn);
        }
        introspectedColumn.setIntrospectedTable(this);
    }

    public void addPrimaryKeyColumn(String columnName) {
        IntrospectedColumn introspectedColumn;
        boolean found = false;
        Iterator<IntrospectedColumn> iter = this.baseColumns.iterator();
        while (iter.hasNext()) {
            introspectedColumn = iter.next();
            if (!introspectedColumn.getActualColumnName().equals(columnName)) continue;
            this.primaryKeyColumns.add(introspectedColumn);
            iter.remove();
            found = true;
            break;
        }
        if (!found) {
            iter = this.blobColumns.iterator();
            while (iter.hasNext()) {
                introspectedColumn = iter.next();
                if (!introspectedColumn.getActualColumnName().equals(columnName)) continue;
                this.primaryKeyColumns.add(introspectedColumn);
                iter.remove();
                break;
            }
        }
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public void initialize() {
        this.calculateJavaClientAttributes();
        this.calculateModelAttributes();
        this.calculateXmlAttributes();
        this.rules = this.tableConfiguration.getModelType() == ModelType.HIERARCHICAL ? new HierarchicalModelRules(this) : (this.tableConfiguration.getModelType() == ModelType.FLAT ? new FlatModelRules(this) : new ConditionalModelRules(this));
        this.context.getPlugins().initialized(this);
    }

    protected void calculateXmlAttributes() {
        this.setMyBatis3XmlMapperFileName(this.calculateMyBatis3XmlMapperFileName());
        this.setMyBatis3XmlMapperPackage(this.calculateSqlMapPackage());
        this.setMyBatis3FallbackSqlMapNamespace(this.calculateMyBatis3FallbackSqlMapNamespace());
        this.setSqlMapFullyQualifiedRuntimeTableName(this.calculateSqlMapFullyQualifiedRuntimeTableName());
        this.setSqlMapAliasedFullyQualifiedRuntimeTableName(this.calculateSqlMapAliasedFullyQualifiedRuntimeTableName());
        this.setCountByExampleStatementId("countByExample");
        this.setDeleteByExampleStatementId("deleteByExample");
        this.setDeleteByPrimaryKeyStatementId("deleteByPrimaryKey");
        this.setInsertStatementId("insert");
        this.setInsertSelectiveStatementId("insertSelective");
        this.setSelectAllStatementId("selectAll");
        this.setSelectByExampleStatementId("selectByExample");
        this.setSelectByExampleWithBLOBsStatementId("selectByExampleWithBLOBs");
        this.setSelectByPrimaryKeyStatementId("selectByPrimaryKey");
        this.setUpdateByExampleStatementId("updateByExample");
        this.setUpdateByExampleSelectiveStatementId("updateByExampleSelective");
        this.setUpdateByExampleWithBLOBsStatementId("updateByExampleWithBLOBs");
        this.setUpdateByPrimaryKeyStatementId("updateByPrimaryKey");
        this.setUpdateByPrimaryKeySelectiveStatementId("updateByPrimaryKeySelective");
        this.setUpdateByPrimaryKeyWithBLOBsStatementId("updateByPrimaryKeyWithBLOBs");
        this.setBaseResultMapId("BaseResultMap");
        this.setResultMapWithBLOBsId("ResultMapWithBLOBs");
        this.setExampleWhereClauseId("Example_Where_Clause");
        this.setBaseColumnListId("Base_Column_List");
        this.setBlobColumnListId("Blob_Column_List");
        this.setMyBatis3UpdateByExampleWhereClauseId("Update_By_Example_Where_Clause");
    }

    public void setBlobColumnListId(String s) {
        this.internalAttributes.put(InternalAttribute.ATTR_BLOB_COLUMN_LIST_ID, s);
    }

    public void setBaseColumnListId(String s) {
        this.internalAttributes.put(InternalAttribute.ATTR_BASE_COLUMN_LIST_ID, s);
    }

    public void setExampleWhereClauseId(String s) {
        this.internalAttributes.put(InternalAttribute.ATTR_EXAMPLE_WHERE_CLAUSE_ID, s);
    }

    public void setMyBatis3UpdateByExampleWhereClauseId(String s) {
        this.internalAttributes.put(InternalAttribute.ATTR_MYBATIS3_UPDATE_BY_EXAMPLE_WHERE_CLAUSE_ID, s);
    }

    public void setResultMapWithBLOBsId(String s) {
        this.internalAttributes.put(InternalAttribute.ATTR_RESULT_MAP_WITH_BLOBS_ID, s);
    }

    public void setBaseResultMapId(String s) {
        this.internalAttributes.put(InternalAttribute.ATTR_BASE_RESULT_MAP_ID, s);
    }

    public void setUpdateByPrimaryKeyWithBLOBsStatementId(String s) {
        this.internalAttributes.put(InternalAttribute.ATTR_UPDATE_BY_PRIMARY_KEY_WITH_BLOBS_STATEMENT_ID, s);
    }

    public void setUpdateByPrimaryKeySelectiveStatementId(String s) {
        this.internalAttributes.put(InternalAttribute.ATTR_UPDATE_BY_PRIMARY_KEY_SELECTIVE_STATEMENT_ID, s);
    }

    public void setUpdateByPrimaryKeyStatementId(String s) {
        this.internalAttributes.put(InternalAttribute.ATTR_UPDATE_BY_PRIMARY_KEY_STATEMENT_ID, s);
    }

    public void setUpdateByExampleWithBLOBsStatementId(String s) {
        this.internalAttributes.put(InternalAttribute.ATTR_UPDATE_BY_EXAMPLE_WITH_BLOBS_STATEMENT_ID, s);
    }

    public void setUpdateByExampleSelectiveStatementId(String s) {
        this.internalAttributes.put(InternalAttribute.ATTR_UPDATE_BY_EXAMPLE_SELECTIVE_STATEMENT_ID, s);
    }

    public void setUpdateByExampleStatementId(String s) {
        this.internalAttributes.put(InternalAttribute.ATTR_UPDATE_BY_EXAMPLE_STATEMENT_ID, s);
    }

    public void setSelectByPrimaryKeyStatementId(String s) {
        this.internalAttributes.put(InternalAttribute.ATTR_SELECT_BY_PRIMARY_KEY_STATEMENT_ID, s);
    }

    public void setSelectByExampleWithBLOBsStatementId(String s) {
        this.internalAttributes.put(InternalAttribute.ATTR_SELECT_BY_EXAMPLE_WITH_BLOBS_STATEMENT_ID, s);
    }

    public void setSelectAllStatementId(String s) {
        this.internalAttributes.put(InternalAttribute.ATTR_SELECT_ALL_STATEMENT_ID, s);
    }

    public void setSelectByExampleStatementId(String s) {
        this.internalAttributes.put(InternalAttribute.ATTR_SELECT_BY_EXAMPLE_STATEMENT_ID, s);
    }

    public void setInsertSelectiveStatementId(String s) {
        this.internalAttributes.put(InternalAttribute.ATTR_INSERT_SELECTIVE_STATEMENT_ID, s);
    }

    public void setInsertStatementId(String s) {
        this.internalAttributes.put(InternalAttribute.ATTR_INSERT_STATEMENT_ID, s);
    }

    public void setDeleteByPrimaryKeyStatementId(String s) {
        this.internalAttributes.put(InternalAttribute.ATTR_DELETE_BY_PRIMARY_KEY_STATEMENT_ID, s);
    }

    public void setDeleteByExampleStatementId(String s) {
        this.internalAttributes.put(InternalAttribute.ATTR_DELETE_BY_EXAMPLE_STATEMENT_ID, s);
    }

    public void setCountByExampleStatementId(String s) {
        this.internalAttributes.put(InternalAttribute.ATTR_COUNT_BY_EXAMPLE_STATEMENT_ID, s);
    }

    public String getBlobColumnListId() {
        return this.internalAttributes.get((Object)InternalAttribute.ATTR_BLOB_COLUMN_LIST_ID);
    }

    public String getBaseColumnListId() {
        return this.internalAttributes.get((Object)InternalAttribute.ATTR_BASE_COLUMN_LIST_ID);
    }

    public String getExampleWhereClauseId() {
        return this.internalAttributes.get((Object)InternalAttribute.ATTR_EXAMPLE_WHERE_CLAUSE_ID);
    }

    public String getMyBatis3UpdateByExampleWhereClauseId() {
        return this.internalAttributes.get((Object)InternalAttribute.ATTR_MYBATIS3_UPDATE_BY_EXAMPLE_WHERE_CLAUSE_ID);
    }

    public String getResultMapWithBLOBsId() {
        return this.internalAttributes.get((Object)InternalAttribute.ATTR_RESULT_MAP_WITH_BLOBS_ID);
    }

    public String getBaseResultMapId() {
        return this.internalAttributes.get((Object)InternalAttribute.ATTR_BASE_RESULT_MAP_ID);
    }

    public String getUpdateByPrimaryKeyWithBLOBsStatementId() {
        return this.internalAttributes.get((Object)InternalAttribute.ATTR_UPDATE_BY_PRIMARY_KEY_WITH_BLOBS_STATEMENT_ID);
    }

    public String getUpdateByPrimaryKeySelectiveStatementId() {
        return this.internalAttributes.get((Object)InternalAttribute.ATTR_UPDATE_BY_PRIMARY_KEY_SELECTIVE_STATEMENT_ID);
    }

    public String getUpdateByPrimaryKeyStatementId() {
        return this.internalAttributes.get((Object)InternalAttribute.ATTR_UPDATE_BY_PRIMARY_KEY_STATEMENT_ID);
    }

    public String getUpdateByExampleWithBLOBsStatementId() {
        return this.internalAttributes.get((Object)InternalAttribute.ATTR_UPDATE_BY_EXAMPLE_WITH_BLOBS_STATEMENT_ID);
    }

    public String getUpdateByExampleSelectiveStatementId() {
        return this.internalAttributes.get((Object)InternalAttribute.ATTR_UPDATE_BY_EXAMPLE_SELECTIVE_STATEMENT_ID);
    }

    public String getUpdateByExampleStatementId() {
        return this.internalAttributes.get((Object)InternalAttribute.ATTR_UPDATE_BY_EXAMPLE_STATEMENT_ID);
    }

    public String getSelectByPrimaryKeyStatementId() {
        return this.internalAttributes.get((Object)InternalAttribute.ATTR_SELECT_BY_PRIMARY_KEY_STATEMENT_ID);
    }

    public String getSelectByExampleWithBLOBsStatementId() {
        return this.internalAttributes.get((Object)InternalAttribute.ATTR_SELECT_BY_EXAMPLE_WITH_BLOBS_STATEMENT_ID);
    }

    public String getSelectAllStatementId() {
        return this.internalAttributes.get((Object)InternalAttribute.ATTR_SELECT_ALL_STATEMENT_ID);
    }

    public String getSelectByExampleStatementId() {
        return this.internalAttributes.get((Object)InternalAttribute.ATTR_SELECT_BY_EXAMPLE_STATEMENT_ID);
    }

    public String getInsertSelectiveStatementId() {
        return this.internalAttributes.get((Object)InternalAttribute.ATTR_INSERT_SELECTIVE_STATEMENT_ID);
    }

    public String getInsertStatementId() {
        return this.internalAttributes.get((Object)InternalAttribute.ATTR_INSERT_STATEMENT_ID);
    }

    public String getDeleteByPrimaryKeyStatementId() {
        return this.internalAttributes.get((Object)InternalAttribute.ATTR_DELETE_BY_PRIMARY_KEY_STATEMENT_ID);
    }

    public String getDeleteByExampleStatementId() {
        return this.internalAttributes.get((Object)InternalAttribute.ATTR_DELETE_BY_EXAMPLE_STATEMENT_ID);
    }

    public String getCountByExampleStatementId() {
        return this.internalAttributes.get((Object)InternalAttribute.ATTR_COUNT_BY_EXAMPLE_STATEMENT_ID);
    }

    public String getMyBatisDynamicSQLTableObjectName() {
        return this.internalAttributes.get((Object)InternalAttribute.ATTR_MYBATIS_DYNAMIC_SQL_TABLE_OBJECT_NAME);
    }

    public void setMyBatisDynamicSQLTableObjectName(String name) {
        this.internalAttributes.put(InternalAttribute.ATTR_MYBATIS_DYNAMIC_SQL_TABLE_OBJECT_NAME, name);
    }

    private boolean isSubPackagesEnabled(PropertyHolder propertyHolder) {
        return StringUtility.isTrue(propertyHolder.getProperty("enableSubPackages"));
    }

    protected String calculateJavaClientInterfacePackage() {
        JavaClientGeneratorConfiguration config = this.context.getJavaClientGeneratorConfiguration();
        if (config == null) {
            return null;
        }
        return config.getTargetPackage() + this.fullyQualifiedTable.getSubPackageForClientOrSqlMap(this.isSubPackagesEnabled(config));
    }

    protected String calculateDynamicSqlSupportPackage() {
        JavaClientGeneratorConfiguration config = this.context.getJavaClientGeneratorConfiguration();
        if (config == null) {
            return null;
        }
        String packkage = config.getProperty("dynamicSqlSupportPackage");
        if (StringUtility.stringHasValue(packkage)) {
            return packkage + this.fullyQualifiedTable.getSubPackageForClientOrSqlMap(this.isSubPackagesEnabled(config));
        }
        return this.calculateJavaClientInterfacePackage();
    }

    protected void calculateJavaClientAttributes() {
        if (this.context.getJavaClientGeneratorConfiguration() == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.calculateJavaClientInterfacePackage());
        sb.append('.');
        if (StringUtility.stringHasValue(this.tableConfiguration.getMapperName())) {
            sb.append(this.tableConfiguration.getMapperName());
        } else {
            if (StringUtility.stringHasValue(this.fullyQualifiedTable.getDomainObjectSubPackage())) {
                sb.append(this.fullyQualifiedTable.getDomainObjectSubPackage());
                sb.append('.');
            }
            sb.append(this.fullyQualifiedTable.getDomainObjectName());
            sb.append("Mapper");
        }
        this.setMyBatis3JavaMapperType(sb.toString());
        sb.setLength(0);
        sb.append(this.calculateJavaClientInterfacePackage());
        sb.append('.');
        if (StringUtility.stringHasValue(this.tableConfiguration.getSqlProviderName())) {
            sb.append(this.tableConfiguration.getSqlProviderName());
        } else {
            if (StringUtility.stringHasValue(this.fullyQualifiedTable.getDomainObjectSubPackage())) {
                sb.append(this.fullyQualifiedTable.getDomainObjectSubPackage());
                sb.append('.');
            }
            sb.append(this.fullyQualifiedTable.getDomainObjectName());
            sb.append("SqlProvider");
        }
        this.setMyBatis3SqlProviderType(sb.toString());
        sb.setLength(0);
        sb.append(this.calculateDynamicSqlSupportPackage());
        sb.append('.');
        if (StringUtility.stringHasValue(this.tableConfiguration.getDynamicSqlSupportClassName())) {
            sb.append(this.tableConfiguration.getDynamicSqlSupportClassName());
        } else {
            if (StringUtility.stringHasValue(this.fullyQualifiedTable.getDomainObjectSubPackage())) {
                sb.append(this.fullyQualifiedTable.getDomainObjectSubPackage());
                sb.append('.');
            }
            sb.append(this.fullyQualifiedTable.getDomainObjectName());
            sb.append("DynamicSqlSupport");
        }
        this.setMyBatisDynamicSqlSupportType(sb.toString());
        if (StringUtility.stringHasValue(this.tableConfiguration.getDynamicSqlTableObjectName())) {
            this.setMyBatisDynamicSQLTableObjectName(this.tableConfiguration.getDynamicSqlTableObjectName());
        } else {
            this.setMyBatisDynamicSQLTableObjectName(this.fullyQualifiedTable.getDomainObjectName());
        }
    }

    protected String calculateJavaModelPackage() {
        JavaModelGeneratorConfiguration config = this.context.getJavaModelGeneratorConfiguration();
        return config.getTargetPackage() + this.fullyQualifiedTable.getSubPackageForModel(this.isSubPackagesEnabled(config));
    }

    protected void calculateModelAttributes() {
        String pakkage = this.calculateJavaModelPackage();
        StringBuilder sb = new StringBuilder();
        sb.append(pakkage);
        sb.append('.');
        sb.append(this.fullyQualifiedTable.getDomainObjectName());
        sb.append("Key");
        this.setPrimaryKeyType(sb.toString());
        sb.setLength(0);
        sb.append(pakkage);
        sb.append('.');
        sb.append(this.fullyQualifiedTable.getDomainObjectName());
        this.setBaseRecordType(sb.toString());
        sb.setLength(0);
        sb.append(pakkage);
        sb.append('.');
        sb.append(this.fullyQualifiedTable.getDomainObjectName());
        this.setKotlinRecordType(sb.toString());
        sb.setLength(0);
        sb.append(pakkage);
        sb.append('.');
        sb.append(this.fullyQualifiedTable.getDomainObjectName());
        sb.append("WithBLOBs");
        this.setRecordWithBLOBsType(sb.toString());
        String exampleTargetPackage = this.calculateJavaModelExamplePackage();
        sb.setLength(0);
        sb.append(exampleTargetPackage);
        sb.append('.');
        sb.append(this.fullyQualifiedTable.getDomainObjectName());
        sb.append("Example");
        this.setExampleType(sb.toString());
    }

    protected String calculateJavaModelExamplePackage() {
        JavaModelGeneratorConfiguration config = this.context.getJavaModelGeneratorConfiguration();
        String exampleTargetPackage = config.getProperty("exampleTargetPackage");
        if (!StringUtility.stringHasValue(exampleTargetPackage)) {
            return this.calculateJavaModelPackage();
        }
        return exampleTargetPackage + this.fullyQualifiedTable.getSubPackageForModel(this.isSubPackagesEnabled(config));
    }

    protected String calculateSqlMapPackage() {
        StringBuilder sb = new StringBuilder();
        SqlMapGeneratorConfiguration config = this.context.getSqlMapGeneratorConfiguration();
        if (config != null) {
            sb.append(config.getTargetPackage());
            sb.append(this.fullyQualifiedTable.getSubPackageForClientOrSqlMap(this.isSubPackagesEnabled(config)));
            if (StringUtility.stringHasValue(this.tableConfiguration.getMapperName())) {
                String mapperName = this.tableConfiguration.getMapperName();
                int ind = mapperName.lastIndexOf(46);
                if (ind != -1) {
                    sb.append('.').append(mapperName, 0, ind);
                }
            } else if (StringUtility.stringHasValue(this.fullyQualifiedTable.getDomainObjectSubPackage())) {
                sb.append('.').append(this.fullyQualifiedTable.getDomainObjectSubPackage());
            }
        }
        return sb.toString();
    }

    protected String calculateMyBatis3XmlMapperFileName() {
        StringBuilder sb = new StringBuilder();
        if (StringUtility.stringHasValue(this.tableConfiguration.getMapperName())) {
            String mapperName = this.tableConfiguration.getMapperName();
            int ind = mapperName.lastIndexOf(46);
            if (ind == -1) {
                sb.append(mapperName);
            } else {
                sb.append(mapperName.substring(ind + 1));
            }
            sb.append(".xml");
        } else {
            sb.append(this.fullyQualifiedTable.getDomainObjectName());
            sb.append("Mapper.xml");
        }
        return sb.toString();
    }

    protected String calculateMyBatis3FallbackSqlMapNamespace() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.calculateSqlMapPackage());
        sb.append('.');
        if (StringUtility.stringHasValue(this.tableConfiguration.getMapperName())) {
            sb.append(this.tableConfiguration.getMapperName());
        } else {
            sb.append(this.fullyQualifiedTable.getDomainObjectName());
            sb.append("Mapper");
        }
        return sb.toString();
    }

    protected String calculateSqlMapFullyQualifiedRuntimeTableName() {
        return this.fullyQualifiedTable.getFullyQualifiedTableNameAtRuntime();
    }

    protected String calculateSqlMapAliasedFullyQualifiedRuntimeTableName() {
        return this.fullyQualifiedTable.getAliasedFullyQualifiedTableNameAtRuntime();
    }

    public String getFullyQualifiedTableNameAtRuntime() {
        return this.internalAttributes.get((Object)InternalAttribute.ATTR_FULLY_QUALIFIED_TABLE_NAME_AT_RUNTIME);
    }

    public String getAliasedFullyQualifiedTableNameAtRuntime() {
        return this.internalAttributes.get((Object)InternalAttribute.ATTR_ALIASED_FULLY_QUALIFIED_TABLE_NAME_AT_RUNTIME);
    }

    public abstract void calculateGenerators(List<String> var1, ProgressCallback var2);

    public abstract List<GeneratedJavaFile> getGeneratedJavaFiles();

    public abstract List<GeneratedXmlFile> getGeneratedXmlFiles();

    public abstract List<GeneratedKotlinFile> getGeneratedKotlinFiles();

    public abstract int getGenerationSteps();

    public void setRules(Rules rules) {
        this.rules = rules;
    }

    public TableConfiguration getTableConfiguration() {
        return this.tableConfiguration;
    }

    public void setPrimaryKeyType(String primaryKeyType) {
        this.internalAttributes.put(InternalAttribute.ATTR_PRIMARY_KEY_TYPE, primaryKeyType);
    }

    public void setBaseRecordType(String baseRecordType) {
        this.internalAttributes.put(InternalAttribute.ATTR_BASE_RECORD_TYPE, baseRecordType);
    }

    public void setKotlinRecordType(String kotlinRecordType) {
        this.internalAttributes.put(InternalAttribute.ATTR_KOTLIN_RECORD_TYPE, kotlinRecordType);
    }

    public void setRecordWithBLOBsType(String recordWithBLOBsType) {
        this.internalAttributes.put(InternalAttribute.ATTR_RECORD_WITH_BLOBS_TYPE, recordWithBLOBsType);
    }

    public void setExampleType(String exampleType) {
        this.internalAttributes.put(InternalAttribute.ATTR_EXAMPLE_TYPE, exampleType);
    }

    public void setMyBatis3FallbackSqlMapNamespace(String sqlMapNamespace) {
        this.internalAttributes.put(InternalAttribute.ATTR_MYBATIS3_FALLBACK_SQL_MAP_NAMESPACE, sqlMapNamespace);
    }

    public void setSqlMapFullyQualifiedRuntimeTableName(String fullyQualifiedRuntimeTableName) {
        this.internalAttributes.put(InternalAttribute.ATTR_FULLY_QUALIFIED_TABLE_NAME_AT_RUNTIME, fullyQualifiedRuntimeTableName);
    }

    public void setSqlMapAliasedFullyQualifiedRuntimeTableName(String aliasedFullyQualifiedRuntimeTableName) {
        this.internalAttributes.put(InternalAttribute.ATTR_ALIASED_FULLY_QUALIFIED_TABLE_NAME_AT_RUNTIME, aliasedFullyQualifiedRuntimeTableName);
    }

    public String getMyBatis3XmlMapperPackage() {
        return this.internalAttributes.get((Object)InternalAttribute.ATTR_MYBATIS3_XML_MAPPER_PACKAGE);
    }

    public void setMyBatis3XmlMapperPackage(String mybatis3XmlMapperPackage) {
        this.internalAttributes.put(InternalAttribute.ATTR_MYBATIS3_XML_MAPPER_PACKAGE, mybatis3XmlMapperPackage);
    }

    public String getMyBatis3XmlMapperFileName() {
        return this.internalAttributes.get((Object)InternalAttribute.ATTR_MYBATIS3_XML_MAPPER_FILE_NAME);
    }

    public void setMyBatis3XmlMapperFileName(String mybatis3XmlMapperFileName) {
        this.internalAttributes.put(InternalAttribute.ATTR_MYBATIS3_XML_MAPPER_FILE_NAME, mybatis3XmlMapperFileName);
    }

    public String getMyBatis3JavaMapperType() {
        return this.internalAttributes.get((Object)InternalAttribute.ATTR_MYBATIS3_JAVA_MAPPER_TYPE);
    }

    public void setMyBatis3JavaMapperType(String mybatis3JavaMapperType) {
        this.internalAttributes.put(InternalAttribute.ATTR_MYBATIS3_JAVA_MAPPER_TYPE, mybatis3JavaMapperType);
    }

    public String getMyBatis3SqlProviderType() {
        return this.internalAttributes.get((Object)InternalAttribute.ATTR_MYBATIS3_SQL_PROVIDER_TYPE);
    }

    public void setMyBatis3SqlProviderType(String mybatis3SqlProviderType) {
        this.internalAttributes.put(InternalAttribute.ATTR_MYBATIS3_SQL_PROVIDER_TYPE, mybatis3SqlProviderType);
    }

    public String getMyBatisDynamicSqlSupportType() {
        return this.internalAttributes.get((Object)InternalAttribute.ATTR_MYBATIS_DYNAMIC_SQL_SUPPORT_TYPE);
    }

    public void setMyBatisDynamicSqlSupportType(String s) {
        this.internalAttributes.put(InternalAttribute.ATTR_MYBATIS_DYNAMIC_SQL_SUPPORT_TYPE, s);
    }

    public TargetRuntime getTargetRuntime() {
        return this.targetRuntime;
    }

    public boolean isImmutable() {
        Properties properties = this.tableConfiguration.getProperties().containsKey("immutable") ? this.tableConfiguration.getProperties() : this.context.getJavaModelGeneratorConfiguration().getProperties();
        return StringUtility.isTrue(properties.getProperty("immutable"));
    }

    public boolean isConstructorBased() {
        if (this.isImmutable()) {
            return true;
        }
        Properties properties = this.tableConfiguration.getProperties().containsKey("constructorBased") ? this.tableConfiguration.getProperties() : this.context.getJavaModelGeneratorConfiguration().getProperties();
        return StringUtility.isTrue(properties.getProperty("constructorBased"));
    }

    public abstract boolean requiresXMLGenerator();

    public Context getContext() {
        return this.context;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public String getTableType() {
        return this.tableType;
    }

    public void setTableType(String tableType) {
        this.tableType = tableType;
    }

    protected static enum InternalAttribute {
        ATTR_PRIMARY_KEY_TYPE,
        ATTR_BASE_RECORD_TYPE,
        ATTR_RECORD_WITH_BLOBS_TYPE,
        ATTR_EXAMPLE_TYPE,
        ATTR_MYBATIS3_XML_MAPPER_PACKAGE,
        ATTR_MYBATIS3_XML_MAPPER_FILE_NAME,
        ATTR_MYBATIS3_JAVA_MAPPER_TYPE,
        ATTR_MYBATIS3_FALLBACK_SQL_MAP_NAMESPACE,
        ATTR_FULLY_QUALIFIED_TABLE_NAME_AT_RUNTIME,
        ATTR_ALIASED_FULLY_QUALIFIED_TABLE_NAME_AT_RUNTIME,
        ATTR_COUNT_BY_EXAMPLE_STATEMENT_ID,
        ATTR_DELETE_BY_EXAMPLE_STATEMENT_ID,
        ATTR_DELETE_BY_PRIMARY_KEY_STATEMENT_ID,
        ATTR_INSERT_STATEMENT_ID,
        ATTR_INSERT_SELECTIVE_STATEMENT_ID,
        ATTR_SELECT_ALL_STATEMENT_ID,
        ATTR_SELECT_BY_EXAMPLE_STATEMENT_ID,
        ATTR_SELECT_BY_EXAMPLE_WITH_BLOBS_STATEMENT_ID,
        ATTR_SELECT_BY_PRIMARY_KEY_STATEMENT_ID,
        ATTR_UPDATE_BY_EXAMPLE_STATEMENT_ID,
        ATTR_UPDATE_BY_EXAMPLE_SELECTIVE_STATEMENT_ID,
        ATTR_UPDATE_BY_EXAMPLE_WITH_BLOBS_STATEMENT_ID,
        ATTR_UPDATE_BY_PRIMARY_KEY_STATEMENT_ID,
        ATTR_UPDATE_BY_PRIMARY_KEY_SELECTIVE_STATEMENT_ID,
        ATTR_UPDATE_BY_PRIMARY_KEY_WITH_BLOBS_STATEMENT_ID,
        ATTR_BASE_RESULT_MAP_ID,
        ATTR_RESULT_MAP_WITH_BLOBS_ID,
        ATTR_EXAMPLE_WHERE_CLAUSE_ID,
        ATTR_BASE_COLUMN_LIST_ID,
        ATTR_BLOB_COLUMN_LIST_ID,
        ATTR_MYBATIS3_UPDATE_BY_EXAMPLE_WHERE_CLAUSE_ID,
        ATTR_MYBATIS3_SQL_PROVIDER_TYPE,
        ATTR_MYBATIS_DYNAMIC_SQL_SUPPORT_TYPE,
        ATTR_KOTLIN_RECORD_TYPE,
        ATTR_MYBATIS_DYNAMIC_SQL_TABLE_OBJECT_NAME;

    }

    public static enum TargetRuntime {
        MYBATIS3,
        MYBATIS3_DSQL;

    }
}

