/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.targets.native.internal;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.commonizer.CommonizerLogLevel;
import org.jetbrains.kotlin.commonizer.CommonizerOutputFileLayout;
import org.jetbrains.kotlin.commonizer.CommonizerTarget;
import org.jetbrains.kotlin.commonizer.CommonizerTargetKt;
import org.jetbrains.kotlin.commonizer.KonanDistribution;
import org.jetbrains.kotlin.commonizer.KonanDistributionKt;
import org.jetbrains.kotlin.commonizer.LeafCommonizerTarget;
import org.jetbrains.kotlin.commonizer.NativeDistributionCommonizer;
import org.jetbrains.kotlin.commonizer.SharedCommonizerTarget;
import org.jetbrains.kotlin.gradle.targets.native.internal.NativeDistributionCommonizationCacheKt;
import org.jetbrains.kotlin.konan.target.KonanTarget;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001\u001eB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0005J\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J.\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\tH\u0002J\u0010\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J*\u0010\u0019\u001a\u0002H\u001a\"\u0004\b\u0000\u0010\u001a2\u0006\u0010\u000f\u001a\u00020\t2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u001cH\u0082\b\u00a2\u0006\u0002\u0010\u001dR\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/native/internal/NativeDistributionCommonizationCache;", "Lorg/jetbrains/kotlin/commonizer/NativeDistributionCommonizer;", "project", "Lorg/gradle/api/Project;", "commonizer", "(Lorg/gradle/api/Project;Lorg/jetbrains/kotlin/commonizer/NativeDistributionCommonizer;)V", "canReturnFast", "", "konanHome", "Ljava/io/File;", "missingOutputTargets", "", "Lorg/jetbrains/kotlin/commonizer/CommonizerTarget;", "commonizeNativeDistribution", "", "outputDirectory", "outputTargets", "Lorg/jetbrains/kotlin/commonizer/SharedCommonizerTarget;", "logLevel", "Lorg/jetbrains/kotlin/commonizer/CommonizerLogLevel;", "isCached", "directory", "logInfo", "message", "", "withLock", "T", "action", "Lkotlin/Function0;", "(Ljava/io/File;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "Logging", "kotlin-gradle-plugin"})
public final class NativeDistributionCommonizationCache
implements NativeDistributionCommonizer {
    @NotNull
    private final Project project;
    @NotNull
    private final NativeDistributionCommonizer commonizer;

    public NativeDistributionCommonizationCache(@NotNull Project project, @NotNull NativeDistributionCommonizer commonizer) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)commonizer, (String)"commonizer");
        this.project = project;
        this.commonizer = commonizer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void commonizeNativeDistribution(@NotNull File konanHome, @NotNull File outputDirectory2, @NotNull Set<SharedCommonizerTarget> outputTargets, @NotNull CommonizerLogLevel logLevel) {
        Intrinsics.checkNotNullParameter((Object)konanHome, (String)"konanHome");
        Intrinsics.checkNotNullParameter((Object)outputDirectory2, (String)"outputDirectory");
        Intrinsics.checkNotNullParameter(outputTargets, (String)"outputTargets");
        Intrinsics.checkNotNullParameter((Object)logLevel, (String)"logLevel");
        if (!NativeDistributionCommonizationCacheKt.isNativeDistributionCommonizationCacheEnabled(this.project)) {
            this.logInfo("Cache disabled");
        }
        NativeDistributionCommonizationCache this_$iv = this;
        boolean $i$f$withLock = false;
        outputDirectory2.mkdirs();
        File lockfile$iv = FilesKt.resolve((File)outputDirectory2, (String)".lock");
        this_$iv.logInfo("Acquire lock: " + lockfile$iv.getPath() + " ...");
        Closeable closeable = new FileOutputStream(FilesKt.resolve((File)outputDirectory2, (String)".lock"));
        Throwable throwable = null;
        try {
            Unit unit;
            FileOutputStream stream$iv = (FileOutputStream)closeable;
            boolean bl = false;
            FileLock lock$iv = stream$iv.getChannel().lock();
            boolean bl2 = lock$iv.isValid();
            if (_Assertions.ENABLED && !bl2) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            try {
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                Iterable $this$forEach$iv;
                Collection collection;
                Object item$iv$iv;
                Object $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                Set enqueuedOutputTargets;
                Object element$iv2;
                void $this$onEach$iv;
                SharedCommonizerTarget outputTarget;
                void $this$filterTo$iv$iv2;
                Iterable $this$filter$iv2;
                this_$iv.logInfo("Lock acquired: " + lockfile$iv.getPath());
                boolean bl3 = false;
                Iterable iterable = outputTargets;
                boolean $i$f$filter = false;
                void var18_23 = $this$filter$iv2;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                    outputTarget = (SharedCommonizerTarget)element$iv$iv;
                    boolean bl4 = false;
                    if (!this.isCached(CommonizerOutputFileLayout.INSTANCE.resolveCommonizedDirectory(outputDirectory2, (CommonizerTarget)outputTarget))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv2 = (List)destination$iv$iv;
                boolean $i$f$onEach22 = false;
                void $this$apply$iv = $this$filterTo$iv$iv2 = $this$onEach$iv;
                boolean bl5 = false;
                for (Object element$iv2 : $this$apply$iv) {
                    outputTarget = (SharedCommonizerTarget)element$iv2;
                    boolean bl6 = false;
                    this.logInfo("Cache hit: " + outputTarget + " already commonized");
                }
                Set cachedOutputTargets = CollectionsKt.toSet((Iterable)$this$filterTo$iv$iv2);
                Set set2 = enqueuedOutputTargets = NativeDistributionCommonizationCacheKt.isNativeDistributionCommonizationCacheEnabled(this.project) ? SetsKt.minus(outputTargets, (Iterable)cachedOutputTargets) : outputTargets;
                if (this.canReturnFast(konanHome, enqueuedOutputTargets)) {
                    this.logInfo("All available targets are commonized already - Nothing to do");
                    return;
                }
                Iterable $i$f$onEach22 = enqueuedOutputTargets;
                boolean $i$f$map = false;
                $this$apply$iv = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                element$iv2 = $this$mapTo$iv$iv.iterator();
                while (element$iv2.hasNext()) {
                    void outputTarget2;
                    item$iv$iv = element$iv2.next();
                    SharedCommonizerTarget bl6 = (SharedCommonizerTarget)item$iv$iv;
                    collection = destination$iv$iv2;
                    boolean bl7 = false;
                    collection.add(CommonizerOutputFileLayout.INSTANCE.resolveCommonizedDirectory(outputDirectory2, (CommonizerTarget)outputTarget2));
                }
                $this$map$iv = (List)destination$iv$iv2;
                boolean $i$f$forEach = false;
                for (Object element$iv3 : $this$forEach$iv) {
                    File commonizedDirectory = (File)element$iv3;
                    boolean bl8 = false;
                    if (!commonizedDirectory.exists()) continue;
                    FilesKt.deleteRecursively((File)commonizedDirectory);
                }
                this.commonizer.commonizeNativeDistribution(konanHome, outputDirectory2, enqueuedOutputTargets, logLevel);
                $this$forEach$iv = enqueuedOutputTargets;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                Iterator bl8 = $this$mapTo$iv$iv.iterator();
                while (bl8.hasNext()) {
                    item$iv$iv = bl8.next();
                    SharedCommonizerTarget outputTarget2 = (SharedCommonizerTarget)item$iv$iv;
                    collection = destination$iv$iv2;
                    boolean bl9 = false;
                    collection.add(CommonizerOutputFileLayout.INSTANCE.resolveCommonizedDirectory(outputDirectory2, (CommonizerTarget)outputTarget2));
                }
                $this$map$iv = (List)destination$iv$iv2;
                boolean $i$f$filter2 = false;
                $this$mapTo$iv$iv = $this$filter$iv;
                destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo2 = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    File commonizedDirectory = (File)element$iv$iv;
                    boolean bl10 = false;
                    if (!commonizedDirectory.isDirectory()) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv2;
                $i$f$forEach = false;
                for (Object element$iv3 : $this$forEach$iv) {
                    File commonizedDirectory = (File)element$iv3;
                    boolean bl11 = false;
                    FilesKt.resolve((File)commonizedDirectory, (String)".success").createNewFile();
                }
                unit = Unit.INSTANCE;
            }
            finally {
                lock$iv.release();
                this_$iv.logInfo("Lock released: " + lockfile$iv.getPath());
            }
            Unit unit2 = unit;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final boolean isCached(File directory2) {
        File successMarkerFile = FilesKt.resolve((File)directory2, (String)".success");
        return successMarkerFile.isFile();
    }

    /*
     * WARNING - void declaration
     */
    private final boolean canReturnFast(File konanHome, Set<? extends CommonizerTarget> missingOutputTargets) {
        boolean bl;
        block6: {
            KonanTarget target2;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            if (missingOutputTargets.isEmpty()) {
                return true;
            }
            Iterable $this$map$iv = CommonizerTargetKt.allLeaves((Iterable)missingOutputTargets);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                LeafCommonizerTarget leafCommonizerTarget = (LeafCommonizerTarget)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(target2.getKonanTarget());
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void konanTarget2;
                target2 = (KonanTarget)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(FilesKt.resolve((File)KonanDistributionKt.getPlatformLibsDir((KonanDistribution)new KonanDistribution(konanHome)), (String)konanTarget2.getName()));
            }
            Iterable $this$none$iv = (List)destination$iv$iv;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    File platformLibsDir = (File)element$iv;
                    boolean bl4 = false;
                    if (!platformLibsDir.exists()) continue;
                    bl = false;
                    break block6;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T withLock(File outputDirectory2, Function0<? extends T> action) {
        Object object;
        boolean $i$f$withLock = false;
        outputDirectory2.mkdirs();
        File lockfile = FilesKt.resolve((File)outputDirectory2, (String)".lock");
        this.logInfo("Acquire lock: " + lockfile.getPath() + " ...");
        Closeable closeable = new FileOutputStream(FilesKt.resolve((File)outputDirectory2, (String)".lock"));
        Throwable throwable = null;
        try {
            Object object2;
            FileOutputStream stream = (FileOutputStream)closeable;
            boolean bl = false;
            FileLock lock = stream.getChannel().lock();
            boolean bl2 = lock.isValid();
            if (_Assertions.ENABLED && !bl2) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            try {
                this.logInfo("Lock acquired: " + lockfile.getPath());
                object2 = action.invoke();
            }
            finally {
                InlineMarker.finallyStart((int)1);
                lock.release();
                this.logInfo("Lock released: " + lockfile.getPath());
                InlineMarker.finallyEnd((int)1);
            }
            object = object2;
        }
        catch (Throwable throwable2) {
            try {
                throwable = throwable2;
                throw throwable2;
            }
            catch (Throwable throwable3) {
                InlineMarker.finallyStart((int)1);
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                InlineMarker.finallyEnd((int)1);
                throw throwable3;
            }
        }
        InlineMarker.finallyStart((int)2);
        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        InlineMarker.finallyEnd((int)2);
        return (T)object;
    }

    private final void logInfo(String message2) {
        this.project.getLogger().info("Native Distribution Commonization: " + message2);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/native/internal/NativeDistributionCommonizationCache$Logging;", "", "()V", "prefix", "", "kotlin-gradle-plugin"})
    private static final class Logging {
        @NotNull
        public static final Logging INSTANCE = new Logging();
        @NotNull
        public static final String prefix = "Native Distribution Commonization";

        private Logging() {
        }
    }
}

