/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.statistics;

import com.gradle.scan.plugin.BuildScanExtension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.build.report.metrics.BuildAttribute;
import org.jetbrains.kotlin.build.report.metrics.BuildPerformanceMetric;
import org.jetbrains.kotlin.build.report.metrics.BuildTime;
import org.jetbrains.kotlin.gradle.plugin.stat.CompileStatData;
import org.jetbrains.kotlin.gradle.plugin.stat.ReportStatistics;
import org.jetbrains.kotlin.gradle.plugin.statistics.ReportStatisticsToBuildScan;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/statistics/ReportStatisticsToBuildScan;", "Lorg/jetbrains/kotlin/gradle/plugin/stat/ReportStatistics;", "buildScan", "Lcom/gradle/scan/plugin/BuildScanExtension;", "(Lcom/gradle/scan/plugin/BuildScanExtension;)V", "log", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "tags", "Ljava/util/LinkedHashSet;", "", "Lkotlin/collections/LinkedHashSet;", "readableFileLength", "length", "", "readableString", "data", "Lorg/jetbrains/kotlin/gradle/plugin/stat/CompileStatData;", "report", "", "Companion", "kotlin-gradle-plugin"})
public final class ReportStatisticsToBuildScan
implements ReportStatistics {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BuildScanExtension buildScan;
    @NotNull
    private final LinkedHashSet<String> tags;
    private final Logger log;
    public static final int kbSize = 1024;
    public static final int mbSize = 0x100000;
    public static final int gbSize = 0x40000000;

    public ReportStatisticsToBuildScan(@NotNull BuildScanExtension buildScan) {
        Intrinsics.checkNotNullParameter((Object)buildScan, (String)"buildScan");
        this.buildScan = buildScan;
        this.tags = new LinkedHashSet();
        this.log = Logging.getLogger(this.getClass());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void report(@NotNull CompileStatData data) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        this.buildScan.value(data.getTaskName(), this.readableString(data));
        Iterable iterable = data.getTags();
        boolean $i$f$filter = false;
        Iterator iterator = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (!(!this.tags.contains(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl3 = false;
            this.buildScan.tag(it);
            this.tags.add(it);
        }
        long elapsedTime = System.currentTimeMillis() - start$iv;
        this.log.debug("Report statistic to build scan takes " + elapsedTime + " ms");
    }

    /*
     * WARNING - void declaration
     */
    private final String readableString(CompileStatData data) {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Map<BuildAttribute, Integer> $this$filterValues$iv = data.getNonIncrementalAttributes();
        boolean $i$f$filterValues = false;
        LinkedHashMap<BuildAttribute, Integer> result$iv = new LinkedHashMap<BuildAttribute, Integer>();
        Map<BuildAttribute, Integer> map = $this$filterValues$iv;
        for (Map.Entry<BuildAttribute, Integer> entry$iv : map.entrySet()) {
            int it = ((Number)entry$iv.getValue()).intValue();
            boolean bl = false;
            if (!(it > 0)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        Set nonIncrementalReasons = ((Map)result$iv).keySet();
        StringBuilder readableString2 = new StringBuilder();
        if (nonIncrementalReasons.isEmpty()) {
            readableString2.append("Incremental build; ");
        } else {
            CollectionsKt.joinTo$default((Iterable)nonIncrementalReasons, (Appendable)readableString2, null, (CharSequence)"Non incremental build because: [", (CharSequence)"]; ", (int)0, null, (Function1)readableString.1.INSTANCE, (int)50, null);
        }
        CollectionsKt.joinTo$default((Iterable)data.getChanges(), (Appendable)readableString2, null, (CharSequence)"Changes: [", (CharSequence)"]; ", (int)0, null, (Function1)readableString.2.INSTANCE, (int)50, null);
        Map<BuildTime, Long> $this$map$iv = data.getTimeData();
        boolean $i$f$map = false;
        Map<BuildTime, Long> map2 = $this$map$iv;
        Object destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        void bl = $this$mapTo$iv$iv2;
        Iterator iterator = bl.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            collection = destination$iv$iv;
            boolean bl2 = false;
            BuildTime key = (BuildTime)entry.getKey();
            long value = ((Number)entry.getValue()).longValue();
            collection.add(key.getReadableString() + ": " + value + "ms");
        }
        List timeData = (List)destination$iv$iv;
        Map<BuildPerformanceMetric, Long> $this$map$iv2 = data.getPerfData();
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList($this$map$iv2.size());
        boolean $i$f$mapTo2 = false;
        iterator = $this$mapTo$iv$iv;
        Iterator iterator2 = iterator.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            collection = destination$iv$iv2;
            boolean bl3 = false;
            BuildPerformanceMetric key = (BuildPerformanceMetric)entry.getKey();
            long value = ((Number)entry.getValue()).longValue();
            collection.add(key.getReadableString() + ": " + this.readableFileLength(value));
        }
        List perfData = (List)destination$iv$iv2;
        CollectionsKt.joinTo$default((Iterable)CollectionsKt.union((Iterable)timeData, (Iterable)perfData), (Appendable)readableString2, (CharSequence)",", (CharSequence)"Performance: [", (CharSequence)"]", (int)0, null, null, (int)112, null);
        String string = readableString2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readableString.toString()");
        return string;
    }

    private final String readableFileLength(long length) {
        return length / (long)0x40000000 > 0L ? length / (long)0x40000000 + " GB" : (length / (long)0x100000 > 0L ? length / (long)0x100000 + " MB" : (length / (long)1024 > 0L ? length / (long)1024 + " KB" : length + " B"));
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/statistics/ReportStatisticsToBuildScan$Companion;", "", "()V", "gbSize", "", "kbSize", "mbSize", "kotlin-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

