/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory0;
import org.jetbrains.kotlin.load.java.descriptors.JavaCallableMemberDescriptor;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/InterfaceDefaultMethodCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "jvmTarget", "Lorg/jetbrains/kotlin/config/JvmTarget;", "(Lorg/jetbrains/kotlin/config/JvmTarget;)V", "getJvmTarget", "()Lorg/jetbrains/kotlin/config/JvmTarget;", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "isDefaultCallsProhibited", "", "frontend.java"})
public final class InterfaceDefaultMethodCallChecker
implements CallChecker {
    @NotNull
    private final JvmTarget jvmTarget;

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        FunctionDescriptor realDescriptor;
        Intrinsics.checkParameterIsNotNull(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkParameterIsNotNull((Object)reportOn, (String)"reportOn");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        boolean supportDefaults = this.jvmTarget == JvmTarget.JVM_1_8;
        Object obj = resolvedCall2.getResultingDescriptor();
        if (!(obj instanceof FunctionDescriptor)) {
            obj = null;
        }
        FunctionDescriptor functionDescriptor = (FunctionDescriptor)obj;
        if (functionDescriptor == null) {
            return;
        }
        FunctionDescriptor descriptor2 = functionDescriptor;
        if (!supportDefaults && DescriptorUtils.isStaticDeclaration(descriptor2) && DescriptorUtils.isInterface(descriptor2.getContainingDeclaration()) && descriptor2 instanceof JavaCallableMemberDescriptor) {
            DiagnosticFactory0<PsiElement> diagnostic = this.isDefaultCallsProhibited(context) ? ErrorsJvm.INTERFACE_STATIC_METHOD_CALL_FROM_JAVA6_TARGET_ERROR : ErrorsJvm.INTERFACE_STATIC_METHOD_CALL_FROM_JAVA6_TARGET;
            context.getTrace().report(diagnostic.on(reportOn));
        }
        Call call2 = resolvedCall2.getCall();
        Intrinsics.checkExpressionValueIsNotNull((Object)call2, (String)"resolvedCall.call");
        if (CallResolverUtilKt.getSuperCallExpression(call2) == null) {
            return;
        }
        FunctionDescriptor functionDescriptor2 = descriptor2.getOriginal();
        Intrinsics.checkExpressionValueIsNotNull((Object)functionDescriptor2, (String)"descriptor.original");
        if (!DescriptorUtils.isInterface(functionDescriptor2.getContainingDeclaration())) {
            return;
        }
        FunctionDescriptor functionDescriptor3 = realDescriptor = (FunctionDescriptor)DescriptorUtils.unwrapFakeOverride((CallableMemberDescriptor)descriptor2);
        Intrinsics.checkExpressionValueIsNotNull((Object)functionDescriptor3, (String)"realDescriptor");
        DeclarationDescriptor declarationDescriptor = functionDescriptor3.getContainingDeclaration();
        if (!(declarationDescriptor instanceof ClassDescriptor)) {
            declarationDescriptor = null;
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)declarationDescriptor;
        if (classDescriptor == null) {
            return;
        }
        ClassDescriptor realDescriptorOwner = classDescriptor;
        if (DescriptorUtils.isInterface(realDescriptorOwner) && realDescriptor instanceof JavaCallableMemberDescriptor) {
            ClassifierDescriptor classifier2 = DescriptorUtils.getParentOfType(context.getScope().getOwnerDescriptor(), ClassifierDescriptor.class);
            if (classifier2 != null && DescriptorUtils.isInterface(classifier2)) {
                context.getTrace().report(ErrorsJvm.INTERFACE_CANT_CALL_DEFAULT_METHOD_VIA_SUPER.on(reportOn));
            } else if (!supportDefaults) {
                DiagnosticFactory0<PsiElement> diagnostic = this.isDefaultCallsProhibited(context) ? ErrorsJvm.DEFAULT_METHOD_CALL_FROM_JAVA6_TARGET_ERROR : ErrorsJvm.DEFAULT_METHOD_CALL_FROM_JAVA6_TARGET;
                context.getTrace().report(diagnostic.on(reportOn));
            }
        }
    }

    private final boolean isDefaultCallsProhibited(CallCheckerContext context) {
        return context.getLanguageVersionSettings().supportsFeature(LanguageFeature.DefaultMethodsCallFromJava6TargetError);
    }

    @NotNull
    public final JvmTarget getJvmTarget() {
        return this.jvmTarget;
    }

    public InterfaceDefaultMethodCallChecker(@NotNull JvmTarget jvmTarget) {
        Intrinsics.checkParameterIsNotNull((Object)jvmTarget, (String)"jvmTarget");
        this.jvmTarget = jvmTarget;
    }
}

