/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.asJava;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.impl.java.stubs.PsiClassStub;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtil;
import org.jetbrains.kotlin.asJava.LightClassUtil$getPsiMethodWrappers$;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.asJava.elements.KotlinLightTypeParameterListBuilder;
import org.jetbrains.kotlin.asJava.elements.KtLightElement;
import org.jetbrains.kotlin.asJava.elements.KtLightField;
import org.jetbrains.kotlin.asJava.elements.KtLightMethod;
import org.jetbrains.kotlin.asJava.elements.KtLightMethodImplKt;
import org.jetbrains.kotlin.asJava.elements.KtLightTypeParameter;
import org.jetbrains.kotlin.asJava.finder.JavaElementFinder;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtilKt;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u00014B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bJ$\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000fH\u0002J,\u0010\u0011\u001a\u0004\u0018\u00010\u00122\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u00142\u0016\u0010\u0015\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0017\u0012\u0004\u0012\u00020\n0\u0016J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001f2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0010\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\"\u001a\u0004\u0018\u00010\u000f2\u0006\u0010#\u001a\u00020$J\u0010\u0010\"\u001a\u0004\u0018\u00010\u000f2\u0006\u0010%\u001a\u00020&J\u0014\u0010'\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001f2\u0006\u0010#\u001a\u00020$J\u000e\u0010(\u001a\u00020\f2\u0006\u0010%\u001a\u00020&J\u000e\u0010(\u001a\u00020\f2\u0006\u0010)\u001a\u00020*J\u0010\u0010+\u001a\u0004\u0018\u00010!2\u0006\u0010,\u001a\u00020-J\u0012\u0010.\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0016\u0010/\u001a\b\u0012\u0004\u0012\u000201002\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0012\u00102\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0016\u00103\u001a\b\u0012\u0004\u0012\u00020\u0012002\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u00065"}, d2={"Lorg/jetbrains/kotlin/asJava/LightClassUtil;", "", "()V", "buildLightTypeParameterList", "Lcom/intellij/psi/PsiTypeParameterList;", "owner", "Lcom/intellij/psi/PsiTypeParameterListOwner;", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "canGenerateLightClass", "", "extractPropertyAccessors", "Lorg/jetbrains/kotlin/asJava/LightClassUtil$PropertyAccessorsPsiMethods;", "ktDeclaration", "specialGetter", "Lcom/intellij/psi/PsiMethod;", "specialSetter", "findClass", "Lcom/intellij/psi/PsiClass;", "stub", "Lcom/intellij/psi/stubs/StubElement;", "predicate", "Lkotlin/Function1;", "Lcom/intellij/psi/impl/java/stubs/PsiClassStub;", "findFileFacade", "ktFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "getLightClassAccessorMethod", "accessor", "Lorg/jetbrains/kotlin/psi/KtPropertyAccessor;", "getLightClassAccessorMethods", "", "getLightClassBackingField", "Lcom/intellij/psi/PsiField;", "getLightClassMethod", "function", "Lorg/jetbrains/kotlin/psi/KtFunction;", "parameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "getLightClassMethods", "getLightClassPropertyMethods", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "getLightFieldForCompanionObject", "companionObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "getPsiMethodWrapper", "getPsiMethodWrappers", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/kotlin/asJava/elements/KtLightMethod;", "getWrappingClass", "getWrappingClasses", "PropertyAccessorsPsiMethods", "light-classes"})
public final class LightClassUtil {
    public static final LightClassUtil INSTANCE;

    @Nullable
    public final PsiClass findClass(@NotNull StubElement<?> stub, @NotNull Function1<? super PsiClassStub<?>, Boolean> predicate) {
        Intrinsics.checkParameterIsNotNull(stub, (String)"stub");
        Intrinsics.checkParameterIsNotNull(predicate, (String)"predicate");
        if (stub instanceof PsiClassStub && ((Boolean)predicate.invoke(stub)).booleanValue()) {
            return (PsiClass)((PsiClassStub)stub).getPsi();
        }
        if (stub instanceof PsiClassStub || stub instanceof PsiFileStub) {
            Iterator<StubElement> iterator2 = stub.getChildrenStubs().iterator();
            while (iterator2.hasNext()) {
                StubElement child;
                StubElement stubElement = child = iterator2.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)stubElement, (String)"child");
                PsiClass answer = this.findClass(stubElement, predicate);
                if (answer == null) continue;
                return answer;
            }
        }
        return null;
    }

    @Nullable
    public final PsiMethod getLightClassAccessorMethod(@NotNull KtPropertyAccessor accessor) {
        Intrinsics.checkParameterIsNotNull((Object)accessor, (String)"accessor");
        return (PsiMethod)CollectionsKt.firstOrNull(this.getLightClassAccessorMethods(accessor));
    }

    @NotNull
    public final List<PsiMethod> getLightClassAccessorMethods(@NotNull KtPropertyAccessor accessor) {
        Intrinsics.checkParameterIsNotNull((Object)accessor, (String)"accessor");
        PsiElement $receiver$iv = accessor;
        KtProperty ktProperty = PsiTreeUtil.getParentOfType($receiver$iv, KtProperty.class, false);
        if (ktProperty == null) {
            return CollectionsKt.emptyList();
        }
        KtProperty property = ktProperty;
        Sequence<KtLightMethod> wrappers = this.getPsiMethodWrappers(property);
        return SequencesKt.toList((Sequence)SequencesKt.filter(wrappers, (Function1)((Function1)new Function1<KtLightMethod, Boolean>(accessor){
            final /* synthetic */ KtPropertyAccessor $accessor;

            public final boolean invoke(@NotNull KtLightMethod wrapper) {
                Intrinsics.checkParameterIsNotNull((Object)wrapper, (String)"wrapper");
                return this.$accessor.isGetter() && !JvmAbi.isSetterName(wrapper.getName()) || this.$accessor.isSetter() && JvmAbi.isSetterName(wrapper.getName());
            }
            {
                this.$accessor = ktPropertyAccessor;
                super(1);
            }
        })));
    }

    @Nullable
    public final PsiField getLightFieldForCompanionObject(@NotNull KtClassOrObject companionObject) {
        Intrinsics.checkParameterIsNotNull((Object)companionObject, (String)"companionObject");
        PsiClass outerPsiClass = this.getWrappingClass(companionObject);
        if (outerPsiClass != null) {
            for (PsiField fieldOfParent : outerPsiClass.getFields()) {
                if (!(fieldOfParent instanceof KtLightElement) || ((KtLightElement)((Object)fieldOfParent)).getKotlinOrigin() != companionObject.getOriginalElement()) continue;
                return fieldOfParent;
            }
        }
        return null;
    }

    @NotNull
    public final PropertyAccessorsPsiMethods getLightClassPropertyMethods(@NotNull KtProperty property) {
        Intrinsics.checkParameterIsNotNull((Object)property, (String)"property");
        KtPropertyAccessor getter2 = property.getGetter();
        KtPropertyAccessor setter2 = property.getSetter();
        PsiMethod getterWrapper = getter2 != null ? this.getLightClassAccessorMethod(getter2) : null;
        PsiMethod setterWrapper = setter2 != null ? this.getLightClassAccessorMethod(setter2) : null;
        return this.extractPropertyAccessors(property, getterWrapper, setterWrapper);
    }

    @Nullable
    public final PsiField getLightClassBackingField(@NotNull KtDeclaration declaration) {
        KtLightClass containingLightClass;
        KtClass containingClass;
        KtClassOrObject origin;
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        PsiClass psiClass = this.getWrappingClass(declaration);
        if (psiClass == null) {
            return null;
        }
        PsiClass psiClass2 = psiClass;
        if (psiClass2 instanceof KtLightClass && (origin = (KtClassOrObject)((KtLightClass)psiClass2).getKotlinOrigin()) instanceof KtObjectDeclaration && ((KtObjectDeclaration)origin).isCompanion() && (containingClass = PsiTreeUtil.getParentOfType((PsiElement)origin, KtClass.class)) != null && (containingLightClass = LightClassUtilsKt.toLightClass(containingClass)) != null) {
            psiClass2 = containingLightClass;
        }
        for (PsiField field : psiClass2.getFields()) {
            if (!(field instanceof KtLightField) || (KtDeclaration)((KtLightField)field).getKotlinOrigin() != declaration) continue;
            return field;
        }
        return null;
    }

    @NotNull
    public final PropertyAccessorsPsiMethods getLightClassPropertyMethods(@NotNull KtParameter parameter) {
        Intrinsics.checkParameterIsNotNull((Object)parameter, (String)"parameter");
        return this.extractPropertyAccessors(parameter, null, null);
    }

    @Nullable
    public final PsiMethod getLightClassMethod(@NotNull KtFunction function2) {
        Intrinsics.checkParameterIsNotNull((Object)function2, (String)"function");
        return this.getPsiMethodWrapper(function2);
    }

    @Nullable
    public final PsiMethod getLightClassMethod(@NotNull KtParameter parameter) {
        Intrinsics.checkParameterIsNotNull((Object)parameter, (String)"parameter");
        return this.getPsiMethodWrapper(parameter);
    }

    @NotNull
    public final List<PsiMethod> getLightClassMethods(@NotNull KtFunction function2) {
        Intrinsics.checkParameterIsNotNull((Object)function2, (String)"function");
        return SequencesKt.toList(this.getPsiMethodWrappers(function2));
    }

    private final PsiMethod getPsiMethodWrapper(KtDeclaration declaration) {
        return (PsiMethod)SequencesKt.firstOrNull(this.getPsiMethodWrappers(declaration));
    }

    private final Sequence<KtLightMethod> getPsiMethodWrappers(KtDeclaration declaration) {
        Sequence $receiver$iv = SequencesKt.flatMap(this.getWrappingClasses(declaration), (Function1)getPsiMethodWrappers.1.INSTANCE);
        Sequence sequence2 = SequencesKt.filter((Sequence)$receiver$iv, (Function1)getPsiMethodWrappers$$inlined$filterIsInstance$1.INSTANCE);
        if (sequence2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
        }
        return SequencesKt.filter((Sequence)sequence2, (Function1)((Function1)new Function1<KtLightMethod, Boolean>(declaration){
            final /* synthetic */ KtDeclaration $declaration;

            public final boolean invoke(@NotNull KtLightMethod it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return (KtDeclaration)it.getKotlinOrigin() == this.$declaration;
            }
            {
                this.$declaration = ktDeclaration;
                super(1);
            }
        }));
    }

    private final PsiClass getWrappingClass(KtDeclaration declaration) {
        KtClassOrObject constructorClass;
        KtDeclaration declaration2 = declaration;
        if (declaration2 instanceof KtParameter && (constructorClass = KtPsiUtil.getClassIfParameterIsProperty((KtParameter)declaration2)) != null) {
            return LightClassUtilsKt.toLightClass(constructorClass);
        }
        if (declaration2 instanceof KtPropertyAccessor) {
            KtProperty ktProperty = ((KtPropertyAccessor)declaration2).getProperty();
            Intrinsics.checkExpressionValueIsNotNull((Object)ktProperty, (String)"declaration.property");
            declaration2 = ktProperty;
        }
        if (declaration2 instanceof KtConstructor) {
            return LightClassUtilsKt.toLightClass(((KtConstructor)declaration2).getContainingClassOrObject());
        }
        PsiElement parent2 = declaration2.getParent();
        if (parent2 instanceof KtFile) {
            return this.findFileFacade((KtFile)parent2);
        }
        if (parent2 instanceof KtClassBody) {
            boolean bl = ((KtClassBody)parent2).getParent() instanceof KtClassOrObject;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            PsiElement psiElement = ((KtClassBody)parent2).getParent();
            if (psiElement == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtClassOrObject");
            }
            return LightClassUtilsKt.toLightClass((KtClassOrObject)psiElement);
        }
        return null;
    }

    private final PsiClass findFileFacade(KtFile ktFile) {
        FqName fqName2 = JvmFileClassUtilKt.getJavaFileFacadeFqName(ktFile);
        Project project = ktFile.getProject();
        PsiClass[] classesWithMatchingFqName = JavaElementFinder.getInstance(project).findClasses(fqName2.asString(), GlobalSearchScope.allScope(project));
        Intrinsics.checkExpressionValueIsNotNull((Object)classesWithMatchingFqName, (String)"classesWithMatchingFqName");
        PsiClass psiClass = (PsiClass)ArraysKt.singleOrNull((Object[])classesWithMatchingFqName);
        if (psiClass == null) {
            Object object;
            block2: {
                Object[] objectArray;
                for (Object object2 : objectArray = (Object[])classesWithMatchingFqName) {
                    PsiClass it;
                    PsiClass psiClass2 = it = (PsiClass)object2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiClass2, (String)"it");
                    PsiFile psiFile = psiClass2.getContainingFile();
                    if (!Intrinsics.areEqual((Object)(psiFile != null ? psiFile.getVirtualFile() : null), (Object)ktFile.getVirtualFile())) continue;
                    object = object2;
                    break block2;
                }
                object = null;
            }
            psiClass = (PsiClass)object;
        }
        return psiClass;
    }

    private final Sequence<PsiClass> getWrappingClasses(KtDeclaration declaration) {
        PsiClass wrapperClass;
        PsiClass psiClass = this.getWrappingClass(declaration);
        if (psiClass == null) {
            return SequencesKt.emptySequence();
        }
        PsiClass psiClass2 = wrapperClass = psiClass;
        if (psiClass2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.asJava.classes.KtLightClass");
        }
        KtClassOrObject wrapperClassOrigin = (KtClassOrObject)((KtLightClass)psiClass2).getKotlinOrigin();
        if (wrapperClassOrigin instanceof KtObjectDeclaration && ((KtObjectDeclaration)wrapperClassOrigin).isCompanion() && ((KtLightClass)wrapperClass).getParent() instanceof PsiClass) {
            Object[] objectArray = new PsiClass[2];
            objectArray[0] = wrapperClass;
            PsiElement psiElement = ((KtLightClass)wrapperClass).getParent();
            if (psiElement == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.PsiClass");
            }
            objectArray[1] = (PsiClass)psiElement;
            return SequencesKt.sequenceOf((Object[])objectArray);
        }
        return SequencesKt.sequenceOf((Object[])new KtLightClass[]{(KtLightClass)wrapperClass});
    }

    public final boolean canGenerateLightClass(@NotNull KtDeclaration declaration) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        return PsiTreeUtil.getParentOfType((PsiElement)declaration, KtFunction.class, KtProperty.class) == null;
    }

    /*
     * WARNING - void declaration
     */
    private final PropertyAccessorsPsiMethods extractPropertyAccessors(KtDeclaration ktDeclaration, PsiMethod specialGetter, PsiMethod specialSetter) {
        void $receiver$iv$iv;
        void $receiver$iv;
        void setters;
        Iterable $receiver$iv$iv2;
        KtLightMethod it;
        Object $receiver$iv2 = this.getPsiMethodWrappers(ktDeclaration);
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $receiver$iv2) {
            it = (KtLightMethod)element$iv;
            if (KtLightMethodImplKt.isSetter(it)) {
                first$iv.add(element$iv);
                continue;
            }
            second$iv.add(element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List list2 = (List)pair.component1();
        List getters = (List)pair.component2();
        $receiver$iv2 = getters;
        Collection collection = CollectionsKt.listOfNotNull((Object)specialGetter);
        first$iv = $receiver$iv2;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv2) {
            it = (KtLightMethod)element$iv$iv;
            if (Intrinsics.areEqual((Object)it, (Object)specialGetter)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list3 = (List)destination$iv$iv;
        List allGetters = CollectionsKt.plus((Collection)collection, (Iterable)list3);
        $receiver$iv$iv2 = (Iterable)setters;
        collection = CollectionsKt.listOfNotNull((Object)specialSetter);
        destination$iv$iv = $receiver$iv;
        Collection destination$iv$iv2 = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            KtLightMethod it2 = (KtLightMethod)element$iv$iv;
            if (Intrinsics.areEqual((Object)it2, (Object)specialSetter)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        list3 = (List)destination$iv$iv2;
        List allSetters = CollectionsKt.plus((Collection)collection, (Iterable)list3);
        PsiField backingField = this.getLightClassBackingField(ktDeclaration);
        List additionalAccessors = CollectionsKt.plus((Collection)CollectionsKt.drop((Iterable)allGetters, (int)1), (Iterable)CollectionsKt.drop((Iterable)allSetters, (int)1));
        return new PropertyAccessorsPsiMethods((PsiMethod)CollectionsKt.firstOrNull((List)allGetters), (PsiMethod)CollectionsKt.firstOrNull((List)allSetters), backingField, additionalAccessors);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final PsiTypeParameterList buildLightTypeParameterList(@NotNull PsiTypeParameterListOwner owner, @NotNull KtDeclaration declaration) {
        Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        PsiManager psiManager = owner.getManager();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiManager, (String)"owner.manager");
        KotlinLightTypeParameterListBuilder builder = new KotlinLightTypeParameterListBuilder(psiManager);
        if (declaration instanceof KtTypeParameterListOwner) {
            List<KtTypeParameter> parameters2 = ((KtTypeParameterListOwner)declaration).getTypeParameters();
            int n = 0;
            List<KtTypeParameter> list2 = parameters2;
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"parameters");
            int n2 = ((Collection)list2).size();
            while (n < n2) {
                void i;
                KtTypeParameter jetTypeParameter;
                KtTypeParameter ktTypeParameter = jetTypeParameter = parameters2.get((int)i);
                Intrinsics.checkExpressionValueIsNotNull((Object)ktTypeParameter, (String)"jetTypeParameter");
                String name = ktTypeParameter.getName();
                String string = name;
                if (string == null) {
                    string = "__no_name__";
                }
                String safeName = string;
                builder.addParameter(new KtLightTypeParameter(owner, (int)i, safeName));
                ++i;
            }
        }
        return builder;
    }

    private LightClassUtil() {
    }

    static {
        LightClassUtil lightClassUtil;
        INSTANCE = lightClassUtil = new LightClassUtil();
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010(\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B1\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0002\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\u0015H\u0096\u0002R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/asJava/LightClassUtil$PropertyAccessorsPsiMethods;", "", "Lcom/intellij/psi/PsiMethod;", "getter", "setter", "backingField", "Lcom/intellij/psi/PsiField;", "additionalAccessors", "", "(Lcom/intellij/psi/PsiMethod;Lcom/intellij/psi/PsiMethod;Lcom/intellij/psi/PsiField;Ljava/util/List;)V", "allDeclarations", "Lcom/intellij/psi/PsiNamedElement;", "getAllDeclarations", "()Ljava/util/List;", "allMethods", "getBackingField", "()Lcom/intellij/psi/PsiField;", "getGetter", "()Lcom/intellij/psi/PsiMethod;", "getSetter", "iterator", "", "light-classes"})
    public static final class PropertyAccessorsPsiMethods
    implements Iterable<PsiMethod>,
    KMappedMarker {
        private final List<PsiMethod> allMethods;
        @NotNull
        private final List<PsiNamedElement> allDeclarations;
        @Nullable
        private final PsiMethod getter;
        @Nullable
        private final PsiMethod setter;
        @Nullable
        private final PsiField backingField;

        @NotNull
        public final List<PsiNamedElement> getAllDeclarations() {
            return this.allDeclarations;
        }

        @Override
        @NotNull
        public Iterator<PsiMethod> iterator() {
            return this.allMethods.iterator();
        }

        @Nullable
        public final PsiMethod getGetter() {
            return this.getter;
        }

        @Nullable
        public final PsiMethod getSetter() {
            return this.setter;
        }

        @Nullable
        public final PsiField getBackingField() {
            return this.backingField;
        }

        /*
         * WARNING - void declaration
         */
        public PropertyAccessorsPsiMethods(@Nullable PsiMethod getter2, @Nullable PsiMethod setter2, @Nullable PsiField backingField, @NotNull List<? extends PsiMethod> additionalAccessors) {
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull(additionalAccessors, (String)"additionalAccessors");
            this.getter = getter2;
            this.setter = setter2;
            this.backingField = backingField;
            PropertyAccessorsPsiMethods propertyAccessorsPsiMethods = this;
            ArrayList arrayList = new ArrayList();
            propertyAccessorsPsiMethods.allMethods = arrayList;
            ArraysKt.filterNotNullTo((Object[])new PsiMethod[]{this.getter, this.setter}, (Collection)this.allMethods);
            Iterable iterable = additionalAccessors;
            Collection destination$iv = this.allMethods;
            for (Object element$iv : $receiver$iv) {
                if (!(element$iv instanceof PsiMethod)) continue;
                destination$iv.add(element$iv);
            }
            propertyAccessorsPsiMethods = this;
            arrayList = new ArrayList();
            propertyAccessorsPsiMethods.allDeclarations = arrayList;
            ArraysKt.filterNotNullTo((Object[])new PsiNamedElement[]{this.getter, this.setter, this.backingField}, (Collection)this.allDeclarations);
            ((ArrayList)this.allDeclarations).addAll((Collection)additionalAccessors);
        }
    }
}

