/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveState;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiElementFilter;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.PairProcessor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiTreeUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.util.PsiTreeUtil");
    private static final Key<Object> MARKER = Key.create("PsiTreeUtil.copyElements.MARKER");
    private static final Class[] WS = new Class[]{PsiWhiteSpace.class};
    private static final Class[] WS_COMMENTS = new Class[]{PsiWhiteSpace.class, PsiComment.class};

    @Contract(value="null, _, _ -> false")
    public static boolean isAncestor(@Nullable PsiElement ancestor, @NotNull PsiElement element, boolean strict) {
        PsiElement parent2;
        if (element == null) {
            PsiTreeUtil.$$$reportNull$$$0(0);
        }
        if (ancestor == null) {
            return false;
        }
        if ((ancestor instanceof StubBasedPsiElement && ((StubBasedPsiElement)ancestor).getStub() != null || element instanceof StubBasedPsiElement && ((StubBasedPsiElement)element).getStub() != null) && ancestor.getContainingFile() != element.getContainingFile()) {
            return false;
        }
        boolean stopAtFileLevel = !(ancestor instanceof PsiFile) && !(ancestor instanceof PsiDirectory);
        PsiElement psiElement = parent2 = strict ? element.getParent() : element;
        while (parent2 != null) {
            if (parent2.equals(ancestor)) {
                return true;
            }
            if (stopAtFileLevel && parent2 instanceof PsiFile) {
                return false;
            }
            parent2 = parent2.getParent();
        }
        return false;
    }

    @Contract(value="null, _, _ -> false")
    public static boolean isContextAncestor(@Nullable PsiElement ancestor, @NotNull PsiElement element, boolean strict) {
        PsiElement parent2;
        if (element == null) {
            PsiTreeUtil.$$$reportNull$$$0(1);
        }
        if (ancestor == null) {
            return false;
        }
        boolean stopAtFileLevel = !(ancestor instanceof PsiFile) && !(ancestor instanceof PsiDirectory);
        PsiElement psiElement = parent2 = strict ? element.getContext() : element;
        while (parent2 != null) {
            PsiElement context;
            if (parent2.equals(ancestor)) {
                return true;
            }
            if (stopAtFileLevel && parent2 instanceof PsiFile && (context = parent2.getContext()) == null) {
                return false;
            }
            parent2 = parent2.getContext();
        }
        return false;
    }

    @Nullable
    public static PsiElement findCommonParent(@NotNull List<? extends PsiElement> elements) {
        if (elements == null) {
            PsiTreeUtil.$$$reportNull$$$0(2);
        }
        if (elements.isEmpty()) {
            return null;
        }
        PsiElement toReturn = null;
        for (PsiElement psiElement : elements) {
            if (psiElement == null || (toReturn = toReturn == null ? psiElement : PsiTreeUtil.findCommonParent(toReturn, psiElement)) != null) continue;
            return null;
        }
        return toReturn;
    }

    @Nullable
    public static PsiElement findCommonParent(PsiElement ... elements) {
        if (elements == null) {
            PsiTreeUtil.$$$reportNull$$$0(3);
        }
        if (elements.length == 0) {
            return null;
        }
        PsiElement toReturn = null;
        for (PsiElement element : elements) {
            if (element == null) continue;
            PsiElement psiElement = toReturn = toReturn == null ? element : PsiTreeUtil.findCommonParent(toReturn, element);
            if (toReturn != null) continue;
            return null;
        }
        return toReturn;
    }

    @Nullable
    public static PsiElement findCommonParent(@NotNull PsiElement element1, @NotNull PsiElement element2) {
        int depth1;
        if (element1 == null) {
            PsiTreeUtil.$$$reportNull$$$0(4);
        }
        if (element2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(5);
        }
        if (element1 == element2) {
            return element1;
        }
        PsiFile containingFile = element1.getContainingFile();
        PsiFile topLevel = containingFile == element2.getContainingFile() ? containingFile : null;
        int depth2 = PsiTreeUtil.getDepth(element2, topLevel);
        PsiElement parent1 = element1;
        PsiElement parent2 = element2;
        for (depth1 = PsiTreeUtil.getDepth(element1, topLevel); depth1 > depth2; --depth1) {
            parent1 = parent1.getParent();
        }
        while (depth2 > depth1) {
            parent2 = parent2.getParent();
            --depth2;
        }
        while (parent1 != null && parent2 != null && !parent1.equals(parent2)) {
            parent1 = parent1.getParent();
            parent2 = parent2.getParent();
        }
        return parent1;
    }

    @Contract(pure=true)
    private static int getDepth(@NotNull PsiElement element, @Nullable PsiElement topLevel) {
        if (element == null) {
            PsiTreeUtil.$$$reportNull$$$0(6);
        }
        int depth = 0;
        for (PsiElement parent2 = element; parent2 != topLevel && parent2 != null; parent2 = parent2.getParent()) {
            ++depth;
        }
        return depth;
    }

    @Nullable
    public static PsiElement findCommonContext(@NotNull Collection<? extends PsiElement> elements) {
        if (elements == null) {
            PsiTreeUtil.$$$reportNull$$$0(7);
        }
        if (elements.isEmpty()) {
            return null;
        }
        PsiElement toReturn = null;
        for (PsiElement psiElement : elements) {
            if (psiElement == null || (toReturn = toReturn == null ? psiElement : PsiTreeUtil.findCommonContext(toReturn, psiElement)) != null) continue;
            return null;
        }
        return toReturn;
    }

    @Nullable
    public static PsiElement findCommonContext(@NotNull PsiElement element1, @NotNull PsiElement element2) {
        PsiElement parent1;
        if (element1 == null) {
            PsiTreeUtil.$$$reportNull$$$0(8);
        }
        if (element2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(9);
        }
        if (element1 == element2) {
            return element1;
        }
        PsiFile containingFile = element1.getContainingFile();
        PsiFile topLevel = containingFile == element2.getContainingFile() ? containingFile : null;
        int depth1 = PsiTreeUtil.getContextDepth(element1, topLevel);
        int depth2 = PsiTreeUtil.getContextDepth(element2, topLevel);
        PsiElement parent2 = element2;
        for (parent1 = element1; depth1 > depth2 && parent1 != null; parent1 = parent1.getContext(), --depth1) {
        }
        while (depth2 > depth1 && parent2 != null) {
            parent2 = parent2.getContext();
            --depth2;
        }
        while (parent1 != null && parent2 != null && !parent1.equals(parent2)) {
            parent1 = parent1.getContext();
            parent2 = parent2.getContext();
        }
        return parent1;
    }

    private static int getContextDepth(@NotNull PsiElement element, @Nullable PsiElement topLevel) {
        if (element == null) {
            PsiTreeUtil.$$$reportNull$$$0(10);
        }
        int depth = 0;
        for (PsiElement parent2 = element; parent2 != topLevel && parent2 != null; parent2 = parent2.getContext()) {
            ++depth;
        }
        return depth;
    }

    @Nullable
    @Contract(value="null, _ -> null")
    public static <T extends PsiElement> T findChildOfType(@Nullable PsiElement element, @NotNull Class<T> aClass2) {
        if (aClass2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(11);
        }
        return PsiTreeUtil.findChildOfAnyType(element, true, aClass2);
    }

    @Nullable
    @Contract(value="null, _, _ -> null")
    public static <T extends PsiElement> T findChildOfType(@Nullable PsiElement element, @NotNull Class<T> aClass2, boolean strict) {
        if (aClass2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(12);
        }
        return PsiTreeUtil.findChildOfAnyType(element, strict, aClass2);
    }

    @SafeVarargs
    @Nullable
    @Contract(value="null, _ -> null")
    public static <T extends PsiElement> T findChildOfAnyType(@Nullable PsiElement element, Class<? extends T> ... classes2) {
        if (classes2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(13);
        }
        return PsiTreeUtil.findChildOfAnyType(element, true, classes2);
    }

    @SafeVarargs
    @Nullable
    @Contract(value="null, _, _ -> null")
    public static <T extends PsiElement> T findChildOfAnyType(final @Nullable PsiElement element, final boolean strict, final Class<? extends T> ... classes2) {
        if (classes2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(14);
        }
        PsiElementProcessor.FindElement<PsiElement> processor = new PsiElementProcessor.FindElement<PsiElement>(){

            @Override
            public boolean execute(@NotNull PsiElement each) {
                if (each == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (strict && each == element) {
                    return true;
                }
                if (PsiTreeUtil.instanceOf(each, classes2)) {
                    return this.setFound(each);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "each", "com/intellij/psi/util/PsiTreeUtil$1", "execute"));
            }
        };
        PsiTreeUtil.processElements(element, processor);
        Object t = processor.getFoundElement();
        return t;
    }

    @NotNull
    public static <T extends PsiElement> Collection<T> findChildrenOfType(@Nullable PsiElement element, @NotNull Class<? extends T> aClass2) {
        if (aClass2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(15);
        }
        Collection<T> collection = PsiTreeUtil.findChildrenOfAnyType(element, aClass2);
        if (collection == null) {
            PsiTreeUtil.$$$reportNull$$$0(16);
        }
        return collection;
    }

    @SafeVarargs
    @NotNull
    public static <T extends PsiElement> Collection<T> findChildrenOfAnyType(final @Nullable PsiElement element, final Class<? extends T> ... classes2) {
        if (classes2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(17);
        }
        if (element == null) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                PsiTreeUtil.$$$reportNull$$$0(18);
            }
            return list2;
        }
        PsiElementProcessor.CollectElements processor = new PsiElementProcessor.CollectElements<T>(){

            @Override
            public boolean execute(@NotNull T each) {
                if (each == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (each == element) {
                    return true;
                }
                if (PsiTreeUtil.instanceOf(each, classes2)) {
                    return super.execute(each);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "each", "com/intellij/psi/util/PsiTreeUtil$2", "execute"));
            }
        };
        PsiTreeUtil.processElements(element, processor);
        Collection collection = processor.getCollection();
        if (collection == null) {
            PsiTreeUtil.$$$reportNull$$$0(19);
        }
        return collection;
    }

    @Nullable
    public static <T extends PsiElement> T getChildOfType(@Nullable PsiElement element, @NotNull Class<T> aClass2) {
        if (aClass2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(20);
        }
        if (element == null) {
            return null;
        }
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!aClass2.isInstance(child)) continue;
            PsiElement t = child;
            return (T)t;
        }
        return null;
    }

    @Nullable
    public static PsiElement findFirstParent(@Nullable PsiElement element, Condition<PsiElement> condition) {
        return PsiTreeUtil.findFirstParent(element, false, condition);
    }

    @Nullable
    public static PsiElement findFirstParent(@Nullable PsiElement element, boolean strict, Condition<PsiElement> condition) {
        if (strict && element != null) {
            element = element.getParent();
        }
        while (element != null) {
            if (condition.value(element)) {
                return element;
            }
            element = element.getParent();
        }
        return null;
    }

    @Nullable
    public static PsiElement findFirstContext(@Nullable PsiElement element, boolean strict, Condition<PsiElement> condition) {
        if (strict && element != null) {
            element = element.getContext();
        }
        while (element != null) {
            if (condition.value(element)) {
                return element;
            }
            element = element.getContext();
        }
        return null;
    }

    @NotNull
    public static <T extends PsiElement> T getRequiredChildOfType(@NotNull PsiElement element, @NotNull Class<T> aClass2) {
        if (element == null) {
            PsiTreeUtil.$$$reportNull$$$0(21);
        }
        if (aClass2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(22);
        }
        T child = PsiTreeUtil.getChildOfType(element, aClass2);
        assert (child != null) : "Missing required child of type " + aClass2.getName();
        T t = child;
        if (t == null) {
            PsiTreeUtil.$$$reportNull$$$0(23);
        }
        return t;
    }

    @Nullable
    public static <T extends PsiElement> T[] getChildrenOfType(@Nullable PsiElement element, @NotNull Class<T> aClass2) {
        if (aClass2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(24);
        }
        if (element == null) {
            return null;
        }
        SmartList<PsiElement> result2 = null;
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!aClass2.isInstance(child)) continue;
            if (result2 == null) {
                result2 = new SmartList<PsiElement>();
            }
            PsiElement t = child;
            result2.add(t);
        }
        return result2 == null ? null : (PsiElement[])ArrayUtil.toObjectArray(result2, aClass2);
    }

    @SafeVarargs
    @NotNull
    public static <T extends PsiElement> List<T> getChildrenOfAnyType(@Nullable PsiElement element, Class<? extends T> ... classes2) {
        if (classes2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(25);
        }
        if (element == null) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                PsiTreeUtil.$$$reportNull$$$0(26);
            }
            return list2;
        }
        List result2 = null;
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!PsiTreeUtil.instanceOf(child, classes2)) continue;
            if (result2 == null) {
                result2 = ContainerUtil.newSmartList();
            }
            PsiElement t = child;
            result2.add(t);
        }
        if (result2 == null) {
            List list3 = ContainerUtil.emptyList();
            if (list3 == null) {
                PsiTreeUtil.$$$reportNull$$$0(27);
            }
            return list3;
        }
        List list4 = result2;
        if (list4 == null) {
            PsiTreeUtil.$$$reportNull$$$0(28);
        }
        return list4;
    }

    @NotNull
    public static <T extends PsiElement> List<T> getChildrenOfTypeAsList(@Nullable PsiElement element, @NotNull Class<T> aClass2) {
        if (aClass2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(29);
        }
        if (element == null) {
            List list2 = Collections.emptyList();
            if (list2 == null) {
                PsiTreeUtil.$$$reportNull$$$0(30);
            }
            return list2;
        }
        SmartList<PsiElement> result2 = new SmartList<PsiElement>();
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!aClass2.isInstance(child)) continue;
            PsiElement t = child;
            result2.add(t);
        }
        SmartList<PsiElement> smartList = result2;
        if (smartList == null) {
            PsiTreeUtil.$$$reportNull$$$0(31);
        }
        return smartList;
    }

    @Nullable
    public static <T extends PsiElement> T getStubChildOfType(@Nullable PsiElement element, @NotNull Class<T> aClass2) {
        StubElement stub;
        if (aClass2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(32);
        }
        if (element == null) {
            return null;
        }
        StubElement stubElement = stub = element instanceof StubBasedPsiElement ? (StubElement)((StubBasedPsiElement)element).getStub() : null;
        if (stub == null) {
            return PsiTreeUtil.getChildOfType(element, aClass2);
        }
        for (StubElement childStub : stub.getChildrenStubs()) {
            Object child = childStub.getPsi();
            if (!aClass2.isInstance(child)) continue;
            Object t = child;
            return t;
        }
        return null;
    }

    @NotNull
    public static <T extends PsiElement> List<T> getStubChildrenOfTypeAsList(@Nullable PsiElement element, @NotNull Class<T> aClass2) {
        StubElement stub;
        if (aClass2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(33);
        }
        if (element == null) {
            List list2 = Collections.emptyList();
            if (list2 == null) {
                PsiTreeUtil.$$$reportNull$$$0(34);
            }
            return list2;
        }
        StubElement stubElement = stub = element instanceof StubBasedPsiElement ? (StubElement)((StubBasedPsiElement)element).getStub() : null;
        if (stub == null) {
            List<T> list3 = PsiTreeUtil.getChildrenOfTypeAsList(element, aClass2);
            if (list3 == null) {
                PsiTreeUtil.$$$reportNull$$$0(35);
            }
            return list3;
        }
        SmartList result2 = new SmartList();
        for (StubElement childStub : stub.getChildrenStubs()) {
            Object child = childStub.getPsi();
            if (!aClass2.isInstance(child)) continue;
            Object t = child;
            result2.add(t);
        }
        SmartList smartList = result2;
        if (smartList == null) {
            PsiTreeUtil.$$$reportNull$$$0(36);
        }
        return smartList;
    }

    public static boolean instanceOf(Object object, Class<?> ... classes2) {
        if (classes2 != null) {
            for (Class<?> c : classes2) {
                if (!c.isInstance(object)) continue;
                return true;
            }
        }
        return false;
    }

    @SafeVarargs
    @Nullable
    @Contract(value="null, _ -> null")
    public static <T extends PsiElement> T getChildOfAnyType(@Nullable PsiElement element, Class<? extends T> ... classes2) {
        if (classes2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(37);
        }
        if (element == null) {
            return null;
        }
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            for (Class<T> clazz : classes2) {
                if (!clazz.isInstance(child)) continue;
                PsiElement t = child;
                return (T)t;
            }
        }
        return null;
    }

    @Nullable
    @Contract(value="null, _ -> null")
    public static <T extends PsiElement> T getNextSiblingOfType(@Nullable PsiElement sibling, @NotNull Class<T> aClass2) {
        if (aClass2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(38);
        }
        if (sibling == null) {
            return null;
        }
        for (PsiElement child = sibling.getNextSibling(); child != null; child = child.getNextSibling()) {
            if (!aClass2.isInstance(child)) continue;
            PsiElement t = child;
            return (T)t;
        }
        return null;
    }

    @Nullable
    @Contract(value="null, _ -> null")
    public static <T extends PsiElement> T getPrevSiblingOfType(@Nullable PsiElement sibling, @NotNull Class<T> aClass2) {
        if (aClass2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(39);
        }
        if (sibling == null) {
            return null;
        }
        for (PsiElement child = sibling.getPrevSibling(); child != null; child = child.getPrevSibling()) {
            if (!aClass2.isInstance(child)) continue;
            PsiElement t = child;
            return (T)t;
        }
        return null;
    }

    @Nullable
    @Contract(value="null, _ -> null")
    public static <T extends PsiElement> T getTopmostParentOfType(@Nullable PsiElement element, @NotNull Class<T> aClass2) {
        T next;
        if (aClass2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(40);
        }
        T answer = PsiTreeUtil.getParentOfType(element, aClass2);
        while ((next = PsiTreeUtil.getParentOfType(answer, aClass2)) != null) {
            answer = next;
        }
        return answer;
    }

    @Nullable
    @Contract(value="null, _ -> null")
    public static <T extends PsiElement> T getParentOfType(@Nullable PsiElement element, @NotNull Class<T> aClass2) {
        if (aClass2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(41);
        }
        return PsiTreeUtil.getParentOfType(element, aClass2, true);
    }

    @Nullable
    @Contract(value="null -> null")
    public static PsiElement getStubOrPsiParent(@Nullable PsiElement element) {
        StubBase stub;
        if (element instanceof StubBasedPsiElement && (stub = (StubBase)((StubBasedPsiElement)element).getStub()) != null) {
            StubElement parentStub = stub.getParentStub();
            return parentStub != null ? (PsiElement)parentStub.getPsi() : null;
        }
        return element != null ? element.getParent() : null;
    }

    @Nullable
    @Contract(value="null, _ -> null")
    public static <E extends PsiElement> E getStubOrPsiParentOfType(@Nullable PsiElement element, @NotNull Class<E> parentClass) {
        StubBase stub;
        if (parentClass == null) {
            PsiTreeUtil.$$$reportNull$$$0(42);
        }
        if (element instanceof StubBasedPsiElement && (stub = (StubBase)((StubBasedPsiElement)element).getStub()) != null) {
            E e = stub.getParentStubOfType(parentClass);
            return e;
        }
        return PsiTreeUtil.getParentOfType(element, parentClass);
    }

    @SafeVarargs
    @Nullable
    @Contract(value="null, _, _, _ -> null")
    public static <T extends PsiElement> T getContextOfType(@Nullable PsiElement element, @NotNull Class<T> aClass2, boolean strict, Class<? extends PsiElement> ... stopAt) {
        if (aClass2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(43);
        }
        if (element == null) {
            return null;
        }
        if (strict) {
            element = element.getContext();
        }
        while (element != null && !aClass2.isInstance(element)) {
            if (PsiTreeUtil.instanceOf(element, stopAt)) {
                return null;
            }
            element = element.getContext();
        }
        PsiElement t = element;
        return (T)t;
    }

    @Nullable
    @Contract(value="null, _, _ -> null")
    public static <T extends PsiElement> T getContextOfType(@Nullable PsiElement element, @NotNull Class<? extends T> aClass2, boolean strict) {
        if (aClass2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(44);
        }
        return PsiTreeUtil.getContextOfType(element, strict, aClass2);
    }

    @SafeVarargs
    @Nullable
    public static <T extends PsiElement> T getContextOfType(@Nullable PsiElement element, Class<? extends T> ... classes2) {
        if (classes2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(45);
        }
        return PsiTreeUtil.getContextOfType(element, true, classes2);
    }

    @SafeVarargs
    @Nullable
    @Contract(value="null, _, _ -> null")
    public static <T extends PsiElement> T getContextOfType(@Nullable PsiElement element, boolean strict, Class<? extends T> ... classes2) {
        if (classes2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(46);
        }
        if (element == null) {
            return null;
        }
        if (strict) {
            element = element.getContext();
        }
        while (element != null && !PsiTreeUtil.instanceOf(element, classes2)) {
            element = element.getContext();
        }
        PsiElement t = element;
        return (T)t;
    }

    @Nullable
    @Contract(value="null, _, _ -> null")
    public static <T extends PsiElement> T getParentOfType(@Nullable PsiElement element, @NotNull Class<T> aClass2, boolean strict) {
        if (aClass2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(47);
        }
        return PsiTreeUtil.getParentOfType(element, aClass2, strict, -1);
    }

    @Contract(value="null, _, _, _ -> null")
    public static <T extends PsiElement> T getParentOfType(@Nullable PsiElement element, @NotNull Class<T> aClass2, boolean strict, int minStartOffset) {
        if (aClass2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(48);
        }
        if (element == null) {
            return null;
        }
        if (strict) {
            if (element instanceof PsiFile) {
                return null;
            }
            element = element.getParent();
        }
        while (element != null && (minStartOffset == -1 || element.getNode().getStartOffset() >= minStartOffset)) {
            if (aClass2.isInstance(element)) {
                PsiElement t = element;
                return (T)t;
            }
            if (element instanceof PsiFile) {
                return null;
            }
            element = element.getParent();
        }
        return null;
    }

    @SafeVarargs
    @Nullable
    @Contract(value="null, _, _, _ -> null")
    public static <T extends PsiElement> T getParentOfType(@Nullable PsiElement element, @NotNull Class<T> aClass2, boolean strict, Class<? extends PsiElement> ... stopAt) {
        if (aClass2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(49);
        }
        if (stopAt == null) {
            PsiTreeUtil.$$$reportNull$$$0(50);
        }
        if (element == null) {
            return null;
        }
        if (strict) {
            if (element instanceof PsiFile) {
                return null;
            }
            element = element.getParent();
        }
        while (element != null && !aClass2.isInstance(element)) {
            if (PsiTreeUtil.instanceOf(element, stopAt)) {
                return null;
            }
            if (element instanceof PsiFile) {
                return null;
            }
            element = element.getParent();
        }
        PsiElement t = element;
        return (T)t;
    }

    @Nullable
    public static PsiElement findSiblingForward(@NotNull PsiElement element, @NotNull IElementType elementType, @Nullable Consumer<PsiElement> consumer) {
        if (element == null) {
            PsiTreeUtil.$$$reportNull$$$0(51);
        }
        if (elementType == null) {
            PsiTreeUtil.$$$reportNull$$$0(52);
        }
        return PsiTreeUtil.findSiblingForward(element, elementType, true, consumer);
    }

    @Nullable
    public static PsiElement findSiblingForward(@NotNull PsiElement element, @NotNull IElementType elementType, boolean strict, @Nullable Consumer<PsiElement> consumer) {
        PsiElement e;
        if (element == null) {
            PsiTreeUtil.$$$reportNull$$$0(53);
        }
        if (elementType == null) {
            PsiTreeUtil.$$$reportNull$$$0(54);
        }
        PsiElement psiElement = e = strict ? element.getNextSibling() : element;
        while (e != null) {
            if (elementType.equals(e.getNode().getElementType())) {
                return e;
            }
            if (consumer != null) {
                consumer.consume(e);
            }
            e = e.getNextSibling();
        }
        return null;
    }

    @Nullable
    public static PsiElement findSiblingBackward(@NotNull PsiElement element, @NotNull IElementType elementType, @Nullable Consumer<PsiElement> consumer) {
        if (element == null) {
            PsiTreeUtil.$$$reportNull$$$0(55);
        }
        if (elementType == null) {
            PsiTreeUtil.$$$reportNull$$$0(56);
        }
        return PsiTreeUtil.findSiblingBackward(element, elementType, true, consumer);
    }

    @Nullable
    public static PsiElement findSiblingBackward(@NotNull PsiElement element, @NotNull IElementType elementType, boolean strict, @Nullable Consumer<PsiElement> consumer) {
        PsiElement e;
        if (element == null) {
            PsiTreeUtil.$$$reportNull$$$0(57);
        }
        if (elementType == null) {
            PsiTreeUtil.$$$reportNull$$$0(58);
        }
        PsiElement psiElement = e = strict ? element.getPrevSibling() : element;
        while (e != null) {
            if (elementType.equals(e.getNode().getElementType())) {
                return e;
            }
            if (consumer != null) {
                consumer.consume(e);
            }
            e = e.getPrevSibling();
        }
        return null;
    }

    @Nullable
    @Contract(value="null, _ -> null")
    public static PsiElement skipSiblingsForward(@Nullable PsiElement element, Class ... elementClasses) {
        if (elementClasses == null) {
            PsiTreeUtil.$$$reportNull$$$0(59);
        }
        if (element == null) {
            return null;
        }
        for (PsiElement e = element.getNextSibling(); e != null; e = e.getNextSibling()) {
            if (PsiTreeUtil.instanceOf(e, elementClasses)) continue;
            return e;
        }
        return null;
    }

    @Nullable
    @Contract(value="null -> null")
    public static PsiElement skipWhitespacesForward(@Nullable PsiElement element) {
        return PsiTreeUtil.skipSiblingsForward(element, WS);
    }

    @Nullable
    @Contract(value="null -> null")
    public static PsiElement skipWhitespacesAndCommentsForward(@Nullable PsiElement element) {
        return PsiTreeUtil.skipSiblingsForward(element, WS_COMMENTS);
    }

    @Nullable
    @Contract(value="null, _ -> null")
    public static PsiElement skipSiblingsBackward(@Nullable PsiElement element, Class ... elementClasses) {
        if (elementClasses == null) {
            PsiTreeUtil.$$$reportNull$$$0(60);
        }
        if (element == null) {
            return null;
        }
        for (PsiElement e = element.getPrevSibling(); e != null; e = e.getPrevSibling()) {
            if (PsiTreeUtil.instanceOf(e, elementClasses)) continue;
            return e;
        }
        return null;
    }

    @Nullable
    @Contract(value="null -> null")
    public static PsiElement skipWhitespacesBackward(@Nullable PsiElement element) {
        return PsiTreeUtil.skipSiblingsBackward(element, WS);
    }

    @Nullable
    @Contract(value="null -> null")
    public static PsiElement skipWhitespacesAndCommentsBackward(@Nullable PsiElement element) {
        return PsiTreeUtil.skipSiblingsBackward(element, WS_COMMENTS);
    }

    @Nullable
    @Contract(value="null, _ -> null")
    public static PsiElement skipParentsOfType(@Nullable PsiElement element, Class ... parentClasses) {
        if (parentClasses == null) {
            PsiTreeUtil.$$$reportNull$$$0(61);
        }
        if (element == null) {
            return null;
        }
        for (PsiElement e = element.getParent(); e != null; e = e.getParent()) {
            if (PsiTreeUtil.instanceOf(e, parentClasses)) continue;
            return e;
        }
        return null;
    }

    @SafeVarargs
    @Nullable
    @Contract(value="null, _ -> null")
    public static <T extends PsiElement> T getParentOfType(@Nullable PsiElement element, Class<? extends T> ... classes2) {
        if (classes2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(62);
        }
        if (element == null || element instanceof PsiFile) {
            return null;
        }
        PsiElement parent2 = element.getParent();
        if (parent2 == null) {
            return null;
        }
        return PsiTreeUtil.getNonStrictParentOfType(parent2, classes2);
    }

    @SafeVarargs
    @Nullable
    @Contract(value="null, _ -> null")
    public static <T extends PsiElement> T getNonStrictParentOfType(@Nullable PsiElement element, Class<? extends T> ... classes2) {
        if (classes2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(63);
        }
        for (PsiElement run2 = element; run2 != null; run2 = run2.getParent()) {
            if (PsiTreeUtil.instanceOf(run2, classes2)) {
                PsiElement t = run2;
                return (T)t;
            }
            if (run2 instanceof PsiFile) break;
        }
        return null;
    }

    @NotNull
    public static PsiElement[] collectElements(@Nullable PsiElement element, @NotNull PsiElementFilter filter2) {
        if (filter2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(64);
        }
        PsiElementProcessor.CollectFilteredElements processor = new PsiElementProcessor.CollectFilteredElements(filter2);
        PsiTreeUtil.processElements(element, processor);
        PsiElement[] psiElementArray = processor.toArray();
        if (psiElementArray == null) {
            PsiTreeUtil.$$$reportNull$$$0(65);
        }
        return psiElementArray;
    }

    @SafeVarargs
    @NotNull
    public static <T extends PsiElement> Collection<T> collectElementsOfType(@Nullable PsiElement element, Class<T> ... classes2) {
        if (classes2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(66);
        }
        PsiElementProcessor.CollectFilteredElements processor = new PsiElementProcessor.CollectFilteredElements(element1 -> {
            if (classes2 == null) {
                PsiTreeUtil.$$$reportNull$$$0(107);
            }
            for (Class clazz : classes2) {
                if (!clazz.isInstance(element1)) continue;
                return true;
            }
            return false;
        });
        PsiTreeUtil.processElements(element, processor);
        Collection collection = processor.getCollection();
        if (collection == null) {
            PsiTreeUtil.$$$reportNull$$$0(67);
        }
        return collection;
    }

    @Contract(value="null, _ -> true")
    public static boolean processElements(@Nullable PsiElement element, final @NotNull PsiElementProcessor processor) {
        if (processor == null) {
            PsiTreeUtil.$$$reportNull$$$0(68);
        }
        if (element == null) {
            return true;
        }
        if (element instanceof PsiCompiledElement || !element.isPhysical()) {
            if (!processor.execute(element)) {
                return false;
            }
            for (PsiElement child : element.getChildren()) {
                if (PsiTreeUtil.processElements(child, processor)) continue;
                return false;
            }
            return true;
        }
        final boolean[] result2 = new boolean[]{true};
        element.accept(new PsiRecursiveElementWalkingVisitor(){

            @Override
            public void visitElement(PsiElement element) {
                if (processor.execute(element)) {
                    super.visitElement(element);
                } else {
                    this.stopWalking();
                    result2[0] = false;
                }
            }
        });
        return result2[0];
    }

    public static boolean processElements(@NotNull PsiElementProcessor processor, PsiElement ... elements) {
        if (processor == null) {
            PsiTreeUtil.$$$reportNull$$$0(69);
        }
        if (elements == null || elements.length == 0) {
            return true;
        }
        for (PsiElement element : elements) {
            if (PsiTreeUtil.processElements(element, processor)) continue;
            return false;
        }
        return true;
    }

    public static void mark(@NotNull PsiElement element, @NotNull Object marker) {
        if (element == null) {
            PsiTreeUtil.$$$reportNull$$$0(70);
        }
        if (marker == null) {
            PsiTreeUtil.$$$reportNull$$$0(71);
        }
        element.putCopyableUserData(MARKER, marker);
    }

    @Nullable
    public static PsiElement releaseMark(@NotNull PsiElement root2, @NotNull Object marker) {
        if (root2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(72);
        }
        if (marker == null) {
            PsiTreeUtil.$$$reportNull$$$0(73);
        }
        if (marker.equals(root2.getCopyableUserData(MARKER))) {
            root2.putCopyableUserData(MARKER, null);
            return root2;
        }
        for (PsiElement child = root2.getFirstChild(); child != null; child = child.getNextSibling()) {
            PsiElement result2 = PsiTreeUtil.releaseMark(child, marker);
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }

    @Nullable
    public static <T extends PsiElement> T findElementOfClassAtOffset(@NotNull PsiFile file2, int offset2, @NotNull Class<T> clazz, boolean strictStart) {
        if (file2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(74);
        }
        if (clazz == null) {
            PsiTreeUtil.$$$reportNull$$$0(75);
        }
        List<PsiFile> psiRoots = file2.getViewProvider().getAllFiles();
        PsiElement result2 = null;
        for (PsiElement psiElement : psiRoots) {
            T parent2;
            PsiElement elementAt2 = psiElement.findElementAt(offset2);
            if (elementAt2 == null || (parent2 = PsiTreeUtil.getParentOfType(elementAt2, clazz, strictStart)) == null) continue;
            TextRange range = parent2.getTextRange();
            if (strictStart && range.getStartOffset() != offset2 || result2 != null && result2.getTextRange().getEndOffset() <= range.getEndOffset()) continue;
            result2 = parent2;
        }
        return (T)result2;
    }

    @SafeVarargs
    @Nullable
    public static <T extends PsiElement> T findElementOfClassAtOffsetWithStopSet(@NotNull PsiFile file2, int offset2, @NotNull Class<T> clazz, boolean strictStart, Class<? extends PsiElement> ... stopAt) {
        if (file2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(76);
        }
        if (clazz == null) {
            PsiTreeUtil.$$$reportNull$$$0(77);
        }
        if (stopAt == null) {
            PsiTreeUtil.$$$reportNull$$$0(78);
        }
        List<PsiFile> psiRoots = file2.getViewProvider().getAllFiles();
        PsiElement result2 = null;
        for (PsiElement psiElement : psiRoots) {
            T parent2;
            PsiElement elementAt2 = psiElement.findElementAt(offset2);
            if (elementAt2 == null || (parent2 = PsiTreeUtil.getParentOfType(elementAt2, clazz, strictStart, stopAt)) == null) continue;
            TextRange range = parent2.getTextRange();
            if (strictStart && range.getStartOffset() != offset2 || result2 != null && result2.getTextRange().getEndOffset() <= range.getEndOffset()) continue;
            result2 = parent2;
        }
        return (T)result2;
    }

    @Nullable
    public static <T extends PsiElement> T findElementOfClassAtRange(@NotNull PsiFile file2, int startOffset, int endOffset, @NotNull Class<T> clazz) {
        if (file2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(79);
        }
        if (clazz == null) {
            PsiTreeUtil.$$$reportNull$$$0(80);
        }
        FileViewProvider viewProvider = file2.getViewProvider();
        PsiElement result2 = null;
        for (Language lang : viewProvider.getLanguages()) {
            T run2;
            PsiElement elementAt2 = viewProvider.findElementAt(startOffset, lang);
            T prev = run2 = PsiTreeUtil.getParentOfType(elementAt2, clazz, false);
            while (run2 != null && run2.getTextRange().getStartOffset() == startOffset && run2.getTextRange().getEndOffset() <= endOffset) {
                prev = run2;
                run2 = PsiTreeUtil.getParentOfType(run2, clazz);
            }
            if (prev == null) continue;
            int elementStartOffset = prev.getTextRange().getStartOffset();
            int elementEndOffset = prev.getTextRange().getEndOffset();
            if (elementStartOffset != startOffset || elementEndOffset > endOffset || result2 != null && result2.getTextRange().getEndOffset() >= elementEndOffset) continue;
            result2 = prev;
        }
        return (T)result2;
    }

    @NotNull
    public static PsiElement getDeepestFirst(@NotNull PsiElement elt) {
        if (elt == null) {
            PsiTreeUtil.$$$reportNull$$$0(81);
        }
        PsiElement res2 = elt;
        while (true) {
            PsiElement firstChild;
            if ((firstChild = res2.getFirstChild()) == null) {
                PsiElement psiElement = res2;
                if (psiElement == null) {
                    PsiTreeUtil.$$$reportNull$$$0(82);
                }
                return psiElement;
            }
            res2 = firstChild;
        }
    }

    @NotNull
    public static PsiElement getDeepestLast(@NotNull PsiElement elt) {
        if (elt == null) {
            PsiTreeUtil.$$$reportNull$$$0(83);
        }
        PsiElement res2 = elt;
        while (true) {
            PsiElement lastChild;
            if ((lastChild = res2.getLastChild()) == null) {
                PsiElement psiElement = res2;
                if (psiElement == null) {
                    PsiTreeUtil.$$$reportNull$$$0(84);
                }
                return psiElement;
            }
            res2 = lastChild;
        }
    }

    @Nullable
    public static PsiElement prevLeaf(@NotNull PsiElement current) {
        PsiElement prevSibling;
        if (current == null) {
            PsiTreeUtil.$$$reportNull$$$0(85);
        }
        if ((prevSibling = current.getPrevSibling()) != null) {
            return PsiTreeUtil.lastChild(prevSibling);
        }
        PsiElement parent2 = current.getParent();
        if (parent2 == null || parent2 instanceof PsiFile) {
            return null;
        }
        return PsiTreeUtil.prevLeaf(parent2);
    }

    @Nullable
    public static PsiElement nextLeaf(@NotNull PsiElement current) {
        PsiElement nextSibling;
        if (current == null) {
            PsiTreeUtil.$$$reportNull$$$0(86);
        }
        if ((nextSibling = current.getNextSibling()) != null) {
            return PsiTreeUtil.firstChild(nextSibling);
        }
        PsiElement parent2 = current.getParent();
        if (parent2 == null || parent2 instanceof PsiFile) {
            return null;
        }
        return PsiTreeUtil.nextLeaf(parent2);
    }

    public static PsiElement lastChild(@NotNull PsiElement element) {
        PsiElement lastChild;
        if (element == null) {
            PsiTreeUtil.$$$reportNull$$$0(87);
        }
        if ((lastChild = element.getLastChild()) != null) {
            return PsiTreeUtil.lastChild(lastChild);
        }
        return element;
    }

    public static PsiElement firstChild(@NotNull PsiElement element) {
        PsiElement child;
        if (element == null) {
            PsiTreeUtil.$$$reportNull$$$0(88);
        }
        if ((child = element.getFirstChild()) != null) {
            return PsiTreeUtil.firstChild(child);
        }
        return element;
    }

    @Nullable
    public static PsiElement prevLeaf(@NotNull PsiElement element, boolean skipEmptyElements) {
        if (element == null) {
            PsiTreeUtil.$$$reportNull$$$0(89);
        }
        PsiElement prevLeaf = PsiTreeUtil.prevLeaf(element);
        while (skipEmptyElements && prevLeaf != null && prevLeaf.getTextLength() == 0) {
            prevLeaf = PsiTreeUtil.prevLeaf(prevLeaf);
        }
        return prevLeaf;
    }

    @Nullable
    public static PsiElement prevVisibleLeaf(@NotNull PsiElement element) {
        if (element == null) {
            PsiTreeUtil.$$$reportNull$$$0(90);
        }
        PsiElement prevLeaf = PsiTreeUtil.prevLeaf(element, true);
        while (prevLeaf != null && StringUtil.isEmptyOrSpaces(prevLeaf.getText())) {
            prevLeaf = PsiTreeUtil.prevLeaf(prevLeaf, true);
        }
        return prevLeaf;
    }

    @Nullable
    public static PsiElement nextVisibleLeaf(@NotNull PsiElement element) {
        if (element == null) {
            PsiTreeUtil.$$$reportNull$$$0(91);
        }
        PsiElement nextLeaf = PsiTreeUtil.nextLeaf(element, true);
        while (nextLeaf != null && StringUtil.isEmptyOrSpaces(nextLeaf.getText())) {
            nextLeaf = PsiTreeUtil.nextLeaf(nextLeaf, true);
        }
        return nextLeaf;
    }

    @Nullable
    public static PsiElement nextLeaf(PsiElement element, boolean skipEmptyElements) {
        PsiElement nextLeaf = PsiTreeUtil.nextLeaf(element);
        while (skipEmptyElements && nextLeaf != null && nextLeaf.getTextLength() == 0) {
            nextLeaf = PsiTreeUtil.nextLeaf(nextLeaf);
        }
        return nextLeaf;
    }

    public static boolean hasErrorElements(@NotNull PsiElement element) {
        if (element == null) {
            PsiTreeUtil.$$$reportNull$$$0(92);
        }
        return !SyntaxTraverser.psiTraverser(element).traverse().filter(PsiErrorElement.class).isEmpty();
    }

    @NotNull
    public static PsiElement[] filterAncestors(@NotNull PsiElement[] elements) {
        int previousSize;
        if (elements == null) {
            PsiTreeUtil.$$$reportNull$$$0(93);
        }
        if (LOG.isDebugEnabled()) {
            for (PsiElement element : elements) {
                LOG.debug("element = " + element);
            }
        }
        ArrayList filteredElements = new ArrayList();
        ContainerUtil.addAll(filteredElements, elements);
        block1: do {
            previousSize = filteredElements.size();
            for (PsiElement element : filteredElements) {
                for (PsiElement element2 : filteredElements) {
                    if (element == element2 || !PsiTreeUtil.isAncestor(element, element2, false)) continue;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("removing " + element2);
                    }
                    filteredElements.remove(element2);
                    continue block1;
                }
            }
        } while (filteredElements.size() != previousSize);
        if (LOG.isDebugEnabled()) {
            for (PsiElement element : filteredElements) {
                LOG.debug("filtered element = " + element);
            }
        }
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(filteredElements);
        if (psiElementArray == null) {
            PsiTreeUtil.$$$reportNull$$$0(94);
        }
        return psiElementArray;
    }

    public static boolean treeWalkUp(@NotNull PsiScopeProcessor processor, @NotNull PsiElement entrance, @Nullable PsiElement maxScope, @NotNull ResolveState state2) {
        if (processor == null) {
            PsiTreeUtil.$$$reportNull$$$0(95);
        }
        if (entrance == null) {
            PsiTreeUtil.$$$reportNull$$$0(96);
        }
        if (state2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(97);
        }
        PsiElement prevParent = entrance;
        PsiElement scope = entrance;
        while (scope != null) {
            if (!scope.processDeclarations(processor, state2, prevParent, entrance)) {
                return false;
            }
            if (scope == maxScope) break;
            prevParent = scope;
            scope = prevParent.getContext();
        }
        return true;
    }

    public static boolean treeWalkUp(@NotNull PsiElement entrance, @Nullable PsiElement maxScope, PairProcessor<PsiElement, PsiElement> eachScopeAndLastParent) {
        if (entrance == null) {
            PsiTreeUtil.$$$reportNull$$$0(98);
        }
        PsiElement prevParent = null;
        PsiElement scope = entrance;
        while (scope != null) {
            if (!eachScopeAndLastParent.process(scope, prevParent)) {
                return false;
            }
            if (scope == maxScope) break;
            prevParent = scope;
            scope = prevParent.getContext();
        }
        return true;
    }

    @NotNull
    public static PsiElement findPrevParent(@NotNull PsiElement ancestor, @NotNull PsiElement descendant) {
        if (ancestor == null) {
            PsiTreeUtil.$$$reportNull$$$0(99);
        }
        if (descendant == null) {
            PsiTreeUtil.$$$reportNull$$$0(100);
        }
        PsiElement cur = descendant;
        while (cur != null) {
            PsiElement parent2 = cur.getParent();
            if (parent2 == ancestor) {
                PsiElement psiElement = cur;
                if (psiElement == null) {
                    PsiTreeUtil.$$$reportNull$$$0(101);
                }
                return psiElement;
            }
            cur = parent2;
        }
        throw new AssertionError((Object)(descendant + " is not a descendant of " + ancestor));
    }

    public static List<PsiElement> getInjectedElements(@NotNull OuterLanguageElement outerLanguageElement) {
        if (outerLanguageElement == null) {
            PsiTreeUtil.$$$reportNull$$$0(102);
        }
        PsiFile psi = outerLanguageElement.getContainingFile().getViewProvider().getPsi(outerLanguageElement.getLanguage());
        TextRange injectionRange = outerLanguageElement.getTextRange();
        ArrayList<PsiElement> res2 = ContainerUtil.newArrayList();
        assert (psi != null) : outerLanguageElement;
        for (PsiElement element = psi.findElementAt(injectionRange.getStartOffset()); element != null && injectionRange.intersectsStrict(element.getTextRange()); element = element.getNextSibling()) {
            res2.add(element);
        }
        return res2;
    }

    @Nullable
    public static PsiElement getDeepestVisibleFirst(@NotNull PsiElement psiElement) {
        PsiElement first2;
        if (psiElement == null) {
            PsiTreeUtil.$$$reportNull$$$0(103);
        }
        if (StringUtil.isEmptyOrSpaces((first2 = PsiTreeUtil.getDeepestFirst(psiElement)).getText())) {
            first2 = PsiTreeUtil.nextVisibleLeaf(first2);
        }
        return first2;
    }

    @Nullable
    public static PsiElement getDeepestVisibleLast(@NotNull PsiElement psiElement) {
        PsiElement last2;
        if (psiElement == null) {
            PsiTreeUtil.$$$reportNull$$$0(104);
        }
        if (StringUtil.isEmptyOrSpaces((last2 = PsiTreeUtil.getDeepestLast(psiElement)).getText())) {
            last2 = PsiTreeUtil.prevVisibleLeaf(last2);
        }
        return last2;
    }

    @Deprecated
    public static <T extends PsiElement> Iterator<T> childIterator(@NotNull PsiElement element, @NotNull Class<T> aClass2) {
        if (element == null) {
            PsiTreeUtil.$$$reportNull$$$0(105);
        }
        if (aClass2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(106);
        }
        return SyntaxTraverser.psiTraverser().children(element).filter(aClass2).iterator();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 16: 
            case 18: 
            case 19: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 34: 
            case 35: 
            case 36: 
            case 65: 
            case 67: 
            case 82: 
            case 84: 
            case 94: 
            case 101: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 16: 
            case 18: 
            case 19: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 34: 
            case 35: 
            case 36: 
            case 65: 
            case 67: 
            case 82: 
            case 84: 
            case 94: 
            case 101: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element1";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element2";
                break;
            }
            case 11: 
            case 12: 
            case 15: 
            case 20: 
            case 22: 
            case 24: 
            case 29: 
            case 32: 
            case 33: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 47: 
            case 48: 
            case 49: 
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 13: 
            case 14: 
            case 17: 
            case 25: 
            case 37: 
            case 45: 
            case 46: 
            case 62: 
            case 63: 
            case 66: 
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
            case 16: 
            case 18: 
            case 19: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 34: 
            case 35: 
            case 36: 
            case 65: 
            case 67: 
            case 82: 
            case 84: 
            case 94: 
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/util/PsiTreeUtil";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentClass";
                break;
            }
            case 50: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stopAt";
                break;
            }
            case 52: 
            case 54: 
            case 56: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 59: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementClasses";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentClasses";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 68: 
            case 69: 
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 71: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "marker";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 74: 
            case 76: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 75: 
            case 77: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 81: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elt";
                break;
            }
            case 85: 
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "current";
                break;
            }
            case 96: 
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entrance";
                break;
            }
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ancestor";
                break;
            }
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descendant";
                break;
            }
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outerLanguageElement";
                break;
            }
            case 103: 
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/util/PsiTreeUtil";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "findChildrenOfType";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "findChildrenOfAnyType";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequiredChildOfType";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenOfAnyType";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenOfTypeAsList";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getStubChildrenOfTypeAsList";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "collectElements";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "collectElementsOfType";
                break;
            }
            case 82: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeepestFirst";
                break;
            }
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeepestLast";
                break;
            }
            case 94: {
                objectArray = objectArray2;
                objectArray2[1] = "filterAncestors";
                break;
            }
            case 101: {
                objectArray = objectArray2;
                objectArray2[1] = "findPrevParent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAncestor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isContextAncestor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findCommonParent";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDepth";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findCommonContext";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getContextDepth";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findChildOfType";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findChildOfAnyType";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findChildrenOfType";
                break;
            }
            case 16: 
            case 18: 
            case 19: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 34: 
            case 35: 
            case 36: 
            case 65: 
            case 67: 
            case 82: 
            case 84: 
            case 94: 
            case 101: {
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findChildrenOfAnyType";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getChildOfType";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getRequiredChildOfType";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getChildrenOfType";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getChildrenOfAnyType";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getChildrenOfTypeAsList";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getStubChildOfType";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getStubChildrenOfTypeAsList";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getChildOfAnyType";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getNextSiblingOfType";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getPrevSiblingOfType";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getTopmostParentOfType";
                break;
            }
            case 41: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "getParentOfType";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getStubOrPsiParentOfType";
                break;
            }
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getContextOfType";
                break;
            }
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "findSiblingForward";
                break;
            }
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "findSiblingBackward";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "skipSiblingsForward";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "skipSiblingsBackward";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "skipParentsOfType";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "getNonStrictParentOfType";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "collectElements";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "collectElementsOfType";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "processElements";
                break;
            }
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "mark";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "releaseMark";
                break;
            }
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "findElementOfClassAtOffset";
                break;
            }
            case 76: 
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "findElementOfClassAtOffsetWithStopSet";
                break;
            }
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "findElementOfClassAtRange";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "getDeepestFirst";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "getDeepestLast";
                break;
            }
            case 85: 
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "prevLeaf";
                break;
            }
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "nextLeaf";
                break;
            }
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "lastChild";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "firstChild";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "prevVisibleLeaf";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "nextVisibleLeaf";
                break;
            }
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "hasErrorElements";
                break;
            }
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "filterAncestors";
                break;
            }
            case 95: 
            case 96: 
            case 97: 
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "treeWalkUp";
                break;
            }
            case 99: 
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "findPrevParent";
                break;
            }
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "getInjectedElements";
                break;
            }
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "getDeepestVisibleFirst";
                break;
            }
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "getDeepestVisibleLast";
                break;
            }
            case 105: 
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "childIterator";
                break;
            }
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "lambda$collectElementsOfType$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 16: 
            case 18: 
            case 19: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 34: 
            case 35: 
            case 36: 
            case 65: 
            case 67: 
            case 82: 
            case 84: 
            case 94: 
            case 101: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

