/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.nio;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.xnio.FileChangeCallback;
import org.xnio.FileChangeEvent;
import org.xnio.FileSystemWatcher;
import org.xnio.IoUtils;
import org.xnio.nio.Log;

class WatchServiceFileSystemWatcher
implements FileSystemWatcher,
Runnable {
    private static final AtomicInteger threadIdCounter = new AtomicInteger(0);
    public static final String THREAD_NAME = "xnio-file-watcher";
    private WatchService watchService;
    private final Map<File, PathData> files = Collections.synchronizedMap(new HashMap());
    private final Map<WatchKey, PathData> pathDataByKey = Collections.synchronizedMap(new IdentityHashMap());
    private volatile boolean stopped = false;
    private final Thread watchThread;

    WatchServiceFileSystemWatcher(String name, boolean daemon) {
        try {
            this.watchService = FileSystems.getDefault().newWatchService();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.watchThread = new Thread((Runnable)this, "xnio-file-watcher[" + name + "]-" + threadIdCounter);
        this.watchThread.setDaemon(daemon);
        this.watchThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.stopped) {
            try {
                WatchKey key = this.watchService.take();
                if (key == null) continue;
                try {
                    PathData pathData = this.pathDataByKey.get(key);
                    if (pathData == null) continue;
                    ArrayList<FileChangeEvent> results = new ArrayList<FileChangeEvent>();
                    List<WatchEvent<?>> events = key.pollEvents();
                    HashSet<File> addedFiles = new HashSet<File>();
                    HashSet<File> deletedFiles = new HashSet<File>();
                    for (WatchEvent<?> watchEvent : events) {
                        FileChangeEvent.Type type;
                        Path eventPath = (Path)watchEvent.context();
                        File targetFile = ((Path)key.watchable()).resolve(eventPath).toFile();
                        if (watchEvent.kind() == StandardWatchEventKinds.ENTRY_CREATE) {
                            type = FileChangeEvent.Type.ADDED;
                            addedFiles.add(targetFile);
                            if (targetFile.isDirectory()) {
                                try {
                                    this.addWatchedDirectory(pathData, targetFile);
                                }
                                catch (IOException e) {
                                    Log.log.debugf(e, "Could not add watched directory %s", targetFile);
                                }
                            }
                        } else if (watchEvent.kind() == StandardWatchEventKinds.ENTRY_MODIFY) {
                            type = FileChangeEvent.Type.MODIFIED;
                        } else {
                            if (watchEvent.kind() != StandardWatchEventKinds.ENTRY_DELETE) continue;
                            type = FileChangeEvent.Type.REMOVED;
                            deletedFiles.add(targetFile);
                        }
                        results.add(new FileChangeEvent(targetFile, type));
                    }
                    key.pollEvents().clear();
                    Iterator it = results.iterator();
                    while (it.hasNext()) {
                        FileChangeEvent fileChangeEvent = (FileChangeEvent)it.next();
                        if (fileChangeEvent.getType() == FileChangeEvent.Type.MODIFIED) {
                            if (addedFiles.contains(fileChangeEvent.getFile()) && deletedFiles.contains(fileChangeEvent.getFile()) || !addedFiles.contains(fileChangeEvent.getFile()) && !deletedFiles.contains(fileChangeEvent.getFile())) continue;
                            it.remove();
                            continue;
                        }
                        if (fileChangeEvent.getType() == FileChangeEvent.Type.ADDED) {
                            if (!deletedFiles.contains(fileChangeEvent.getFile())) continue;
                            it.remove();
                            continue;
                        }
                        if (fileChangeEvent.getType() != FileChangeEvent.Type.REMOVED || !addedFiles.contains(fileChangeEvent.getFile())) continue;
                        it.remove();
                    }
                    if (results.isEmpty()) continue;
                    for (FileChangeCallback callback : pathData.callbacks) {
                        WatchServiceFileSystemWatcher.invokeCallback(callback, results);
                    }
                }
                finally {
                    if (key.reset()) continue;
                    this.files.remove(key.watchable());
                }
            }
            catch (InterruptedException key) {
            }
            catch (ClosedWatchServiceException cwse) {
                break;
            }
        }
    }

    public synchronized void watchPath(File file, FileChangeCallback callback) {
        try {
            PathData data = this.files.get(file);
            if (data == null) {
                Set<File> allDirectories = WatchServiceFileSystemWatcher.doScan(file).keySet();
                Path path = Paths.get(file.toURI());
                data = new PathData(path);
                for (File dir : allDirectories) {
                    this.addWatchedDirectory(data, dir);
                }
                this.files.put(file, data);
            }
            data.callbacks.add(callback);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void addWatchedDirectory(PathData data, File dir) throws IOException {
        Path path = Paths.get(dir.toURI());
        WatchKey key = path.register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
        this.pathDataByKey.put(key, data);
        data.keys.add(key);
    }

    public synchronized void unwatchPath(File file, FileChangeCallback callback) {
        PathData data = this.files.get(file);
        if (data != null) {
            data.callbacks.remove(callback);
            if (data.callbacks.isEmpty()) {
                this.files.remove(file);
                for (WatchKey key : data.keys) {
                    key.cancel();
                    this.pathDataByKey.remove(key);
                }
            }
        }
    }

    public void close() throws IOException {
        this.stopped = true;
        this.watchThread.interrupt();
        IoUtils.safeClose((Closeable)this.watchService);
    }

    private static Map<File, Long> doScan(File file) {
        HashMap<File, Long> results = new HashMap<File, Long>();
        ArrayDeque<File> toScan = new ArrayDeque<File>();
        toScan.add(file);
        while (!toScan.isEmpty()) {
            File next = (File)toScan.pop();
            if (!next.isDirectory()) continue;
            results.put(next, next.lastModified());
            File[] list = next.listFiles();
            if (list == null) continue;
            for (File f : list) {
                toScan.push(new File(f.getAbsolutePath()));
            }
        }
        return results;
    }

    private static void invokeCallback(FileChangeCallback callback, List<FileChangeEvent> results) {
        try {
            callback.handleChanges(results);
        }
        catch (Exception e) {
            Log.log.failedToInvokeFileWatchCallback(e);
        }
    }

    private class PathData {
        final Path path;
        final List<FileChangeCallback> callbacks = new ArrayList<FileChangeCallback>();
        final List<WatchKey> keys = new ArrayList<WatchKey>();

        private PathData(Path path) {
            this.path = path;
        }
    }
}

