/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi.impl;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.library.GenerateLibrary;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.nfi.impl.NativeArgumentBuffer;

@GenerateLibrary
@GenerateLibrary.DefaultExport.Repeat(value={@GenerateLibrary.DefaultExport(value=CharConversion.class), @GenerateLibrary.DefaultExport(value=BooleanArrayConversion.class), @GenerateLibrary.DefaultExport(value=ByteArrayConversion.class), @GenerateLibrary.DefaultExport(value=ShortArrayConversion.class), @GenerateLibrary.DefaultExport(value=CharArrayConversion.class), @GenerateLibrary.DefaultExport(value=IntArrayConversion.class), @GenerateLibrary.DefaultExport(value=LongArrayConversion.class), @GenerateLibrary.DefaultExport(value=FloatArrayConversion.class), @GenerateLibrary.DefaultExport(value=DoubleArrayConversion.class), @GenerateLibrary.DefaultExport(value=DefaultConversion.class)})
abstract class SerializeArgumentLibrary
extends Library {
    private static final LibraryFactory<SerializeArgumentLibrary> FACTORY = LibraryFactory.resolve(SerializeArgumentLibrary.class);

    SerializeArgumentLibrary() {
    }

    public void putByte(Object arg, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
        throw UnsupportedTypeException.create((Object[])new Object[]{arg});
    }

    public void putUByte(Object arg, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
        throw UnsupportedTypeException.create((Object[])new Object[]{arg});
    }

    public void putShort(Object arg, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
        throw UnsupportedTypeException.create((Object[])new Object[]{arg});
    }

    public void putUShort(Object arg, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
        throw UnsupportedTypeException.create((Object[])new Object[]{arg});
    }

    public void putInt(Object arg, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
        throw UnsupportedTypeException.create((Object[])new Object[]{arg});
    }

    public void putUInt(Object arg, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
        throw UnsupportedTypeException.create((Object[])new Object[]{arg});
    }

    public void putLong(Object arg, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
        throw UnsupportedTypeException.create((Object[])new Object[]{arg});
    }

    public void putULong(Object arg, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
        throw UnsupportedTypeException.create((Object[])new Object[]{arg});
    }

    public void putFloat(Object arg, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
        throw UnsupportedTypeException.create((Object[])new Object[]{arg});
    }

    public void putDouble(Object arg, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
        throw UnsupportedTypeException.create((Object[])new Object[]{arg});
    }

    public void putPointer(Object arg, NativeArgumentBuffer buffer, int ptrSize) throws UnsupportedTypeException {
        throw UnsupportedTypeException.create((Object[])new Object[]{arg});
    }

    public void putString(Object arg, NativeArgumentBuffer buffer, int ptrSize) throws UnsupportedTypeException {
        throw UnsupportedTypeException.create((Object[])new Object[]{arg});
    }

    public static LibraryFactory<SerializeArgumentLibrary> getFactory() {
        return FACTORY;
    }

    public static SerializeArgumentLibrary getUncached() {
        return (SerializeArgumentLibrary)FACTORY.getUncached();
    }

    @ExportLibrary(value=SerializeArgumentLibrary.class, receiverType=double[].class)
    static abstract class DoubleArrayConversion {
        DoubleArrayConversion() {
        }

        @ExportMessage
        static void putPointer(double[] receiver, NativeArgumentBuffer buffer, int ptrSize) {
            buffer.putObject(NativeArgumentBuffer.TypeTag.DOUBLE_ARRAY, receiver, ptrSize);
        }
    }

    @ExportLibrary(value=SerializeArgumentLibrary.class, receiverType=float[].class)
    static abstract class FloatArrayConversion {
        FloatArrayConversion() {
        }

        @ExportMessage
        static void putPointer(float[] receiver, NativeArgumentBuffer buffer, int ptrSize) {
            buffer.putObject(NativeArgumentBuffer.TypeTag.FLOAT_ARRAY, receiver, ptrSize);
        }
    }

    @ExportLibrary(value=SerializeArgumentLibrary.class, receiverType=long[].class)
    static abstract class LongArrayConversion {
        LongArrayConversion() {
        }

        @ExportMessage
        static void putPointer(long[] receiver, NativeArgumentBuffer buffer, int ptrSize) {
            buffer.putObject(NativeArgumentBuffer.TypeTag.LONG_ARRAY, receiver, ptrSize);
        }
    }

    @ExportLibrary(value=SerializeArgumentLibrary.class, receiverType=int[].class)
    static abstract class IntArrayConversion {
        IntArrayConversion() {
        }

        @ExportMessage
        static void putPointer(int[] receiver, NativeArgumentBuffer buffer, int ptrSize) {
            buffer.putObject(NativeArgumentBuffer.TypeTag.INT_ARRAY, receiver, ptrSize);
        }
    }

    @ExportLibrary(value=SerializeArgumentLibrary.class, receiverType=char[].class)
    static abstract class CharArrayConversion {
        CharArrayConversion() {
        }

        @ExportMessage
        static void putPointer(char[] receiver, NativeArgumentBuffer buffer, int ptrSize) {
            buffer.putObject(NativeArgumentBuffer.TypeTag.CHAR_ARRAY, receiver, ptrSize);
        }
    }

    @ExportLibrary(value=SerializeArgumentLibrary.class, receiverType=short[].class)
    static abstract class ShortArrayConversion {
        ShortArrayConversion() {
        }

        @ExportMessage
        static void putPointer(short[] receiver, NativeArgumentBuffer buffer, int ptrSize) {
            buffer.putObject(NativeArgumentBuffer.TypeTag.SHORT_ARRAY, receiver, ptrSize);
        }
    }

    @ExportLibrary(value=SerializeArgumentLibrary.class, receiverType=byte[].class)
    static abstract class ByteArrayConversion {
        ByteArrayConversion() {
        }

        @ExportMessage
        static void putPointer(byte[] receiver, NativeArgumentBuffer buffer, int ptrSize) {
            buffer.putObject(NativeArgumentBuffer.TypeTag.BYTE_ARRAY, receiver, ptrSize);
        }
    }

    @ExportLibrary(value=SerializeArgumentLibrary.class, receiverType=boolean[].class)
    static abstract class BooleanArrayConversion {
        BooleanArrayConversion() {
        }

        @ExportMessage
        static void putPointer(boolean[] receiver, NativeArgumentBuffer buffer, int ptrSize) {
            buffer.putObject(NativeArgumentBuffer.TypeTag.BOOLEAN_ARRAY, receiver, ptrSize);
        }
    }

    @ExportLibrary(value=SerializeArgumentLibrary.class, receiverType=Character.class)
    static abstract class CharConversion {
        CharConversion() {
        }

        static int zero() {
            return 0;
        }

        @ExportMessage
        static void putByte(Character ch, NativeArgumentBuffer buffer, @CachedLibrary(value="zero()") SerializeArgumentLibrary serialize) throws UnsupportedTypeException {
            serialize.putByte(ch.charValue(), buffer);
        }

        @ExportMessage
        static void putUByte(Character ch, NativeArgumentBuffer buffer, @CachedLibrary(value="zero()") SerializeArgumentLibrary serialize) throws UnsupportedTypeException {
            serialize.putUByte(ch.charValue(), buffer);
        }

        @ExportMessage
        static void putShort(Character ch, NativeArgumentBuffer buffer, @CachedLibrary(value="zero()") SerializeArgumentLibrary serialize) throws UnsupportedTypeException {
            serialize.putShort(ch.charValue(), buffer);
        }

        @ExportMessage
        static void putUShort(Character ch, NativeArgumentBuffer buffer, @CachedLibrary(value="zero()") SerializeArgumentLibrary serialize) throws UnsupportedTypeException {
            serialize.putUShort(ch.charValue(), buffer);
        }

        @ExportMessage
        static void putInt(Character ch, NativeArgumentBuffer buffer, @CachedLibrary(value="zero()") SerializeArgumentLibrary serialize) throws UnsupportedTypeException {
            serialize.putInt(ch.charValue(), buffer);
        }

        @ExportMessage
        static void putUInt(Character ch, NativeArgumentBuffer buffer, @CachedLibrary(value="zero()") SerializeArgumentLibrary serialize) throws UnsupportedTypeException {
            serialize.putUInt(ch.charValue(), buffer);
        }

        @ExportMessage
        static void putLong(Character ch, NativeArgumentBuffer buffer, @CachedLibrary(value="zero()") SerializeArgumentLibrary serialize) throws UnsupportedTypeException {
            serialize.putLong(ch.charValue(), buffer);
        }

        @ExportMessage
        static void putULong(Character ch, NativeArgumentBuffer buffer, @CachedLibrary(value="zero()") SerializeArgumentLibrary serialize) throws UnsupportedTypeException {
            serialize.putULong(ch.charValue(), buffer);
        }

        @ExportMessage
        static void putFloat(Character ch, NativeArgumentBuffer buffer, @CachedLibrary(value="zero()") SerializeArgumentLibrary serialize) throws UnsupportedTypeException {
            serialize.putFloat(ch.charValue(), buffer);
        }

        @ExportMessage
        static void putDouble(Character ch, NativeArgumentBuffer buffer, @CachedLibrary(value="zero()") SerializeArgumentLibrary serialize) throws UnsupportedTypeException {
            serialize.putDouble(ch.charValue(), buffer);
        }
    }

    @ExportLibrary(value=SerializeArgumentLibrary.class, receiverType=Object.class)
    static abstract class DefaultConversion {
        DefaultConversion() {
        }

        @ExportMessage
        static void putByte(Object arg, NativeArgumentBuffer buffer, @Cached.Shared(value="exception") @Cached BranchProfile exception, @CachedLibrary(value="arg") InteropLibrary interop) throws UnsupportedTypeException {
            try {
                if (interop.isNumber(arg)) {
                    buffer.putInt8(interop.asByte(arg));
                    return;
                }
            }
            catch (UnsupportedMessageException unsupportedMessageException) {
                // empty catch block
            }
            exception.enter();
            try {
                buffer.putInt8(interop.asBoolean(arg) ? (byte)1 : 0);
            }
            catch (UnsupportedMessageException ex2) {
                throw UnsupportedTypeException.create((Object[])new Object[]{arg});
            }
        }

        @ExportMessage
        static void putUByte(Object arg, NativeArgumentBuffer buffer, @Cached.Shared(value="exception") @Cached BranchProfile exception, @CachedLibrary(value="arg") InteropLibrary interop) throws UnsupportedTypeException {
            try {
                if (interop.isNumber(arg)) {
                    short nr = interop.asShort(arg);
                    buffer.putInt8((byte)nr);
                    return;
                }
            }
            catch (UnsupportedMessageException nr) {
                // empty catch block
            }
            exception.enter();
            try {
                buffer.putInt8(interop.asBoolean(arg) ? (byte)1 : 0);
            }
            catch (UnsupportedMessageException ex2) {
                throw UnsupportedTypeException.create((Object[])new Object[]{arg});
            }
        }

        @ExportMessage
        static void putShort(Object arg, NativeArgumentBuffer buffer, @Cached.Shared(value="exception") @Cached BranchProfile exception, @CachedLibrary(value="arg") InteropLibrary interop) throws UnsupportedTypeException {
            try {
                if (interop.isNumber(arg)) {
                    buffer.putInt16(interop.asShort(arg));
                    return;
                }
            }
            catch (UnsupportedMessageException unsupportedMessageException) {
                // empty catch block
            }
            exception.enter();
            try {
                buffer.putInt16(interop.asBoolean(arg) ? (short)1 : 0);
            }
            catch (UnsupportedMessageException ex2) {
                throw UnsupportedTypeException.create((Object[])new Object[]{arg});
            }
        }

        @ExportMessage
        static void putUShort(Object arg, NativeArgumentBuffer buffer, @Cached.Shared(value="exception") @Cached BranchProfile exception, @CachedLibrary(value="arg") InteropLibrary interop) throws UnsupportedTypeException {
            try {
                if (interop.isNumber(arg)) {
                    int nr = interop.asInt(arg);
                    buffer.putInt16((short)nr);
                    return;
                }
            }
            catch (UnsupportedMessageException nr) {
                // empty catch block
            }
            exception.enter();
            try {
                buffer.putInt16(interop.asBoolean(arg) ? (short)1 : 0);
            }
            catch (UnsupportedMessageException ex2) {
                throw UnsupportedTypeException.create((Object[])new Object[]{arg});
            }
        }

        @ExportMessage
        static void putInt(Object arg, NativeArgumentBuffer buffer, @Cached.Shared(value="exception") @Cached BranchProfile exception, @CachedLibrary(value="arg") InteropLibrary interop) throws UnsupportedTypeException {
            try {
                if (interop.isNumber(arg)) {
                    buffer.putInt32(interop.asInt(arg));
                    return;
                }
            }
            catch (UnsupportedMessageException unsupportedMessageException) {
                // empty catch block
            }
            exception.enter();
            try {
                buffer.putInt32(interop.asBoolean(arg) ? 1 : 0);
            }
            catch (UnsupportedMessageException ex2) {
                throw UnsupportedTypeException.create((Object[])new Object[]{arg});
            }
        }

        @ExportMessage
        static void putUInt(Object arg, NativeArgumentBuffer buffer, @Cached.Shared(value="exception") @Cached BranchProfile exception, @CachedLibrary(value="arg") InteropLibrary interop) throws UnsupportedTypeException {
            try {
                if (interop.isNumber(arg)) {
                    long nr = interop.asLong(arg);
                    buffer.putInt32((int)nr);
                    return;
                }
            }
            catch (UnsupportedMessageException nr) {
                // empty catch block
            }
            exception.enter();
            try {
                buffer.putInt32(interop.asBoolean(arg) ? 1 : 0);
            }
            catch (UnsupportedMessageException ex2) {
                throw UnsupportedTypeException.create((Object[])new Object[]{arg});
            }
        }

        @ExportMessage.Repeat(value={@ExportMessage, @ExportMessage(name="putULong")})
        static void putLong(Object arg, NativeArgumentBuffer buffer, @Cached.Shared(value="exception") @Cached BranchProfile exception, @CachedLibrary(value="arg") InteropLibrary interop) throws UnsupportedTypeException {
            try {
                if (interop.isNumber(arg)) {
                    buffer.putInt64(interop.asLong(arg));
                    return;
                }
            }
            catch (UnsupportedMessageException unsupportedMessageException) {
                // empty catch block
            }
            exception.enter();
            try {
                buffer.putInt64(interop.asBoolean(arg) ? 1L : 0L);
            }
            catch (UnsupportedMessageException ex2) {
                throw UnsupportedTypeException.create((Object[])new Object[]{arg});
            }
        }

        @ExportMessage
        static void putFloat(Object arg, NativeArgumentBuffer buffer, @Cached.Shared(value="exception") @Cached BranchProfile exception, @CachedLibrary(value="arg") InteropLibrary interop) throws UnsupportedTypeException {
            try {
                if (interop.isNumber(arg)) {
                    buffer.putFloat(interop.asFloat(arg));
                    return;
                }
            }
            catch (UnsupportedMessageException unsupportedMessageException) {
                // empty catch block
            }
            exception.enter();
            try {
                buffer.putFloat(interop.asBoolean(arg) ? 1.0f : 0.0f);
            }
            catch (UnsupportedMessageException ex2) {
                throw UnsupportedTypeException.create((Object[])new Object[]{arg});
            }
        }

        @ExportMessage
        static void putDouble(Object arg, NativeArgumentBuffer buffer, @Cached.Shared(value="exception") @Cached BranchProfile exception, @CachedLibrary(value="arg") InteropLibrary interop) throws UnsupportedTypeException {
            try {
                if (interop.isNumber(arg)) {
                    buffer.putDouble(interop.asDouble(arg));
                    return;
                }
            }
            catch (UnsupportedMessageException unsupportedMessageException) {
                // empty catch block
            }
            exception.enter();
            try {
                buffer.putDouble(interop.asBoolean(arg) ? 1.0 : 0.0);
            }
            catch (UnsupportedMessageException ex2) {
                throw UnsupportedTypeException.create((Object[])new Object[]{arg});
            }
        }

        @ExportMessage
        static class PutString {
            PutString() {
            }

            @Specialization(guards={"interop.isString(arg)"}, rewriteOn={UnsupportedMessageException.class})
            static void putString(Object arg, NativeArgumentBuffer buffer, int ptrSize, @CachedLibrary(value="arg") InteropLibrary interop) throws UnsupportedMessageException {
                buffer.putObject(NativeArgumentBuffer.TypeTag.STRING, interop.asString(arg), ptrSize);
            }

            @Specialization(guards={"!interop.isString(arg)", "interop.isNull(arg)"})
            static void putNull(Object arg, NativeArgumentBuffer buffer, int ptrSize, @CachedLibrary(value="arg") InteropLibrary interop) {
                buffer.putPointer(0L, ptrSize);
            }

            @Specialization(replaces={"putString", "putNull"})
            static void putGeneric(Object arg, NativeArgumentBuffer buffer, int ptrSize, @CachedLibrary(value="arg") InteropLibrary interop, @Cached.Shared(value="exception") @Cached BranchProfile exception) throws UnsupportedTypeException {
                try {
                    if (interop.isString(arg)) {
                        buffer.putObject(NativeArgumentBuffer.TypeTag.STRING, interop.asString(arg), ptrSize);
                        return;
                    }
                }
                catch (UnsupportedMessageException unsupportedMessageException) {
                    // empty catch block
                }
                exception.enter();
                if (!interop.isNull(arg)) {
                    throw UnsupportedTypeException.create((Object[])new Object[]{arg});
                }
                buffer.putPointer(0L, ptrSize);
            }
        }

        @ExportMessage
        static class PutPointer {
            PutPointer() {
            }

            @Specialization(guards={"interop.isPointer(arg)"}, rewriteOn={UnsupportedMessageException.class})
            static void putPointer(Object arg, NativeArgumentBuffer buffer, int ptrSize, @CachedLibrary(value="arg") InteropLibrary interop) throws UnsupportedMessageException {
                buffer.putPointer(interop.asPointer(arg), ptrSize);
            }

            @Specialization(guards={"!interop.isPointer(arg)", "interop.isNull(arg)"})
            static void putNull(Object arg, NativeArgumentBuffer buffer, int ptrSize, @CachedLibrary(value="arg") InteropLibrary interop) {
                buffer.putPointer(0L, ptrSize);
            }

            @Specialization(replaces={"putPointer", "putNull"})
            static void putGeneric(Object arg, NativeArgumentBuffer buffer, int ptrSize, @CachedLibrary(value="arg") InteropLibrary interop, @Cached.Shared(value="exception") @Cached BranchProfile exception) throws UnsupportedTypeException {
                try {
                    interop.toNative(arg);
                    if (interop.isPointer(arg)) {
                        buffer.putPointer(interop.asPointer(arg), ptrSize);
                        return;
                    }
                }
                catch (UnsupportedMessageException unsupportedMessageException) {
                    // empty catch block
                }
                exception.enter();
                if (interop.isNull(arg)) {
                    buffer.putPointer(0L, ptrSize);
                    return;
                }
                try {
                    if (interop.isNumber(arg)) {
                        buffer.putPointer(interop.asLong(arg), ptrSize);
                        return;
                    }
                }
                catch (UnsupportedMessageException unsupportedMessageException) {
                    // empty catch block
                }
                try {
                    buffer.putPointer(interop.asPointer(arg), ptrSize);
                    return;
                }
                catch (UnsupportedMessageException unsupportedMessageException) {
                    throw UnsupportedTypeException.create((Object[])new Object[]{arg});
                }
            }
        }
    }
}

