/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.automaton;

import com.oracle.truffle.regex.tregex.automaton.StateSetBackingSet;
import com.oracle.truffle.regex.util.CompilationFinalBitSet;
import java.util.PrimitiveIterator;

public class StateSetBackingBitSet
implements StateSetBackingSet {
    private final CompilationFinalBitSet bitSet;

    public StateSetBackingBitSet(int stateIndexSize) {
        this.bitSet = new CompilationFinalBitSet(stateIndexSize);
    }

    private StateSetBackingBitSet(StateSetBackingBitSet copy) {
        this.bitSet = copy.bitSet.copy();
    }

    @Override
    public StateSetBackingSet copy() {
        return new StateSetBackingBitSet(this);
    }

    @Override
    public boolean contains(short id) {
        return this.bitSet.get(id);
    }

    @Override
    public boolean add(short id) {
        if (this.bitSet.get(id)) {
            return false;
        }
        this.bitSet.set(id);
        return true;
    }

    @Override
    public void addBatch(short id) {
        this.bitSet.set(id);
    }

    @Override
    public void addBatchFinish() {
    }

    @Override
    public void replace(short oldId, short newId) {
        this.bitSet.clear(oldId);
        this.bitSet.set(newId);
    }

    @Override
    public boolean remove(short id) {
        if (this.bitSet.get(id)) {
            this.bitSet.clear(id);
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.bitSet.clear();
    }

    @Override
    public boolean isDisjoint(StateSetBackingSet other) {
        return this.bitSet.isDisjoint(((StateSetBackingBitSet)other).bitSet);
    }

    @Override
    public boolean contains(StateSetBackingSet other) {
        return this.bitSet.contains(((StateSetBackingBitSet)other).bitSet);
    }

    @Override
    public PrimitiveIterator.OfInt iterator() {
        return this.bitSet.iterator();
    }

    public int hashCode() {
        return this.bitSet.hashCode();
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof StateSetBackingBitSet && this.bitSet.equals(((StateSetBackingBitSet)obj).bitSet);
    }
}

