/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.regex.CachingRegexEngine;
import com.oracle.truffle.regex.RegexCompilerWithFallback;
import com.oracle.truffle.regex.RegexEngine;
import com.oracle.truffle.regex.RegexLanguage;
import com.oracle.truffle.regex.RegexLanguageObject;
import com.oracle.truffle.regex.RegexOptions;
import com.oracle.truffle.regex.runtime.nodes.ToStringNode;
import com.oracle.truffle.regex.tregex.TRegexCompiler;

@ExportLibrary(value=InteropLibrary.class)
public class RegexEngineBuilder
implements RegexLanguageObject {
    private final RegexLanguage language;

    public RegexEngineBuilder(RegexLanguage language) {
        this.language = language;
    }

    public static boolean isInstance(TruffleObject object) {
        return object instanceof RegexEngineBuilder;
    }

    @ExportMessage
    public boolean isExecutable() {
        return true;
    }

    @ExportMessage
    Object execute(Object[] args, @Cached ToStringNode expectOptionsNode, @CachedLibrary(limit="1") InteropLibrary fallbackCompilers) throws ArityException, UnsupportedTypeException {
        if (args.length > 2) {
            CompilerDirectives.transferToInterpreter();
            throw ArityException.create((int)2, (int)args.length);
        }
        RegexOptions options = RegexOptions.DEFAULT;
        if (args.length >= 1) {
            options = RegexOptions.parse(expectOptionsNode.execute(args[0]));
        }
        TruffleObject fallbackCompiler = null;
        if (args.length >= 2) {
            if (!fallbackCompilers.isExecutable(args[1])) {
                CompilerDirectives.transferToInterpreter();
                throw UnsupportedTypeException.create((Object[])args);
            }
            fallbackCompiler = (TruffleObject)args[1];
        }
        return RegexEngineBuilder.createRegexEngine(this.language, options, fallbackCompiler);
    }

    @CompilerDirectives.TruffleBoundary
    private static RegexEngine createRegexEngine(RegexLanguage regexLanguage, RegexOptions options, TruffleObject fallbackCompiler) {
        if (fallbackCompiler != null) {
            return new CachingRegexEngine(new RegexCompilerWithFallback(new TRegexCompiler(regexLanguage, options), fallbackCompiler), options);
        }
        return new CachingRegexEngine(new TRegexCompiler(regexLanguage, options), options);
    }
}

