/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.wadl.processor;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Set;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.process.Inflector;
import org.glassfish.jersey.server.ExtendedUriInfo;
import org.glassfish.jersey.server.model.ModelProcessor;
import org.glassfish.jersey.server.model.ResourceModel;
import org.glassfish.jersey.server.model.internal.ModelProcessorUtil;

@Priority(value=0x7FFFFFFF)
public class OptionsMethodProcessor
implements ModelProcessor {
    private final List<ModelProcessorUtil.Method> methodList = Lists.newArrayList();

    public OptionsMethodProcessor() {
        this.methodList.add(new ModelProcessorUtil.Method("OPTIONS", MediaType.WILDCARD_TYPE, MediaType.TEXT_PLAIN_TYPE, PlainTextOptionsInflector.class));
        this.methodList.add(new ModelProcessorUtil.Method("OPTIONS", MediaType.WILDCARD_TYPE, MediaType.WILDCARD_TYPE, GenericOptionsInflector.class));
    }

    @Override
    public ResourceModel processResourceModel(ResourceModel resourceModel, Configuration configuration) {
        return ModelProcessorUtil.enhanceResourceModel(resourceModel, false, this.methodList).build();
    }

    @Override
    public ResourceModel processSubResource(ResourceModel subResourceModel, Configuration configuration) {
        return ModelProcessorUtil.enhanceResourceModel(subResourceModel, true, this.methodList).build();
    }

    private static class GenericOptionsInflector
    implements Inflector<ContainerRequestContext, Response> {
        @Inject
        private ExtendedUriInfo extendedUriInfo;

        private GenericOptionsInflector() {
        }

        public Response apply(ContainerRequestContext containerRequestContext) {
            Set<String> allowedMethods = ModelProcessorUtil.getAllowedMethods(this.extendedUriInfo.getMatchedRuntimeResources().get(0));
            return Response.ok().allow(allowedMethods).header("Content-Length", (Object)"0").type((MediaType)containerRequestContext.getAcceptableMediaTypes().get(0)).build();
        }
    }

    private static class PlainTextOptionsInflector
    implements Inflector<ContainerRequestContext, Response> {
        @Inject
        private ExtendedUriInfo extendedUriInfo;

        private PlainTextOptionsInflector() {
        }

        public Response apply(ContainerRequestContext containerRequestContext) {
            Set<String> allowedMethods = ModelProcessorUtil.getAllowedMethods(this.extendedUriInfo.getMatchedRuntimeResources().get(0));
            String allowedList = allowedMethods.toString();
            String optionsBody = allowedList.substring(1, allowedList.length() - 1);
            return Response.ok((Object)optionsBody, (MediaType)MediaType.TEXT_PLAIN_TYPE).allow(allowedMethods).build();
        }
    }
}

