/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.scanning;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.NoSuchElementException;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.jersey.server.ResourceFinder;

public final class JarFileScanner
implements ResourceFinder {
    private final JarInputStream jarInputStream;
    private final String parent;
    private final boolean recursive;
    private JarEntry next = null;

    public JarFileScanner(InputStream inputStream, String parent, boolean recursive) throws IOException {
        this.jarInputStream = new JarInputStream(inputStream);
        this.parent = parent;
        this.recursive = recursive;
    }

    @Override
    public boolean hasNext() {
        if (this.next == null) {
            try {
                String suffix;
                do {
                    this.next = this.jarInputStream.getNextJarEntry();
                } while (this.next != null && (this.next.isDirectory() || !this.next.getName().startsWith(this.parent) || !this.recursive && (suffix = this.next.getName().substring(this.parent.length())).lastIndexOf(File.separatorChar) > 0));
            }
            catch (IOException e) {
                Logger.getLogger(JarFileScanner.class.getName()).log(Level.CONFIG, "Unable to read the next jar entry.", e);
                return false;
            }
            catch (SecurityException e) {
                Logger.getLogger(JarFileScanner.class.getName()).log(Level.CONFIG, "Unable to read the next jar entry.", e);
                return false;
            }
        }
        if (this.next == null) {
            try {
                this.jarInputStream.close();
            }
            catch (IOException e) {
                Logger.getLogger(JarFileScanner.class.getName()).log(Level.FINE, "Unable to close jar file.", e);
            }
            return false;
        }
        return true;
    }

    @Override
    public String next() {
        if (this.next != null || this.hasNext()) {
            String name = this.next.getName();
            this.next = null;
            return name;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public InputStream open() {
        return this.jarInputStream;
    }

    @Override
    public void reset() {
        throw new UnsupportedOperationException();
    }
}

