/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.internal.inject;

import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.glassfish.jersey.internal.LocalizationMessages;

public class HttpHeadersInjectee
implements HttpHeaders {
    private HttpHeaders wrapped;

    public void set(HttpHeaders httpHeaders) {
        if (this.wrapped != null) {
            throw new IllegalStateException(LocalizationMessages.HTTP_HEADERS_WAS_ALREADY_SET());
        }
        this.wrapped = httpHeaders;
    }

    public List<String> getRequestHeader(String name) {
        this.checkState();
        return this.wrapped.getRequestHeader(name);
    }

    public String getHeaderString(String name) {
        this.checkState();
        return this.wrapped.getHeaderString(name);
    }

    public MultivaluedMap<String, String> getRequestHeaders() {
        this.checkState();
        return this.wrapped.getRequestHeaders();
    }

    public List<MediaType> getAcceptableMediaTypes() {
        this.checkState();
        return this.wrapped.getAcceptableMediaTypes();
    }

    public List<Locale> getAcceptableLanguages() {
        this.checkState();
        return this.wrapped.getAcceptableLanguages();
    }

    public MediaType getMediaType() {
        this.checkState();
        return this.wrapped.getMediaType();
    }

    public Locale getLanguage() {
        this.checkState();
        return this.wrapped.getLanguage();
    }

    public Map<String, Cookie> getCookies() {
        this.checkState();
        return this.wrapped.getCookies();
    }

    public Date getDate() {
        this.checkState();
        return this.wrapped.getDate();
    }

    public int getLength() {
        this.checkState();
        return this.wrapped.getLength();
    }

    private void checkState() {
        if (this.wrapped == null) {
            throw new IllegalStateException(LocalizationMessages.HTTP_HEADERS_WAS_NOT_SET());
        }
    }
}

